/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.ssl;

import com.sleepycat.je.rep.net.InstanceParams;
import com.sleepycat.je.rep.net.PasswordSource;
import java.io.File;
import java.io.IOException;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;

public abstract class KeyStorePasswordSource
implements PasswordSource {
    private static final String DEF_KEYSTORE_PASSWORD_ALIAS = "keystore";

    protected KeyStorePasswordSource() {
    }

    public char[] getPassword() {
        PasswordStore pwdStore = this.getPasswordStore();
        String pwdAlias = this.getPasswordAlias();
        try {
            char[] secret = pwdStore.getSecret(pwdAlias);
            return secret;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to retrieve password from password store");
        }
    }

    protected abstract PasswordStore getPasswordStore();

    protected abstract String getPasswordAlias();

    public abstract String getParamString();

    public static KeyStorePasswordSource create(SecurityParams sp) {
        String walletDir;
        String pwdAlias = sp.getKeystorePasswordAlias();
        if (pwdAlias == null) {
            pwdAlias = DEF_KEYSTORE_PASSWORD_ALIAS;
        }
        if ((walletDir = sp.getWalletDir()) != null && walletDir.length() > 0) {
            return new WalletPasswordSource(sp.resolveFile(walletDir).getPath(), pwdAlias);
        }
        String pwdFile = sp.getPasswordFile();
        if (pwdFile != null && pwdFile.length() > 0) {
            String pwdClass = sp.getPasswordClass();
            if (pwdClass == null || pwdClass.length() == 0) {
                pwdClass = "oracle.kv.impl.security.filestore.FileStoreManager";
            }
            return new FilePasswordSource(sp.resolveFile(pwdFile).getPath(), pwdClass, pwdAlias);
        }
        return null;
    }

    public static class FilePasswordSource
    extends KeyStorePasswordSource {
        private final File storeFile;
        private final String managerClassName;
        private final String alias;

        public FilePasswordSource(InstanceParams params) throws IllegalArgumentException {
            String[] paramSplits = FilePasswordSource.decodeParams(params.getClassParams());
            this.alias = paramSplits[0];
            this.managerClassName = paramSplits[1];
            this.storeFile = new File(paramSplits[2]);
        }

        private FilePasswordSource(String storeFile, String managerClassName, String alias) {
            this.storeFile = new File(storeFile);
            this.managerClassName = managerClassName;
            this.alias = alias;
        }

        @Override
        protected PasswordStore getPasswordStore() {
            try {
                PasswordManager pwdMgr = PasswordManager.load(this.managerClassName);
                PasswordStore pwdStore = pwdMgr.getStoreHandle(this.storeFile);
                pwdStore.open(null);
                return pwdStore;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access the configured password store", e);
            }
        }

        @Override
        protected String getPasswordAlias() {
            return this.alias;
        }

        @Override
        public String getParamString() {
            return this.alias + ":" + this.managerClassName + ":" + this.storeFile.getPath();
        }

        private static String[] decodeParams(String params) {
            String[] splits = params.split(":", 3);
            if (splits.length != 3) {
                throw new IllegalArgumentException("params does not have valid format");
            }
            return splits;
        }
    }

    public static class WalletPasswordSource
    extends KeyStorePasswordSource {
        private final File walletDir;
        private final String alias;

        public WalletPasswordSource(InstanceParams params) throws IllegalArgumentException {
            String[] paramSplits = WalletPasswordSource.decodeParams(params.getClassParams());
            this.alias = paramSplits[0];
            this.walletDir = new File(paramSplits[1]);
        }

        public WalletPasswordSource(String walletDir, String alias) {
            this.walletDir = new File(walletDir);
            this.alias = alias;
        }

        @Override
        protected PasswordStore getPasswordStore() {
            try {
                PasswordManager pwdMgr = PasswordManager.load("oracle.kv.impl.security.wallet.WalletManager");
                PasswordStore pwdStore = pwdMgr.getStoreHandle(this.walletDir);
                pwdStore.open(null);
                return pwdStore;
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access the configured wallet store", e);
            }
        }

        @Override
        protected String getPasswordAlias() {
            return this.alias;
        }

        @Override
        public String getParamString() {
            return this.alias + ":" + this.walletDir.getPath();
        }

        private static String[] decodeParams(String params) throws IllegalArgumentException {
            String[] splits = params.split(":", 2);
            if (splits.length != 2) {
                throw new IllegalArgumentException("params does not have valid format");
            }
            return splits;
        }
    }
}

