/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.FaultException;
import oracle.kv.KVStore;
import oracle.kv.KVStoreException;
import oracle.kv.KerberosCredentials;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.ReauthenticateHandler;
import oracle.kv.impl.security.PasswordManager;
import oracle.kv.impl.security.PasswordStore;
import oracle.kv.impl.security.login.AdminLoginManager;
import oracle.kv.impl.security.login.KerberosClientCreds;
import oracle.kv.impl.security.login.RepNodeLoginManager;
import oracle.kv.impl.security.util.SecurityUtils;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.shell.ShellInputReader;

public class KVStoreLogin {
    public static final String PWD_MANAGER = "oracle.kv.auth.pwdfile.manager";
    private static final String WALLET_MANAGER_CLASS = "oracle.kv.impl.security.wallet.WalletManager";
    private static final String DEFAULT_FILESTORE_MANAGER_CLASS = "oracle.kv.impl.security.filestore.FileStoreManager";
    private static final String KERBEROS_LOGIN_HELPER_CLASS = "oracle.kv.impl.security.kerberos.KerberosLoginHelper";
    private String userName;
    private String securityFilePath;
    private Properties securityProps = null;
    private ShellInputReader reader = null;
    private static final Set<String> fileProperties = new HashSet<String>();

    public KVStoreLogin() {
        this(null, null);
    }

    public KVStoreLogin(String user, String security) {
        this.userName = user;
        this.securityFilePath = security;
    }

    public String getUserName() {
        return this.userName;
    }

    public void updateLoginInfo(String user, String security) {
        this.userName = user;
        this.securityFilePath = security;
        this.loadSecurityProperties();
    }

    public Properties getSecurityProperties() {
        return this.securityProps;
    }

    public void loadSecurityProperties() {
        if (this.securityFilePath == null) {
            this.securityFilePath = System.getProperty("oracle.kv.security");
        }
        this.securityProps = KVStoreLogin.createSecurityProperties(this.securityFilePath);
        if (this.securityProps != null && this.userName == null) {
            this.userName = this.securityProps.getProperty("oracle.kv.auth.username");
        }
        if (this.securityFilePath != null && !this.foundTransportSettings()) {
            throw new IllegalArgumentException("A security file was specified, but the file does not provide the required transport setting, which will cause user logins to fail");
        }
    }

    private boolean loadNoPasswordPromptProperty() {
        if (this.securityProps == null) {
            return false;
        }
        String input = this.securityProps.getProperty("oracle.kv.password.noPrompt");
        return KVStoreLogin.checkBooleanField(input, false);
    }

    private ShellInputReader getReader() {
        if (this.reader == null) {
            this.reader = new ShellInputReader(System.in, System.out);
        }
        return this.reader;
    }

    protected void setReader(ShellInputReader reader) {
        this.reader = reader;
    }

    public LoginCredentials makeShellLoginCredentials() throws IOException {
        boolean noPasswdPrompt = this.loadNoPasswordPromptProperty();
        if (this.userName == null) {
            if (noPasswdPrompt) {
                throw new IllegalArgumentException("Must specify user name when password prompting is disabled");
            }
            this.userName = this.getReader().readLine("Login as:");
        }
        if (this.isKerberosMech()) {
            PasswordCallbackHandler pwdHandler = null;
            if (!noPasswdPrompt) {
                pwdHandler = new PasswordCallbackHandler(this.userName, this.getReader());
            }
            return KVStoreLogin.buildKerberosCreds(this.userName, this.securityProps, pwdHandler);
        }
        char[] passwd = KVStoreLogin.retrievePassword(this.userName, this.securityProps);
        if (passwd == null) {
            if (noPasswdPrompt) {
                throw new IllegalArgumentException("Failed to retrieve password " + this.userName + " from password store, but password must be present when password prompting is disabled");
            }
            passwd = this.getReader().readPassword(this.userName + "'s password:");
        }
        return new PasswordCredentials(this.userName, passwd);
    }

    public LoginCredentials getLoginCredentials() {
        return KVStoreLogin.makeLoginCredentials(this.securityProps);
    }

    public String getSecurityFilePath() {
        return this.securityFilePath;
    }

    public boolean foundTransportSettings() {
        String transportType = this.securityProps == null ? null : this.securityProps.getProperty("oracle.kv.transport");
        return transportType != null && (transportType.equals("ssl") || transportType.equals("clear"));
    }

    public boolean hasTransportSettings() {
        return this.securityProps != null && this.securityProps.getProperty("oracle.kv.transport") != null;
    }

    private boolean isKerberosMech() {
        return KVStoreLogin.isKerberosMech(this.securityProps);
    }

    public static boolean isKerberosMech(Properties securityProps) {
        if (securityProps == null) {
            return false;
        }
        String extAuthMech = securityProps.getProperty("oracle.kv.auth.external.mechanism");
        if (extAuthMech != null) {
            if (extAuthMech.equalsIgnoreCase("KERBEROS")) {
                return true;
            }
            throw new IllegalArgumentException("Unsupported external authentication mechanism in the configuration.");
        }
        return false;
    }

    public void prepareRegistryCSF() {
        if (this.hasTransportSettings()) {
            ClientSocketFactory.setRMIPolicy(this.getSecurityProperties());
        }
        RegistryUtils.initRegistryCSF();
    }

    public void prepareRegistryCSF(int openTimeoutMs, int readTimeoutMs) {
        if (this.hasTransportSettings()) {
            ClientSocketFactory.setRMIPolicy(this.getSecurityProperties());
        }
        RegistryUtils.initRegistryCSF(openTimeoutMs, readTimeoutMs);
    }

    public static LoginCredentials makeLoginCredentials(Properties securityProps) {
        if (securityProps == null) {
            return null;
        }
        String user = securityProps.getProperty("oracle.kv.auth.username");
        if (user == null) {
            return null;
        }
        if (KVStoreLogin.isKerberosMech(securityProps)) {
            return KVStoreLogin.buildKerberosCreds(user, securityProps, null);
        }
        char[] passwd = KVStoreLogin.retrievePassword(user, securityProps);
        return passwd == null ? null : new PasswordCredentials(user, passwd);
    }

    public static Properties createSecurityProperties(String security) {
        if (security == null) {
            return null;
        }
        File securityFile = new File(security);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(securityFile);
            Properties securityProps = new Properties();
            securityProps.load(fis);
            KVStoreLogin.resolveRelativePaths(securityProps, securityFile);
            Properties properties = securityProps;
            return properties;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void resolveRelativePaths(Properties securityProps, File sourceFile) {
        File sourceDir = sourceFile.getAbsoluteFile().getParentFile();
        for (String propName : securityProps.stringPropertyNames()) {
            String propVal;
            File propFile;
            if (!fileProperties.contains(propName) || (propFile = new File(propVal = securityProps.getProperty(propName))).isAbsolute()) continue;
            propFile = new File(sourceDir, propVal);
            securityProps.setProperty(propName, propFile.getPath());
        }
    }

    private static char[] retrievePassword(String user, Properties securityProps) {
        if (user == null || securityProps == null) {
            return null;
        }
        PasswordManager pwdManager = null;
        PasswordStore pwdStore = null;
        try {
            String walletDir = securityProps.getProperty("oracle.kv.auth.wallet.dir");
            if (walletDir != null && !walletDir.isEmpty()) {
                pwdManager = PasswordManager.load(WALLET_MANAGER_CLASS);
                pwdStore = pwdManager.getStoreHandle(new File(walletDir));
            } else {
                String pwdFile;
                String mgrClass = securityProps.getProperty(PWD_MANAGER);
                if (mgrClass == null || mgrClass.isEmpty()) {
                    mgrClass = DEFAULT_FILESTORE_MANAGER_CLASS;
                }
                if ((pwdFile = securityProps.getProperty("oracle.kv.auth.pwdfile.file")) == null || pwdFile.isEmpty()) {
                    char[] cArray = null;
                    return cArray;
                }
                pwdManager = PasswordManager.load(mgrClass);
                pwdStore = pwdManager.getStoreHandle(new File(pwdFile));
            }
            pwdStore.open(null);
            char[] cArray = pwdStore.getSecret(user);
            return cArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (pwdStore != null) {
                pwdStore.discard();
            }
        }
    }

    public static KerberosClientCreds buildKerberosCreds(String username, Properties sp, PasswordCallbackHandler handler) throws AuthenticationFailureException {
        Class<?> krbLoginHelperClass;
        try {
            krbLoginHelperClass = Class.forName(KERBEROS_LOGIN_HELPER_CLASS);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Kerberos authentication was configured, but it is only supported in EE version");
        }
        try {
            Method method = krbLoginHelperClass.getMethod("buildKerberosCreds", String.class, Properties.class, PasswordCallbackHandler.class);
            try {
                return (KerberosClientCreds)method.invoke(null, username, sp, handler);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("Kerberos login helper implementation does not have method buildKerberosCreds");
        }
        catch (AuthenticationFailureException afe) {
            throw afe;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected exception while building Kerberos credentials", e);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public static KerberosClientCreds getKrbClientCredentials(KerberosCredentials krbCreds) {
        return KVStoreLogin.buildKerberosCreds(krbCreds.getUsername(), krbCreds.getKrbProperties(), null);
    }

    public static ReauthenticateHandler makeReauthenticateHandler(final CredentialsProvider credsProvider) {
        return credsProvider == null ? null : new ReauthenticateHandler(){

            @Override
            public void reauthenticate(KVStore kvstore) throws FaultException, AuthenticationFailureException, AuthenticationRequiredException {
                LoginCredentials creds = credsProvider.getCredentials();
                kvstore.login(creds);
            }
        };
    }

    public static boolean checkBooleanField(String input, boolean defaultValue) {
        if (input == null) {
            return defaultValue;
        }
        Pattern pattern = Pattern.compile("true|false", 2);
        Matcher matcher = pattern.matcher(input);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid input for boolean field: " + input);
        }
        return Boolean.parseBoolean(input);
    }

    public static AdminLoginManager getAdminLoginMgr(String host, int port, LoginCredentials creds) throws AuthenticationFailureException {
        return KVStoreLogin.getAdminLoginMgr(new String[]{host + ":" + port}, creds);
    }

    public static AdminLoginManager getAdminLoginMgr(String[] hostPorts, LoginCredentials creds) throws AuthenticationFailureException {
        AdminLoginManager loginMgr;
        if (creds != null && (loginMgr = new AdminLoginManager(creds.getUsername(), true)).bootstrap(hostPorts, creds)) {
            return loginMgr;
        }
        return null;
    }

    public static RepNodeLoginManager getRepNodeLoginMgr(String host, int port, LoginCredentials creds, String storeName) throws AuthenticationFailureException {
        return KVStoreLogin.getRepNodeLoginMgr(new String[]{host + ":" + port}, creds, storeName);
    }

    public static RepNodeLoginManager getRepNodeLoginMgr(String[] hostPorts, LoginCredentials creds, String storeName) throws AuthenticationFailureException {
        if (creds != null) {
            try {
                RepNodeLoginManager loginMgr = new RepNodeLoginManager(creds.getUsername(), true);
                loginMgr.bootstrap(hostPorts, creds, storeName);
                return loginMgr;
            }
            catch (KVStoreException kVStoreException) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        fileProperties.add("oracle.kv.security");
        fileProperties.add("oracle.kv.auth.wallet.dir");
        fileProperties.add("oracle.kv.auth.pwdfile.file");
        fileProperties.add("oracle.kv.ssl.keyStore");
        fileProperties.add("oracle.kv.ssl.trustStore");
        fileProperties.add("oracle.kv.auth.kerberos.keytab");
        fileProperties.add("oracle.kv.auth.kerberos.ccache");
    }

    public static class PasswordCallbackHandler
    implements CallbackHandler {
        private final String name;
        private final ShellInputReader inputReader;

        public PasswordCallbackHandler(String name, ShellInputReader inputReader) {
            this.name = name;
            this.inputReader = inputReader;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (!(callback instanceof PasswordCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
                }
                PasswordCallback pc = (PasswordCallback)callback;
                char[] krbPassword = this.inputReader.readPassword(this.name + "'s kerberos password:");
                pc.setPassword(krbPassword);
                SecurityUtils.clearPassword((char[])krbPassword);
            }
        }
    }

    public static class StoreLoginCredentialsProvider
    implements CredentialsProvider {
        private final Properties props;

        public StoreLoginCredentialsProvider(Properties securityProps) {
            this.props = securityProps;
        }

        @Override
        public LoginCredentials getCredentials() {
            return KVStoreLogin.makeLoginCredentials(this.props);
        }
    }

    public static interface CredentialsProvider {
        public LoginCredentials getCredentials();
    }
}

