/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class RateLimiting<T> {
    private final Map<T, Long> handledEvents;
    private final int eventSamplePeriodMs;
    private long limitedMessageCount = 0L;

    public RateLimiting(int eventSamplePeriodMs, final int maxObjects) {
        this.eventSamplePeriodMs = eventSamplePeriodMs;
        this.handledEvents = new LinkedHashMap<T, Long>(9){

            @Override
            protected boolean removeEldestEntry(Map.Entry<T, Long> eldest) {
                return this.size() > maxObjects;
            }
        };
    }

    public long getLimitedMessageCount() {
        return this.limitedMessageCount;
    }

    int getMapSize() {
        return this.handledEvents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandleable(T object) {
        if (object == null) {
            return true;
        }
        long now = System.currentTimeMillis();
        Map<T, Long> map = this.handledEvents;
        synchronized (map) {
            Long timeMs = this.handledEvents.get(object);
            if (timeMs == null || now > timeMs + (long)this.eventSamplePeriodMs) {
                ++this.limitedMessageCount;
                this.handledEvents.put(object, now);
                return true;
            }
            return false;
        }
    }
}

