/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.contextlogger;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.util.contextlogger.ContextLogManager;
import oracle.kv.impl.util.contextlogger.LogContext;

public class ContextUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logWithCtx(Logger logger, Level level, String msg, LogContext lc) {
        if (lc == null) {
            logger.log(level, msg);
        } else {
            try (ContextLogManager.WithLogContext wlc = new ContextLogManager.WithLogContext(lc);){
                logger.log(level, msg);
            }
        }
    }

    public static void severeWithCtx(Logger logger, String msg, LogContext lc) {
        ContextUtils.logWithCtx(logger, Level.SEVERE, msg, lc);
    }

    public static void warningWithCtx(Logger logger, String msg, LogContext lc) {
        ContextUtils.logWithCtx(logger, Level.WARNING, msg, lc);
    }

    public static void infoWithCtx(Logger logger, String msg, LogContext lc) {
        ContextUtils.logWithCtx(logger, Level.INFO, msg, lc);
    }

    public static void fineWithCtx(Logger logger, String msg, LogContext lc) {
        ContextUtils.logWithCtx(logger, Level.FINE, msg, lc);
    }

    public static void finestWithCtx(Logger logger, String msg, LogContext lc) {
        ContextUtils.logWithCtx(logger, Level.FINEST, msg, lc);
    }

    public static boolean isLoggableWithCtx(Logger logger, Level level, LogContext lc) {
        if (logger.isLoggable(level)) {
            return true;
        }
        if (lc == null) {
            return false;
        }
        int contextLevelValue = lc.getLogLevel();
        return level.intValue() >= contextLevelValue;
    }
}

