/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.junit.cache;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.persistence.internal.cache.AdvancedProcessor;
import org.eclipse.persistence.internal.cache.ComputableTask;
import org.eclipse.persistence.internal.cache.Memoizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AdvancedProcessorTest {
    private AdvancedProcessor processor;
    private MutableComputableTask<Integer, Integer> computableTask;

    @Before
    public void setUp() {
        this.processor = new AdvancedProcessor();
        this.computableTask = new Task<Integer, Integer>();
    }

    @Test
    public void testCompute() throws Exception {
        Assert.assertEquals((Object)this.processor.compute(this.computableTask.setArg(5), (Object)5), (Object)10);
        Field fieldOnProcessor = AdvancedProcessor.class.getDeclaredField("memoizer");
        fieldOnProcessor.setAccessible(true);
        Memoizer memoizer = (Memoizer)fieldOnProcessor.get(this.processor);
        Field fieldOnMemoizer = Memoizer.class.getDeclaredField("cache");
        fieldOnMemoizer.setAccessible(true);
        Map memoizerCache = (Map)fieldOnMemoizer.get(memoizer);
        Object futureAfterFirstComputation = memoizerCache.values().iterator().next();
        this.processor.compute(this.computableTask.setArg(5), (Object)5);
        Object futureAfterSecondComputation = memoizerCache.values().iterator().next();
        Assert.assertTrue((memoizerCache.values().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((futureAfterFirstComputation == futureAfterSecondComputation ? 1 : 0) != 0);
        fieldOnProcessor.setAccessible(false);
        fieldOnMemoizer.setAccessible(false);
    }

    public void testExpire() throws Exception {
        Assert.assertEquals((Object)this.processor.compute(this.computableTask.setArg(5), (Object)5), (Object)10);
        Field fieldOnProcessor = AdvancedProcessor.class.getDeclaredField("memoizer");
        fieldOnProcessor.setAccessible(true);
        Memoizer memoizer = (Memoizer)fieldOnProcessor.get(this.processor);
        Field fieldOnMemoizer = Memoizer.class.getDeclaredField("cache");
        fieldOnMemoizer.setAccessible(true);
        Map memoizerCache = (Map)fieldOnMemoizer.get(memoizer);
        Object futureAfterFirstComputation = memoizerCache.values().iterator().next();
        this.processor.clear();
        this.processor.compute(this.computableTask.setArg(5), (Object)5);
        Iterator iteratorAfterSecondComputation = memoizerCache.values().iterator();
        Object futureAfterSecondComputation = iteratorAfterSecondComputation.next();
        Assert.assertFalse((futureAfterFirstComputation == futureAfterSecondComputation ? 1 : 0) != 0);
        fieldOnProcessor.setAccessible(false);
        fieldOnMemoizer.setAccessible(false);
        Assert.assertEquals((Object)this.processor.compute(this.computableTask.setArg(7), (Object)5), (Object)12);
    }

    private static interface MutableComputableTask<A, V>
    extends ComputableTask<A, V> {
        public MutableComputableTask<A, V> setArg(A var1);
    }

    static class Task<A, V>
    implements MutableComputableTask<A, V> {
        private A a;

        Task() {
        }

        public V compute(A arg) throws InterruptedException {
            return (V)Integer.valueOf((Integer)this.a + (Integer)arg);
        }

        @Override
        public MutableComputableTask<A, V> setArg(A arg) {
            this.a = arg;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Task task = (Task)o;
            return !(this.a != null ? !this.a.equals(task.a) : task.a != null);
        }

        public int hashCode() {
            return this.a != null ? this.a.hashCode() : 0;
        }
    }
}

