/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.mapping;

import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.mapping.Monitor;

public class EqualObjectUnitOfWorkTest
extends AutoVerifyTestCase {
    public UnitOfWork unitOfWork;
    public Monitor monitor1;
    public Monitor monitor2;

    public void reset() {
        this.rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    protected void setup() {
        this.monitor1 = new Monitor();
        this.monitor2 = new Monitor();
        this.monitor1.setBrand("Sony");
        this.monitor1.setSerialNumber("1");
        this.monitor2.setBrand("Sony");
        this.monitor2.setSerialNumber("2");
        this.unitOfWork = this.getSession().acquireUnitOfWork();
        this.unitOfWork.registerObject((Object)this.monitor1);
        this.unitOfWork.registerObject((Object)this.monitor2);
        this.beginTransaction();
    }

    protected void test() {
        this.unitOfWork.commit();
    }

    protected void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        Monitor monitor = (Monitor)this.getSession().readObject((Object)this.monitor1);
        if (!monitor.getSerialNumber().equals("1")) {
            throw new TestErrorException("Equal objects were not inserted properly");
        }
        monitor = (Monitor)this.getSession().readObject((Object)this.monitor2);
        if (!monitor.getSerialNumber().equals("2")) {
            throw new TestErrorException("Equal objects were not inserted properly");
        }
    }
}

