/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.queries.report;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.CursoredStream;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.ValueReadQuery;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.queries.report.ReportQueryTestCase;

public class Scenario5_2d
extends ReportQueryTestCase {
    CursoredStream stream;

    public Scenario5_2d() {
        this.setDescription("Cursored Stream using SQL but types selected don't match item types (firstName->id)");
    }

    @Override
    protected void buildExpectedResults() {
        Vector employees = this.getSession().readAllObjects(Employee.class);
        Enumeration e = employees.elements();
        while (e.hasMoreElements()) {
            Employee emp = (Employee)e.nextElement();
            Object[] result = new Object[]{emp.getFirstName(), emp.getLastName()};
            this.addResult(result, null);
        }
    }

    @Override
    protected void setup() throws Exception {
        super.setup();
        this.reportQuery = new ReportQuery(new ExpressionBuilder());
        this.reportQuery.setReferenceClass(Employee.class);
        this.reportQuery.addAttribute("id");
        this.reportQuery.setSQLString("SELECT F_NAME FROM EMPLOYEE");
        this.reportQuery.useCursoredStream(1, 1, new ValueReadQuery("SELECT COUNT(*) FROM EMPLOYEE"));
    }

    @Override
    public void test() {
        try {
            this.stream = (CursoredStream)this.getSession().executeQuery((DatabaseQuery)this.reportQuery);
        }
        catch (EclipseLinkException qe) {
            this.results = new Vector();
            this.results.addElement(qe);
        }
    }

    @Override
    protected void verify() {
        try {
            if (this.results == null || this.results.size() != 1 || !(this.results.firstElement() instanceof ConversionException)) {
                throw new TestErrorException("Should have caught conversion exception: 3002", (Throwable)((Exception)this.results.firstElement()));
            }
            ConversionException ce = (ConversionException)this.results.firstElement();
            if (ce.getErrorCode() != 3002) {
                throw new TestErrorException("Should have caught conversion exception: 3002, instead caught:" + ce);
            }
        }
        finally {
            if (this.stream != null && !this.stream.isClosed()) {
                this.stream.close();
            }
        }
    }
}

