/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.eclipse.persistence.indirection.IndirectCollectionsFactory;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.models.transparentindirection.Order;
import org.eclipse.persistence.testing.models.transparentindirection.OrderLine;

public class DeepMergeCloneIndirectionTest
extends AutoVerifyTestCase {
    public Order orderObject;

    public DeepMergeCloneIndirectionTest() {
        this.setDescription("This test verifies that deepMergeClone works after a serialized transaction.  When nested objects use indirection.");
    }

    public void setup() {
        if (this.getSession() instanceof RemoteSession) {
            throw new TestWarningException("This test cannot be run through the remote.");
        }
        this.getAbstractSession().beginTransaction();
        this.orderObject = new Order();
        this.orderObject.contacts = IndirectCollectionsFactory.createIndirectList();
        this.orderObject.lines = IndirectCollectionsFactory.createIndirectList();
        this.orderObject.setTotal(56789);
        this.orderObject.customerName = "henry";
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        uow.registerObject((Object)this.orderObject);
        uow.commit();
    }

    public void reset() {
        if (this.getAbstractSession().isInTransaction()) {
            this.getAbstractSession().rollbackTransaction();
            this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        }
    }

    public void test() {
        try {
            Order deserialOrder;
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            ObjectOutputStream stream = new ObjectOutputStream(byteStream);
            Session session = this.getSession();
            UnitOfWork uow = session.acquireUnitOfWork();
            this.orderObject = (Order)session.readObject(Order.class);
            ((Collection)this.orderObject.getLineContainer()).size();
            stream.writeObject(this.orderObject);
            stream.flush();
            byte[] arr = byteStream.toByteArray();
            ByteArrayInputStream inByteStream = new ByteArrayInputStream(arr);
            ObjectInputStream inObjStream = new ObjectInputStream(inByteStream);
            try {
                deserialOrder = (Order)inObjStream.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new TestErrorException("Could not deserialize object " + e.toString());
            }
            OrderLine newLine = new OrderLine();
            ((Collection)deserialOrder.getLineContainer()).clear();
            deserialOrder.addLine(newLine);
            newLine.order = deserialOrder;
            Order orderClone = (Order)uow.registerObject((Object)this.orderObject);
            orderClone = (Order)uow.deepMergeClone((Object)deserialOrder);
            uow.commit();
        }
        catch (IOException e) {
            throw new TestErrorException("Error running Test " + e.toString());
        }
        catch (NullPointerException exception) {
            throw new TestErrorException("Test Failed.  Backup clone indirection was not triggered in mergeIntoObject.");
        }
    }

    public void verify() {
    }
}

