/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.advanced.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmployeePopulator;
import org.eclipse.persistence.testing.models.jpa.advanced.Equipment;
import org.eclipse.persistence.testing.models.jpa.advanced.EquipmentCode;
import org.eclipse.persistence.testing.tests.jpa.advanced.NamedNativeQueryJUnitTest;

public class NamedQueryJUnitTest
extends JUnitTestCase {
    protected String PUName = "default";

    public NamedQueryJUnitTest() {
    }

    public NamedQueryJUnitTest(String name) {
        super(name);
        this.setPuName(this.PUName);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new NamedNativeQueryJUnitTest("testSetup"));
        return NamedQueryJUnitTest.addNamedQueryTests(suite);
    }

    public static Test addNamedQueryTests(TestSuite suite) {
        suite.setName("NamedQueryJUnitTest");
        suite.addTest((Test)new NamedQueryJUnitTest("testSelectNamedQueryWithNamedParameters"));
        suite.addTest((Test)new NamedQueryJUnitTest("testSelectNamedQueryWithNamedParametersReverseOrder"));
        suite.addTest((Test)new NamedQueryJUnitTest("testSelectNamedQueryWithIndexedParameters"));
        suite.addTest((Test)new NamedQueryJUnitTest("testSelectNamedQueryWithIndexedParametersReverseOrder"));
        return suite;
    }

    public void testSetup() {
        System.out.println("testSetup");
        new AdvancedTableCreator().replaceTables((DatabaseSession)NamedQueryJUnitTest.getServerSession((String)this.PUName));
        NamedQueryJUnitTest.clearCache((String)this.PUName);
    }

    private void persistEmployee(EntityManager em, Employee employee) {
        Collection equipmentColl = employee.getDepartment().getEquipment().values();
        for (Equipment equipment : equipmentColl) {
            EquipmentCode ec = equipment.getEquipmentCode();
            if (ec != null) {
                em.persist((Object)ec);
            }
            em.persist((Object)equipment);
        }
        em.persist((Object)employee.getAddress());
        em.persist((Object)employee.getDepartment());
        em.persist((Object)employee);
    }

    private void removeEmployee(EntityManager em, Employee employee) {
        Collection equipmentColl = employee.getDepartment().getEquipment().values();
        em.remove((Object)employee);
        em.remove((Object)employee.getDepartment());
        em.remove((Object)employee.getAddress());
        for (Equipment equipment : equipmentColl) {
            EquipmentCode ec = equipment.getEquipmentCode();
            em.remove((Object)equipment);
            if (ec == null) continue;
            em.remove((Object)ec);
        }
    }

    private Collection<Employee> createEmployees(EntityManager em) {
        LinkedList<Employee> employees = new LinkedList<Employee>();
        this.beginTransaction(em);
        try {
            EmployeePopulator ep = new EmployeePopulator();
            Employee e1 = ep.basicEmployeeExample1();
            Employee e2 = ep.basicEmployeeExample2();
            Employee e3 = ep.basicEmployeeExample3();
            this.persistEmployee(em, e1);
            this.persistEmployee(em, e2);
            this.persistEmployee(em, e3);
            employees.add(e1);
            employees.add(e2);
            employees.add(e3);
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        em.flush();
        this.commitTransaction(em);
        return employees;
    }

    private void deleteEmployees(EntityManager em, Collection<Employee> employees) {
        this.beginTransaction(em);
        try {
            for (Employee employee : employees) {
                this.removeEmployee(em, employee);
            }
        }
        catch (RuntimeException ex) {
            this.rollbackTransaction(em);
            throw ex;
        }
        em.flush();
        this.commitTransaction(em);
    }

    public void testSelectNamedQueryWithNamedParameters() {
        try (EntityManager em = NamedQueryJUnitTest.createEntityManager((String)this.PUName);){
            Collection<Employee> employees = this.createEmployees(em);
            for (Employee employee : employees) {
                Employee e;
                Query query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdNamedParams");
                query.setParameter("eId", (Object)employee.getId());
                query.setParameter("dId", (Object)employee.getDepartment().getId());
                List results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
                query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdNamedParams");
                query.setParameter("dId", (Object)employee.getDepartment().getId());
                query.setParameter("eId", (Object)employee.getId());
                results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
            }
            this.deleteEmployees(em, employees);
        }
    }

    public void testSelectNamedQueryWithNamedParametersReverseOrder() {
        try (EntityManager em = NamedQueryJUnitTest.createEntityManager((String)this.PUName);){
            Collection<Employee> employees = this.createEmployees(em);
            for (Employee employee : employees) {
                Employee e;
                Query query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdNamedParamsReverseOrder");
                query.setParameter("eId", (Object)employee.getId());
                query.setParameter("dId", (Object)employee.getDepartment().getId());
                List results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
                query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdNamedParamsReverseOrder");
                query.setParameter("dId", (Object)employee.getDepartment().getId());
                query.setParameter("eId", (Object)employee.getId());
                results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
            }
            this.deleteEmployees(em, employees);
        }
    }

    public void testSelectNamedQueryWithIndexedParameters() {
        try (EntityManager em = NamedQueryJUnitTest.createEntityManager((String)this.PUName);){
            Collection<Employee> employees = this.createEmployees(em);
            for (Employee employee : employees) {
                Employee e;
                Query query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdIndexedParams");
                query.setParameter(1, (Object)employee.getId());
                query.setParameter(2, (Object)employee.getDepartment().getId());
                List results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
                query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdIndexedParams");
                query.setParameter(2, (Object)employee.getDepartment().getId());
                query.setParameter(1, (Object)employee.getId());
                results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
            }
            this.deleteEmployees(em, employees);
        }
    }

    public void testSelectNamedQueryWithIndexedParametersReverseOrder() {
        try (EntityManager em = NamedQueryJUnitTest.createEntityManager((String)this.PUName);){
            Collection<Employee> employees = this.createEmployees(em);
            for (Employee employee : employees) {
                Employee e;
                Query query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdIndexedParamsReverseOrder");
                query.setParameter(2, (Object)employee.getId());
                query.setParameter(1, (Object)employee.getDepartment().getId());
                List results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
                query = em.createNamedQuery("employee.findPhoneNumberByEmployeIdAndPhoneNumberIdIndexedParamsReverseOrder");
                query.setParameter(1, (Object)employee.getDepartment().getId());
                query.setParameter(2, (Object)employee.getId());
                results = query.getResultList();
                NamedQueryJUnitTest.assertTrue((String)"No records found", (results.size() > 0 ? 1 : 0) != 0);
                for (Object result : results) {
                    e = (Employee)result;
                    NamedQueryJUnitTest.assertEquals((String)"Returned Employee.id does not match ID from query", (Object)employee.getId(), (Object)e.getId());
                    NamedQueryJUnitTest.assertEquals((String)"Returned Department.id does not match ID from query", (Object)employee.getDepartment().getId(), (Object)e.getDepartment().getId());
                }
            }
            this.deleteEmployees(em, employees);
        }
    }
}

