/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance.writing;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.PerformanceRegressionTestCase;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;

public class JPAMassInsertOrMergeEmployeeWithManagementLevelsPerformanceComparisonTest
extends PerformanceRegressionTestCase {
    boolean shouldInsert;
    boolean shouldUseSequencing;
    int nLevels;
    int nDirects;
    long id = 0L;
    boolean wasBatchWriting;

    public JPAMassInsertOrMergeEmployeeWithManagementLevelsPerformanceComparisonTest(boolean shouldInsert, boolean shouldUseSequencing, int nLevels, int nDirects) {
        this.shouldInsert = shouldInsert;
        this.shouldUseSequencing = shouldUseSequencing;
        this.nLevels = nLevels;
        this.nDirects = nDirects;
        this.setName(this.getName() + (shouldInsert ? " insert" : " merge") + (shouldUseSequencing ? " useSequencing " : " doNotUseSequencing ") + " nLevel = " + nLevels + "; nDirects = " + nDirects);
        this.setDescription("This test compares the performance of " + (shouldInsert ? "insert" : "merge") + (shouldUseSequencing ? " useSequencing " : " doNotUseSequencing ") + " Employee with " + nLevels + " levels of management; each manager has " + nDirects + " direct employees");
    }

    public void setup() throws Exception {
        this.id = 0L;
        EntityManager entityManager = this.createEntityManager();
        if (entityManager instanceof JpaEntityManager) {
            this.wasBatchWriting = ((JpaEntityManager)entityManager).getServerSession().getLogin().shouldUseBatchWriting();
            ((JpaEntityManager)entityManager).getServerSession().getLogin().setUsesBatchWriting(false);
        }
        entityManager.close();
        if (!this.shouldUseSequencing) {
            Employee emp = new Employee();
            entityManager = this.createEntityManager();
            entityManager.getTransaction().begin();
            entityManager.persist((Object)emp);
            entityManager.getTransaction().commit();
            entityManager.close();
            this.id = emp.getId();
            entityManager = this.createEntityManager();
            entityManager.getTransaction().begin();
            emp = (Employee)entityManager.find(Employee.class, (Object)emp.getId());
            entityManager.remove((Object)emp);
            entityManager.getTransaction().commit();
            entityManager.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        EntityManager manager = this.createEntityManager();
        try {
            Employee topEmployee = new Employee();
            topEmployee.setFirstName("Level_0");
            topEmployee.setLastName("Number_0");
            if (!this.shouldUseSequencing) {
                topEmployee.setId(this.id++);
            }
            ArrayList<Employee> employeesForHigherLevel = new ArrayList<Employee>(1);
            employeesForHigherLevel.add(topEmployee);
            int nEmployeesTotal = 1;
            for (int nLevel = 1; nLevel <= this.nLevels; ++nLevel) {
                ArrayList<Employee> employeesForCurrentLevel = new ArrayList<Employee>(employeesForHigherLevel.size() * this.nDirects);
                for (Employee mgr : employeesForHigherLevel) {
                    for (int nCurrent = 0; nCurrent < this.nDirects; ++nCurrent) {
                        Employee employee = new Employee();
                        employee.setFirstName("Level_" + nLevel);
                        employee.setLastName("Number_" + employeesForCurrentLevel.size());
                        if (!this.shouldUseSequencing) {
                            employee.setId(this.id++);
                        }
                        employeesForCurrentLevel.add(employee);
                        mgr.addManagedEmployee(employee);
                    }
                }
                employeesForHigherLevel = employeesForCurrentLevel;
                nEmployeesTotal += employeesForCurrentLevel.size();
            }
            manager.getTransaction().begin();
            if (this.shouldInsert) {
                manager.persist((Object)topEmployee);
            } else {
                manager.merge((Object)topEmployee);
            }
            manager.getTransaction().commit();
        }
        finally {
            if (manager.getTransaction().isActive()) {
                manager.getTransaction().rollback();
            }
            manager.close();
        }
    }

    public void reset() throws Exception {
        EntityManager manager = this.createEntityManager();
        manager.getTransaction().begin();
        manager.createQuery("Delete from Employee where firstName like 'Level_%'").executeUpdate();
        manager.getTransaction().commit();
        manager.close();
        EntityManager entityManager = this.createEntityManager();
        if (entityManager instanceof JpaEntityManager) {
            ((JpaEntityManager)entityManager).getServerSession().getLogin().setUsesBatchWriting(this.wasBatchWriting);
        }
        entityManager.close();
    }
}

