/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.advanced;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.Query;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCaseHelper;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.dynamic.AdvancedDynamicTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.dynamic.DynamicTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.dynamic.DynamicWalkerPK;
import org.eclipse.persistence.testing.models.jpa.xml.advanced.dynamic.MyDynamicEntity;
import org.eclipse.persistence.tools.schemaframework.DatabaseObjectDefinition;
import org.eclipse.persistence.tools.schemaframework.SchemaManager;
import org.eclipse.persistence.tools.schemaframework.StoredProcedureDefinition;

public class EntityMappingsDynamicAdvancedJUnitTestCase
extends JUnitTestCase {
    private static final String AMEX = "Amex";
    private static final String DINERS = "DinersClub";
    private static final String MASTERCARD = "Mastercard";
    private static final String VISA = "Visa";
    private static final String ROYAL_BANK = "RoyalBank";
    private static final String CANADIAN_IMPERIAL = "CanadianImperial";
    private static final String SCOTIABANK = "Scotiabank";
    private static final String TORONTO_DOMINION = "TorontoDominion";
    private static Integer employeeId;
    private static long visa;
    private static long amex;
    private static long diners;
    private static long mastercard;
    private static long rbc;
    private static long scotia;
    private static long td;
    private static long cibc;

    public EntityMappingsDynamicAdvancedJUnitTestCase(String name) {
        super(name);
    }

    protected StoredProcedureDefinition buildOracleStoredProcedureReadFromAddress(DatabaseSession session) {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("SProc_Read_DynamicAddress");
        proc.addInOutputArgument("address_id_v", Integer.class);
        proc.addOutputArgument("street_v", String.class);
        proc.addOutputArgument("city_v", String.class);
        proc.addOutputArgument("country_v", String.class);
        proc.addOutputArgument("province_v", String.class);
        proc.addOutputArgument("p_code_v", String.class);
        String statement = null;
        statement = session.getPlatform().isSQLServer() || session.getPlatform().isSybase() ? "SELECT @street_v=STREET, @city_v=CITY, @country_v=COUNTRY, @province_v=PROVINCE, @p_code_v=P_CODE FROM DYNAMIC_ADDRESS WHERE (ADDRESS_ID = @address_id_v)" : "SELECT STREET, CITY, COUNTRY, PROVINCE, P_CODE INTO street_v, city_v, country_v, province_v, p_code_v FROM DYNAMIC_ADDRESS WHERE (ADDRESS_ID = address_id_v)";
        proc.addStatement(statement);
        return proc;
    }

    protected StoredProcedureDefinition buildOracleStoredProcedureReadInOut(DatabaseSession session) {
        StoredProcedureDefinition proc = new StoredProcedureDefinition();
        proc.setName("SProc_Read_DynamicInOut");
        proc.addInOutputArgument("address_id_v", Long.class);
        proc.addOutputArgument("street_v", String.class);
        String statement = null;
        statement = session.getPlatform().isSQLServer() || session.getPlatform().isSybase() ? "SELECT @address_id_v=ADDRESS_ID, @street_v=STREET from DYNAMIC_ADDRESS where (ADDRESS_ID = @address_id_v)" : "SELECT ADDRESS_ID, STREET into address_id_v, street_v from DYNAMIC_ADDRESS where (ADDRESS_ID = address_id_v)";
        proc.addStatement(statement);
        return proc;
    }

    protected void clearDynamicPUCache() {
        EntityMappingsDynamicAdvancedJUnitTestCase.clearCache((String)"extended-dynamic-advanced");
    }

    protected EntityManager createDynamicPUEntityManager() {
        return EntityMappingsDynamicAdvancedJUnitTestCase.createEntityManager((String)"extended-dynamic-advanced", (Map)this.getDynamicProperties());
    }

    protected EntityManager createDynamicEntityManager(String persistenceUnitName, List<ClassDescriptor> descriptors) {
        return EntityMappingsDynamicAdvancedJUnitTestCase.createEntityManager((String)persistenceUnitName, (Map)this.getDynamicProperties(), descriptors);
    }

    protected ClassDescriptor getDescriptor(String alias) {
        ClassDescriptor descriptor = this.getDynamicPUServerSession().getDescriptorForAlias(alias);
        EntityMappingsDynamicAdvancedJUnitTestCase.assertFalse((String)("Descriptor for alias: " + alias + ", was not found."), (descriptor == null ? 1 : 0) != 0);
        return descriptor;
    }

    protected Map getDynamicProperties() {
        Map properties = JUnitTestCaseHelper.getDatabaseProperties();
        properties.put("eclipselink.classloader", new DynamicClassLoader(Thread.currentThread().getContextClassLoader()));
        return properties;
    }

    protected ServerSession getDynamicPUServerSession() {
        return EntityMappingsDynamicAdvancedJUnitTestCase.getServerSession((String)"extended-dynamic-advanced", (Map)this.getDynamicProperties());
    }

    public void testAddressChangeTrackingPolicy() {
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Address descriptor has incorrect object change policy", (boolean)this.getDescriptor("DynamicAddress").getObjectChangePolicyInternal().isAttributeChangeTrackingPolicy());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Advanced Dynamic Model");
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testExistenceCheckingSetting"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testReadOnlyClassSetting"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testEmployeeChangeTrackingPolicy"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testAddressChangeTrackingPolicy"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testProjectChangeTrackingPolicy"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testCreateEmployee"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testUpdateEmployee"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testDynamicShovel"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testRefreshNotManagedEmployee"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testRefreshRemovedEmployee"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testNamedNativeQueryOnAddress"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testNamedQueryOnEmployee"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testNamedStoredProcedureQuery"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testNamedStoredProcedureQueryInOut"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testDeleteEmployee"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testDynamicWithNoPersistenceXML"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testDynamicEmbeddedId"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testDynamicCompositeId"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testEmployeeWeaving"));
        suite.addTest((Test)new EntityMappingsDynamicAdvancedJUnitTestCase("testAddressWeaving"));
        return suite;
    }

    public void testCreateEmployee() {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        try {
            this.beginTransaction(em);
            DynamicEntity employee = helper.newDynamicEntity("DynamicEmployee");
            employee.set("firstName", (Object)"Boy");
            employee.set("lastName", (Object)"Pelletier");
            employee.set("salary", (Object)20000);
            HashMap<String, Long> creditCards = new HashMap<String, Long>();
            creditCards.put(VISA, visa);
            creditCards.put(AMEX, amex);
            creditCards.put(DINERS, diners);
            creditCards.put(MASTERCARD, mastercard);
            employee.set("creditCards", creditCards);
            HashMap<String, Long> creditLines = new HashMap<String, Long>();
            creditLines.put(ROYAL_BANK, rbc);
            creditLines.put(SCOTIABANK, scotia);
            creditLines.put(TORONTO_DOMINION, td);
            creditLines.put(CANADIAN_IMPERIAL, cibc);
            employee.set("creditLines", creditLines);
            ArrayList<String> responsibilities = new ArrayList<String>();
            responsibilities.add("A very important responsibility");
            employee.set("responsibilities", responsibilities);
            DynamicEntity address = helper.newDynamicEntity("DynamicAddress");
            address.set("city", (Object)"Nepean");
            address.set("country", (Object)"Canada");
            address.set("postalCode", (Object)"K2J 6T3");
            address.set("province", (Object)"oNtArIo");
            address.set("street", (Object)"321 Crestway");
            employee.set("address", (Object)address);
            DynamicEntity employmentPeriod = helper.newDynamicEntity("EmploymentPeriod");
            employmentPeriod.set("startDate", (Object)new Date(System.currentTimeMillis() - 1000000L));
            employmentPeriod.set("endDate", (Object)new Date(System.currentTimeMillis() + 1000000L));
            employee.set("period", (Object)employmentPeriod);
            ArrayList<DynamicEntity> projects = new ArrayList<DynamicEntity>();
            DynamicEntity project = helper.newDynamicEntity("DynamicProject");
            project.set("description", (Object)"A Project");
            project.set("name", (Object)"Project");
            projects.add(project);
            DynamicEntity largeProject = helper.newDynamicEntity("DynamicLargeProject");
            largeProject.set("description", (Object)"A LargeProject");
            largeProject.set("name", (Object)"LargeProject");
            largeProject.set("budget", (Object)3654563.0);
            projects.add(largeProject);
            employee.set("projects", projects);
            em.persist((Object)employee);
            employeeId = (Integer)employee.get("id");
            this.commitTransaction(em);
            this.clearDynamicPUCache();
            em.clear();
            DynamicEntity emp = (DynamicEntity)em.find(helper.getType("DynamicEmployee").getJavaClass(), (Object)employeeId);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"The employee was not found", (Object)emp);
            DynamicEntity addr = (DynamicEntity)emp.get("address");
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"The address province value was not converted", (boolean)addr.get("province").equals("Ontario"));
            Map ccs = (Map)emp.get("creditCards");
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Visa card did not persist correctly.", (boolean)ccs.containsKey(VISA));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Visa card value did not persist correctly.", (boolean)((Long)ccs.get(VISA)).equals(visa));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Amex card did not persist correctly.", (boolean)ccs.containsKey(AMEX));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Amex card value did not persist correctly.", (boolean)((Long)ccs.get(AMEX)).equals(amex));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Diners Club card did not persist correctly.", (boolean)ccs.containsKey(DINERS));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Diners Club card value did not persist correctly.", (boolean)((Long)ccs.get(DINERS)).equals(diners));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Mastercard card did not persist correctly.", (boolean)ccs.containsKey(MASTERCARD));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Mastercard card value did not persist correctly.", (boolean)((Long)ccs.get(MASTERCARD)).equals(mastercard));
            Map cls = (Map)emp.get("creditLines");
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"RBC credit line did not persist correctly.", (boolean)cls.containsKey(ROYAL_BANK));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"RBC credit line value did not persist correctly.", (boolean)((Long)cls.get(ROYAL_BANK)).equals(rbc));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Scotia credit line did not persist correctly.", (boolean)cls.containsKey(SCOTIABANK));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Scotia credit line value did not persist correctly.", (boolean)((Long)cls.get(SCOTIABANK)).equals(scotia));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"TD credit line did not persist correctly.", (boolean)cls.containsKey(TORONTO_DOMINION));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"TD credit line value did not persist correctly.", (boolean)((Long)cls.get(TORONTO_DOMINION)).equals(td));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"CIBC credit line did not persist correctly.", (boolean)cls.containsKey(CANADIAN_IMPERIAL));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"CIBC credit line value did not persist correctly.", (boolean)((Long)cls.get(CANADIAN_IMPERIAL)).equals(cibc));
            boolean found = false;
            for (String responsibility : (Collection)emp.get("responsibilities")) {
                if (!responsibility.equals("A very important responsibility")) continue;
                found = true;
                break;
            }
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"The new responsibility was not added.", (boolean)found);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testDeleteEmployee() {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        try {
            this.beginTransaction(em);
            em.remove(em.find(helper.getType("DynamicEmployee").getJavaClass(), (Object)employeeId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testDynamicShovel() {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        try {
            this.beginTransaction(em);
            DynamicEntity shovel = helper.newDynamicEntity("DynamicShovel");
            shovel.set("cost", (Object)9.99);
            DynamicEntity shovelSections = helper.newDynamicEntity("ShovelSections");
            shovelSections.set("handle", (Object)MaterialType.Plastic.name());
            shovelSections.set("shaft", (Object)MaterialType.Wood.name());
            shovelSections.set("scoop", (Object)MaterialType.Plastic.name());
            shovel.set("sections", (Object)shovelSections);
            DynamicEntity shovelOwner = helper.newDynamicEntity("DynamicShovelOwner");
            shovelOwner.set("name", (Object)"Mr. Shovel");
            shovel.set("owner", (Object)shovelOwner);
            DynamicEntity shovelDigger1 = helper.newDynamicEntity("DynamicShovelDigger");
            shovelDigger1.set("name", (Object)"Digging Plebe 1");
            shovelDigger1.set("shovel", (Object)shovel);
            DynamicEntity shovelDigger2 = helper.newDynamicEntity("DynamicShovelDigger");
            shovelDigger2.set("name", (Object)"Digging Plebe 2");
            shovelDigger2.set("shovel", (Object)shovel);
            ArrayList<DynamicEntity> operators = new ArrayList<DynamicEntity>();
            operators.add(shovelDigger1);
            operators.add(shovelDigger2);
            shovel.set("operators", operators);
            DynamicEntity shovelProject = helper.newDynamicEntity("DynamicShovelProject");
            shovelProject.set("description", (Object)"One lousy shovelling project");
            ArrayList<DynamicEntity> shovels = new ArrayList<DynamicEntity>();
            shovels.add(shovel);
            shovelProject.set("shovels", shovels);
            ArrayList<DynamicEntity> projects = new ArrayList<DynamicEntity>();
            projects.add(shovelProject);
            shovel.set("projects", projects);
            em.persist((Object)shovel);
            Object shovelId = shovel.get("id");
            Object shovelOwnerId = shovelOwner.get("id");
            Object shovelDigger1Id = shovelDigger1.get("id");
            Object shovelDigger2Id = shovelDigger2.get("id");
            Object shovelProjectId = shovelProject.get("id");
            this.commitTransaction(em);
            this.clearDynamicPUCache();
            em.clear();
            DynamicEntity refreshedShovel = (DynamicEntity)em.find(helper.getType("DynamicShovel").getJavaClass(), shovelId);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Shovel didn't match after write/read", (boolean)this.getDynamicPUServerSession().compareObjects((Object)shovel, (Object)refreshedShovel));
            this.beginTransaction(em);
            em.merge((Object)refreshedShovel);
            refreshedShovel.set("cost", (Object)7.99);
            this.commitTransaction(em);
            this.clearDynamicPUCache();
            em.clear();
            DynamicEntity refreshedUpdatedShovel = (DynamicEntity)em.find(helper.getType("DynamicShovel").getJavaClass(), shovelId);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Shovel didn't match after update", (boolean)this.getDynamicPUServerSession().compareObjects((Object)refreshedShovel, (Object)refreshedUpdatedShovel));
            this.beginTransaction(em);
            em.merge((Object)refreshedUpdatedShovel);
            em.remove((Object)refreshedUpdatedShovel);
            this.commitTransaction(em);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNull((String)"Shovel wasn't removed", (Object)em.find(helper.getType("DynamicShovel").getJavaClass(), shovelId));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNull((String)"Shovel owner wasn't removed", (Object)em.find(helper.getType("DynamicShovelOwner").getJavaClass(), shovelOwnerId));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNull((String)"Shovel digger 1 wasn't removed", (Object)em.find(helper.getType("DynamicShovelDigger").getJavaClass(), shovelDigger1Id));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNull((String)"Shovel digger 2 wasn't removed", (Object)em.find(helper.getType("DynamicShovelDigger").getJavaClass(), shovelDigger2Id));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"Shovel project was removed", (Object)em.find(helper.getType("DynamicShovelProject").getJavaClass(), shovelProjectId));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testDynamicWithNoPersistenceXML() {
        if (!EntityMappingsDynamicAdvancedJUnitTestCase.isOnServer()) {
            ArrayList<ClassDescriptor> descriptors = new ArrayList<ClassDescriptor>();
            RelationalDescriptor descriptor = new RelationalDescriptor();
            descriptor.setJavaClassName("org.eclipse.persistence.testing.models.jpa.xml.advanced.dynamic.MyDynamicEntity");
            descriptor.setAlias("MyDynamicEntity");
            descriptor.setTableName("JPA_DYNAMIC_ENTITY");
            descriptor.addPrimaryKeyFieldName("ID");
            descriptor.setSequenceNumberFieldName("ID");
            descriptor.setSequenceNumberName("DYNAMIC_SEQ");
            descriptor.addDirectMapping("id", "ID");
            descriptor.addDirectMapping("firstName", "F_NAME");
            descriptor.addDirectMapping("lastName", "L_NAME");
            descriptors.add((ClassDescriptor)descriptor);
            EntityManager em = this.createDynamicEntityManager("dynamic-test", descriptors);
            new DynamicTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)em).getServerSession());
            try {
                this.beginTransaction(em);
                em.persist((Object)new MyDynamicEntity("Doug", "Clarke"));
                em.persist((Object)new MyDynamicEntity("Peter", "Krogh"));
                this.commitTransaction(em);
                EntityMappingsDynamicAdvancedJUnitTestCase.clearCache((String)"dynamic-test");
                em.clear();
                List results = em.createQuery("SELECT d FROM MyDynamicEntity d").getResultList();
                EntityMappingsDynamicAdvancedJUnitTestCase.assertFalse((String)"No dynamic entities were returned from the query", (boolean)results.isEmpty());
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw e;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    public void testExistenceCheckingSetting() {
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Employee existence checking was incorrect", (this.getDescriptor("DynamicEmployee").getQueryManager().getDoesExistQuery().getExistencePolicy() == 4 ? 1 : 0) != 0);
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Project existence checking was incorrect", (this.getDescriptor("DynamicProject").getQueryManager().getDoesExistQuery().getExistencePolicy() == 3 ? 1 : 0) != 0);
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"SmallProject existence checking was incorrect", (this.getDescriptor("DynamicSmallProject").getQueryManager().getDoesExistQuery().getExistencePolicy() == 2 ? 1 : 0) != 0);
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"LargeProject existence checking was incorrect", (this.getDescriptor("DynamicLargeProject").getQueryManager().getDoesExistQuery().getExistencePolicy() == 1 ? 1 : 0) != 0);
    }

    public void testEmployeeChangeTrackingPolicy() {
        EntityMappingsDynamicAdvancedJUnitTestCase.assertFalse((String)"Employee descriptor has incorrect object change policy", (boolean)this.getDescriptor("DynamicEmployee").getObjectChangePolicy().isAttributeChangeTrackingPolicy());
    }

    public void testNamedNativeQueryOnAddress() {
        EntityManager em = this.createDynamicPUEntityManager();
        List addresses = em.createNamedQuery("findAllDynamicAddressesByPostalCode", DynamicEntity.class).setParameter("postalCode", (Object)"K2J 6T3").getResultList();
        EntityMappingsDynamicAdvancedJUnitTestCase.assertFalse((String)"No addresses were returned, expecting 1", (boolean)addresses.isEmpty());
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)("Incorrect number of addresses returned, expected 1, got: " + addresses.size()), (addresses.size() == 1 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testNamedQueryOnEmployee() {
        EntityManager em = this.createDynamicPUEntityManager();
        DynamicEntity employee = (DynamicEntity)em.createNamedQuery("findAllDynamicEmployeesByFirstName", DynamicEntity.class).setParameter("firstName", (Object)"Boy").getSingleResult();
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Error executing named query 'findAllDynamicEmployeesByFirstName'", (employee != null ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testNamedStoredProcedureQuery() {
        if (EntityMappingsDynamicAdvancedJUnitTestCase.supportsStoredProcedures((String)"extended-dynamic-advanced")) {
            EntityManager em = this.createDynamicPUEntityManager();
            JPADynamicHelper helper = new JPADynamicHelper(em);
            try {
                this.beginTransaction(em);
                DynamicEntity address1 = helper.newDynamicEntity("DynamicAddress");
                address1.set("city", (Object)"Ottawa");
                address1.set("country", (Object)"Canada");
                address1.set("postalCode", (Object)"K1G 6P3");
                address1.set("province", (Object)"ON");
                address1.set("street", (Object)"123 Street");
                em.persist((Object)address1);
                this.commitTransaction(em);
                this.clearDynamicPUCache();
                em.clear();
                Query aQuery = em.createNamedQuery("SProcDynamicAddress").setParameter("ADDRESS_ID", address1.get("id"));
                DynamicEntity address2 = (DynamicEntity)aQuery.getSingleResult();
                EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
                EntityMappingsDynamicAdvancedJUnitTestCase.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
                EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Address not found using stored procedure", (boolean)address1.get("id").equals(address2.get("id")));
                EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Address.street data returned doesn't match persisted address.street", (boolean)address1.get("street").equals(address2.get("street")));
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw e;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    public void testNamedStoredProcedureQueryInOut() {
        if (EntityMappingsDynamicAdvancedJUnitTestCase.supportsStoredProcedures((String)"extended-dynamic-advanced")) {
            EntityManager em = this.createDynamicPUEntityManager();
            JPADynamicHelper helper = new JPADynamicHelper(em);
            try {
                this.beginTransaction(em);
                DynamicEntity address1 = helper.newDynamicEntity("DynamicAddress");
                address1.set("city", (Object)"Ottawa");
                address1.set("postalCode", (Object)"K1G6P3");
                address1.set("province", (Object)"ON");
                address1.set("street", (Object)"123 Street");
                address1.set("country", (Object)"Canada");
                em.persist((Object)address1);
                this.commitTransaction(em);
                em.clear();
                Query aQuery = em.createNamedQuery("SProcDynamicInOut").setParameter("ADDRESS_ID", address1.get("id"));
                DynamicEntity address2 = (DynamicEntity)aQuery.getSingleResult();
                EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"Address returned from stored procedure is null", (Object)address2);
                EntityMappingsDynamicAdvancedJUnitTestCase.assertFalse((String)"Address returned is the same cached instance that was persisted - the cache must be disabled for this test", (address1 == address2 ? 1 : 0) != 0);
                EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Address not found using stored procedure", (boolean)address1.get("id").equals(address2.get("id")));
                EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Address.street data returned doesn't match persisted address.street", (boolean)address1.get("street").equals(address2.get("street")));
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                throw e;
            }
            finally {
                this.closeEntityManager(em);
            }
        }
    }

    public void testProjectChangeTrackingPolicy() {
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Project descriptor has incorrect object change policy", (boolean)this.getDescriptor("DynamicProject").getObjectChangePolicy().isObjectChangeTrackingPolicy());
    }

    public void testReadOnlyClassSetting() {
        EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"ReadOnlyClass descriptor is not set to read only.", (boolean)this.getDescriptor("DynamicReadOnlyClass").shouldBeReadOnly());
    }

    public void testRefreshNotManagedEmployee() {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        try {
            this.beginTransaction(em);
            DynamicEntity employee = helper.newDynamicEntity("DynamicEmployee");
            employee.set("firstName", (Object)"NotManaged");
            em.refresh((Object)employee);
            EntityMappingsDynamicAdvancedJUnitTestCase.fail((String)"entityManager.refresh(notManagedObject) didn't throw exception");
        }
        catch (IllegalArgumentException employee) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRefreshRemovedEmployee() {
        DynamicEntity emp;
        String firstName = "testRefreshRemovedEmployee";
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        List result = em.createQuery("SELECT OBJECT(e) FROM DynamicEmployee e WHERE e.firstName = '" + firstName + "'").getResultList();
        if (!result.isEmpty()) {
            emp = (DynamicEntity)result.get(0);
        } else {
            emp = helper.newDynamicEntity("DynamicEmployee");
            emp.set("firstName", (Object)firstName);
            try {
                this.beginTransaction(em);
                em.persist((Object)emp);
                this.commitTransaction(em);
            }
            catch (RuntimeException e) {
                if (this.isTransactionActive(em)) {
                    this.rollbackTransaction(em);
                }
                this.closeEntityManager(em);
                throw e;
            }
        }
        try {
            this.beginTransaction(em);
            emp = (DynamicEntity)em.find(helper.getType("DynamicEmployee").getJavaClass(), emp.get("id"));
            if (this.getDynamicPUServerSession().getPlatform().isSymfoware()) {
                em.createNativeQuery("DELETE FROM DYNAMIC_EMPLOYEE WHERE F_NAME = '" + firstName + "'").executeUpdate();
            } else {
                em.createQuery("DELETE FROM DynamicEmployee e WHERE e.firstName = '" + firstName + "'").executeUpdate();
            }
            em.refresh((Object)emp);
            EntityMappingsDynamicAdvancedJUnitTestCase.fail((String)"entityManager.refresh(removedObject) didn't throw exception");
        }
        catch (EntityNotFoundException entityNotFoundException) {
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testSetup() {
        ServerSession session = this.getDynamicPUServerSession();
        new AdvancedDynamicTableCreator().replaceTables((DatabaseSession)session);
        if (TestCase.supportsStoredProcedures((Session)session)) {
            SchemaManager schema = new SchemaManager((DatabaseSession)session);
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureReadFromAddress((DatabaseSession)session));
            schema.replaceObject((DatabaseObjectDefinition)this.buildOracleStoredProcedureReadInOut((DatabaseSession)session));
        }
    }

    public void testUpdateEmployee() {
        EntityManager em = this.createDynamicPUEntityManager();
        this.beginTransaction(em);
        Integer version = 0;
        try {
            DynamicEntity employee = (DynamicEntity)em.createNamedQuery("findDynamicEmployeeById", DynamicEntity.class).setParameter("id", (Object)employeeId).getSingleResult();
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"The employee was not found", (Object)employee);
            version = (Integer)employee.get("version");
            employee.set("salary", (Object)50000);
            em.merge((Object)employee);
            this.commitTransaction(em);
            this.clearDynamicPUCache();
            em.clear();
            List emps = em.createNamedQuery("findDynamicEmployeeById", DynamicEntity.class).setParameter("id", (Object)employeeId).getResultList();
            DynamicEntity emp = (DynamicEntity)emps.get(0);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"The employee was not found", (Object)emp);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Error updating Employee", (boolean)emp.get("salary").equals(50000));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Version field not updated", (boolean)emp.get("version").equals(version + 1));
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testDynamicEmbeddedId() {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        try {
            this.beginTransaction(em);
            DynamicEntity runner = helper.newDynamicEntity("DynamicRunner");
            runner.set("name", (Object)"Ryan Hill");
            DynamicEntity runnerPK = helper.newDynamicEntity("DynamicRunnerPK");
            runnerPK.set("bib", (Object)1);
            runnerPK.set("worldRank", (Object)13);
            runner.set("id", (Object)runnerPK);
            em.persist((Object)runner);
            this.commitTransaction(em);
            this.clearDynamicPUCache();
            em.clear();
            DynamicEntity r = (DynamicEntity)em.find(helper.getType("DynamicRunner").getJavaClass(), (Object)runnerPK);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertTrue((String)"Runner didn't match after create", (boolean)this.getDynamicPUServerSession().compareObjects((Object)r, (Object)runner));
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"The runner was not found", (Object)r);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDynamicCompositeId() {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        try {
            this.beginTransaction(em);
            DynamicEntity walker = helper.newDynamicEntity("DynamicWalker");
            walker.set("name", (Object)"Sam");
            walker.set("style", (Object)"Speed");
            em.persist((Object)walker);
            this.commitTransaction(em);
            this.clearDynamicPUCache();
            em.clear();
            DynamicWalkerPK pk = new DynamicWalkerPK();
            pk.setId((Integer)walker.get("id"));
            pk.setStyle((String)walker.get("style"));
            DynamicEntity w = (DynamicEntity)em.find(helper.getType("DynamicWalker").getJavaClass(), (Object)pk);
            EntityMappingsDynamicAdvancedJUnitTestCase.assertNotNull((String)"The walker was not found", (Object)w);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            EntityMappingsDynamicAdvancedJUnitTestCase.fail((String)("Error occurred reading the walker with composite id" + e));
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testEmployeeWeaving() throws Exception {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        DynamicType type = helper.getType("DynamicEmployee");
        Assert.assertNotNull((Object)type);
        Assert.assertTrue((boolean)DynamicEntity.class.isAssignableFrom(type.getJavaClass()));
        this.assertAccessors(type);
    }

    public void testAddressWeaving() throws Exception {
        EntityManager em = this.createDynamicPUEntityManager();
        JPADynamicHelper helper = new JPADynamicHelper(em);
        DynamicType type = helper.getType("DynamicAddress");
        Assert.assertNotNull((Object)type);
        Assert.assertTrue((boolean)DynamicEntity.class.isAssignableFrom(type.getJavaClass()));
        this.assertAccessors(type);
    }

    private void assertAccessors(DynamicType type) throws Exception {
        for (DatabaseMapping mapping : type.getDescriptor().getMappings()) {
            String propertyName = this.propertyName(mapping.getAttributeName());
            Method method = mapping.getDescriptor().getJavaClass().getDeclaredMethod("get" + propertyName, new Class[0]);
            Class expectedReturnType = mapping.getAttributeClassification();
            if (mapping.isCollectionMapping()) {
                expectedReturnType = ((CollectionMapping)mapping).getContainerPolicy().getContainerClass();
            }
            if (expectedReturnType == null && mapping.isForeignReferenceMapping()) {
                ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
                expectedReturnType = frMapping.getReferenceDescriptor().getJavaClass();
            }
            Assert.assertNotNull((String)("No classification for: " + mapping), (Object)expectedReturnType);
            if (expectedReturnType.isPrimitive()) continue;
            Assert.assertTrue((String)("Incorrect get" + propertyName + " return type: " + method.getReturnType()), (boolean)method.getReturnType().isAssignableFrom(expectedReturnType));
        }
    }

    private String propertyName(String attributeName) {
        char[] string = attributeName.toCharArray();
        string[0] = Character.toUpperCase(string[0]);
        return new String(string);
    }

    static {
        visa = 1234567890L;
        amex = 1987654321L;
        diners = 1192837465L;
        mastercard = 1647382910L;
        rbc = 4783L;
        scotia = 8732L;
        td = 839362L;
        cibc = 948274L;
    }

    public static enum MaterialType {
        Wood,
        Plastic,
        Composite,
        Steel;

    }
}

