/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.xml.merge.incompletemappings.owning;

import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.AdvancedTableCreator;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.Employee;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.Project;
import org.eclipse.persistence.testing.models.jpa.xml.merge.incompletemappings.owning.SecurityBadge;

public class EntityMappingsIncompleteOwningJUnitTestCase
extends JUnitTestCase {
    private static Integer employeeId;

    public EntityMappingsIncompleteOwningJUnitTestCase() {
    }

    public EntityMappingsIncompleteOwningJUnitTestCase(String name) {
        super(name);
    }

    public void setUp() {
        try {
            super.setUp();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Owning Model");
        suite.addTest((Test)new EntityMappingsIncompleteOwningJUnitTestCase("testSetup"));
        suite.addTest((Test)new EntityMappingsIncompleteOwningJUnitTestCase("testCreateEmployee"));
        suite.addTest((Test)new EntityMappingsIncompleteOwningJUnitTestCase("testReadEmployee"));
        suite.addTest((Test)new EntityMappingsIncompleteOwningJUnitTestCase("testUpdateEmployee"));
        suite.addTest((Test)new EntityMappingsIncompleteOwningJUnitTestCase("testDeleteEmployee"));
        return suite;
    }

    public void testSetup() {
        ServerSession session = JUnitTestCase.getServerSession();
        new AdvancedTableCreator().replaceTables((DatabaseSession)session);
        this.clearCache();
    }

    public void testCreateEmployee() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = ModelExamples.employeeExample1();
            ArrayList<Project> projects = new ArrayList<Project>();
            projects.add(ModelExamples.projectExample1());
            projects.add(ModelExamples.projectExample2());
            employee.setProjects(projects);
            employee.setAddress(ModelExamples.addressExample1());
            em.persist((Object)employee);
            employeeId = employee.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
    }

    public void testDeleteEmployee() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            em.remove(em.find(Employee.class, (Object)employeeId));
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        EntityMappingsIncompleteOwningJUnitTestCase.assertTrue((String)"Error deleting Employee", (em.find(Employee.class, (Object)employeeId) == null ? 1 : 0) != 0);
    }

    public void testReadEmployee() {
        Employee employee = (Employee)this.createEntityManager().find(Employee.class, (Object)employeeId);
        EntityMappingsIncompleteOwningJUnitTestCase.assertTrue((String)"Error reading Employee", (employee.getId() == employeeId ? 1 : 0) != 0);
    }

    public void testUpdateEmployee() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Employee employee = (Employee)em.find(Employee.class, (Object)employeeId);
            employee.setSecurityBadge(new SecurityBadge(69));
            em.merge((Object)employee);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw e;
        }
        this.clearCache();
        Employee newEmployee = (Employee)em.find(Employee.class, (Object)employeeId);
        EntityMappingsIncompleteOwningJUnitTestCase.assertTrue((String)"Error updating Employee's Security Badge", (newEmployee.getSecurityBadge().getBadgeNumber() == 69 ? 1 : 0) != 0);
    }
}

