/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataFactory;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.libraries.asm.AnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.Attribute;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.EclipseLinkAnnotationVisitor;
import org.eclipse.persistence.internal.libraries.asm.EclipseLinkClassReader;
import org.eclipse.persistence.internal.libraries.asm.EclipseLinkClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.EclipseLinkFieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.EclipseLinkMethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.FieldVisitor;
import org.eclipse.persistence.internal.libraries.asm.MethodVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class MetadataAsmFactory
extends MetadataFactory {
    public static final String PRIMITIVES = "VJIBZCSFD";
    public static final String TOKENS = "()<>;";

    public MetadataAsmFactory(MetadataLogger logger, ClassLoader loader) {
        super(logger, loader);
        this.addMetadataClass("I", new MetadataClass((MetadataFactory)this, Integer.TYPE));
        this.addMetadataClass("J", new MetadataClass((MetadataFactory)this, Long.TYPE));
        this.addMetadataClass("S", new MetadataClass((MetadataFactory)this, Short.TYPE));
        this.addMetadataClass("Z", new MetadataClass((MetadataFactory)this, Boolean.TYPE));
        this.addMetadataClass("F", new MetadataClass((MetadataFactory)this, Float.TYPE));
        this.addMetadataClass("D", new MetadataClass((MetadataFactory)this, Double.TYPE));
        this.addMetadataClass("C", new MetadataClass((MetadataFactory)this, Character.TYPE));
        this.addMetadataClass("B", new MetadataClass((MetadataFactory)this, Byte.TYPE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildClassMetadata(MetadataClass metadataClass, String className, boolean isLazy) {
        ClassMetadataVisitor visitor = new ClassMetadataVisitor(metadataClass, isLazy);
        InputStream stream = null;
        try {
            String resourceString = className.replace('.', '/') + ".class";
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                final String f_resourceString = resourceString;
                stream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return MetadataAsmFactory.this.m_loader.getResourceAsStream(f_resourceString);
                    }
                });
            } else {
                stream = this.m_loader.getResourceAsStream(resourceString);
            }
            ClassReader reader = new ClassReader(stream);
            Attribute[] attributes = new Attribute[]{};
            reader.accept((ClassVisitor)visitor, attributes, 7);
        }
        catch (IllegalArgumentException iae) {
            SessionLog log;
            SessionLog sessionLog = log = this.getLogger().getSession() != null ? this.getLogger().getSession().getSessionLog() : AbstractSessionLog.getLog();
            if (log.shouldLog(6, "metadata")) {
                SessionLogEntry entry = new SessionLogEntry(this.getLogger().getSession(), 6, "metadata", (Throwable)iae);
                entry.setMessage(ExceptionLocalization.buildMessage((String)"unsupported_classfile_version", (Object[])new Object[]{className}));
                log.log(entry);
            }
            if (stream != null) {
                try {
                    EclipseLinkClassReader reader = new EclipseLinkClassReader(stream);
                    Attribute[] attributes = new Attribute[]{};
                    reader.accept((ClassVisitor)visitor, attributes, 7);
                }
                catch (Exception e) {
                    if (log.shouldLog(7, "metadata")) {
                        SessionLogEntry entry = new SessionLogEntry(this.getLogger().getSession(), 7, "metadata", (Throwable)e);
                        entry.setMessage(ExceptionLocalization.buildMessage((String)"unsupported_classfile_version", (Object[])new Object[]{className}));
                        log.log(entry);
                    }
                    this.addMetadataClass(this.getVirtualMetadataClass(className));
                }
            } else {
                this.addMetadataClass(this.getVirtualMetadataClass(className));
            }
        }
        catch (Exception exception) {
            SessionLog log;
            SessionLog sessionLog = log = this.getLogger().getSession() != null ? this.getLogger().getSession().getSessionLog() : AbstractSessionLog.getLog();
            if (log.shouldLog(1, "metadata")) {
                log.logThrowable(1, "metadata", (Throwable)exception);
            }
            this.addMetadataClass(this.getVirtualMetadataClass(className));
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iae) {}
        }
    }

    @Override
    public MetadataClass getMetadataClass(String className) {
        return this.getMetadataClass(className, false);
    }

    @Override
    public MetadataClass getMetadataClass(String className, boolean isLazy) {
        if (className == null) {
            return null;
        }
        MetadataClass metaClass = (MetadataClass)this.m_metadataClasses.get(className);
        if (metaClass == null || !isLazy && metaClass.isLazy()) {
            if (metaClass != null) {
                metaClass.setIsLazy(false);
            }
            this.buildClassMetadata(metaClass, className, isLazy);
            metaClass = (MetadataClass)this.m_metadataClasses.get(className);
        }
        return metaClass;
    }

    @Override
    public void resolveGenericTypes(MetadataClass child, List<String> genericTypes, MetadataClass parent, MetadataDescriptor descriptor) {
        List<String> parentGenericTypes;
        if (genericTypes != null && (parentGenericTypes = parent.getGenericType()) != null) {
            ArrayList<String> genericParentTemp = new ArrayList<String>(genericTypes);
            genericParentTemp.removeAll(child.getInterfaces());
            int size = genericParentTemp.size();
            int parentIndex = 0;
            for (int index = genericTypes.indexOf(parent.getName()) + 1; index < size; ++index) {
                String variable;
                String actualTypeArgument = genericTypes.get(index);
                if (parentIndex >= parentGenericTypes.size() || (variable = parentGenericTypes.get(parentIndex)).equals(parent.getSuperclassName())) break;
                parentIndex += 3;
                if (actualTypeArgument.length() == 1) {
                    actualTypeArgument = genericTypes.get(++index);
                    descriptor.addGenericType(variable, descriptor.getGenericType(actualTypeArgument));
                    continue;
                }
                descriptor.addGenericType(variable, actualTypeArgument);
            }
        }
    }

    private MetadataClass getVirtualMetadataClass(String className) {
        MetadataClass metadataClass = new MetadataClass(this, className, false);
        if (className.length() > 5 && className.substring(0, 5).equals("java.")) {
            try {
                Class<?> reflectClass = Class.forName(className);
                if (reflectClass.getSuperclass() != null) {
                    metadataClass.setSuperclassName(reflectClass.getSuperclass().getName());
                }
                for (Class<?> reflectInterface : reflectClass.getInterfaces()) {
                    metadataClass.addInterface(reflectInterface.getName());
                }
            }
            catch (Exception failed) {
                SessionLog log;
                SessionLog sessionLog = log = this.getLogger().getSession() != null ? this.getLogger().getSession().getSessionLog() : AbstractSessionLog.getLog();
                if (log.shouldLog(3, "metadata")) {
                    log.logThrowable(3, "metadata", (Throwable)failed);
                }
                metadataClass.setIsAccessible(false);
            }
        } else {
            metadataClass.setIsAccessible(false);
        }
        return metadataClass;
    }

    private static List<String> processDescription(String desc, boolean isGeneric) {
        if (desc == null) {
            return null;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        int length = desc.length();
        boolean isGenericTyped = false;
        char[] chars = desc.toCharArray();
        for (int index = 0; index < length; ++index) {
            int start;
            char next = chars[index];
            if ('(' == next || ')' == next || '<' == next || '>' == next || ';' == next) continue;
            if (next == 'L') {
                start = ++index;
                next = chars[index];
                while ('(' != next && ')' != next && '<' != next && '>' != next && ';' != next) {
                    next = chars[++index];
                }
                arguments.add(MetadataAsmFactory.toClassName(desc.substring(start, index)));
                if (!isGenericTyped) continue;
                isGenericTyped = false;
                if (next != '<') continue;
                int cnt = 1;
                while (cnt > 0 && ++index < desc.length()) {
                    switch (desc.charAt(index)) {
                        case '<': {
                            ++cnt;
                            break;
                        }
                        case '>': {
                            --cnt;
                        }
                    }
                }
                continue;
            }
            if (!isGeneric && PRIMITIVES.indexOf(next) != -1) {
                arguments.add(MetadataAsmFactory.getPrimitiveName(next));
                continue;
            }
            if (next == '[') {
                start = index++;
                next = chars[index];
                while (next == '[') {
                    next = chars[++index];
                }
                if (PRIMITIVES.indexOf(next) == -1) {
                    while (next != ';') {
                        next = chars[++index];
                    }
                    arguments.add(MetadataAsmFactory.toClassName(desc.substring(start, index + 1)));
                    continue;
                }
                arguments.add(desc.substring(start, index + 1));
                continue;
            }
            int end = start = index;
            char myNext = next;
            while (':' != myNext && '(' != myNext && ')' != myNext && '<' != myNext && '>' != myNext && ';' != myNext && end < length - 1) {
                myNext = chars[++end];
            }
            if (myNext == ':') {
                arguments.add(desc.substring(start, end));
                isGenericTyped = true;
                index = end;
                arguments.add(":");
                if (desc.charAt(index + 1) != ':') continue;
                ++index;
                continue;
            }
            if (myNext == ';' && next == 'T') {
                arguments.add(new String(new char[]{next}));
                arguments.add(desc.substring(start + 1, end));
                index = end - 1;
                continue;
            }
            arguments.add(new String(new char[]{next}));
        }
        return arguments;
    }

    private static String getPrimitiveName(char primitive) {
        if (primitive == 'V') {
            return "void";
        }
        if (primitive == 'I') {
            return "int";
        }
        if (primitive == 'Z') {
            return "boolean";
        }
        if (primitive == 'J') {
            return "long";
        }
        if (primitive == 'F') {
            return "float";
        }
        if (primitive == 'D') {
            return "double";
        }
        if (primitive == 'B') {
            return "byte";
        }
        if (primitive == 'C') {
            return "char";
        }
        if (primitive == 'S') {
            return "short";
        }
        return new String(new char[]{primitive});
    }

    private static String toClassName(String classDescription) {
        if (classDescription == null) {
            return "void";
        }
        return classDescription.replace('/', '.');
    }

    private static Object annotationValue(String description, Object value) {
        if (value instanceof Type) {
            return ((Type)value).getClassName();
        }
        return value;
    }

    class MetadataMethodVisitor
    extends EclipseLinkMethodVisitor {
        private MetadataMethod method;

        public MetadataMethodVisitor(MetadataClass classMetadata, int access, String name, String desc, String signature, String[] exceptions) {
            this.method = new MetadataMethod(MetadataAsmFactory.this, classMetadata);
            this.method.setName(name);
            this.method.setAttributeName(Helper.getAttributeNameFromMethodName((String)name));
            this.method.setModifiers(access);
            this.method.setGenericType(MetadataAsmFactory.processDescription(desc, true));
            List argumentNames = MetadataAsmFactory.processDescription(signature, false);
            if (argumentNames != null && !argumentNames.isEmpty()) {
                this.method.setReturnType((String)argumentNames.get(argumentNames.size() - 1));
                argumentNames.remove(argumentNames.size() - 1);
                this.method.setParameters(argumentNames);
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Ljakarta/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                return new MetadataAnnotationVisitor(this.method, desc);
            }
            return null;
        }

        public void visitEnd() {
            MetadataClass classMetadata = this.method.getMetadataClass();
            MetadataMethod existing = classMetadata.getMethods().get(this.method.getName());
            if (existing == null) {
                classMetadata.getMethods().put(this.method.getName(), this.method);
            } else {
                while (existing.getNext() != null) {
                    existing = existing.getNext();
                }
                existing.setNext(this.method);
            }
        }
    }

    class MetadataFieldVisitor
    extends EclipseLinkFieldVisitor {
        private MetadataField field;

        public MetadataFieldVisitor(MetadataClass classMetadata, int access, String name, String desc, String signature, Object value) {
            this.field = new MetadataField(classMetadata);
            this.field.setModifiers(access);
            this.field.setName(name);
            this.field.setAttributeName(name);
            this.field.setGenericType(MetadataAsmFactory.processDescription(signature, true));
            this.field.setType((String)MetadataAsmFactory.processDescription(desc, false).get(0));
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.startsWith("Ljavax/persistence") || desc.startsWith("Ljakarta/persistence") || desc.startsWith("Lorg/eclipse/persistence")) {
                return new MetadataAnnotationVisitor(this.field, desc);
            }
            return null;
        }

        public void visitEnd() {
            this.field.getDeclaringClass().addField(this.field);
        }
    }

    class MetadataAnnotationArrayVisitor
    extends EclipseLinkAnnotationVisitor {
        private MetadataAnnotation annotation;
        private String attributeName;
        private List<Object> values;

        public MetadataAnnotationArrayVisitor(MetadataAnnotation annotation, String name) {
            this.annotation = annotation;
            this.attributeName = name;
            this.values = new ArrayList<Object>();
        }

        public void visit(String name, Object value) {
            this.values.add(MetadataAsmFactory.annotationValue(null, value));
        }

        public void visitEnum(String name, String desc, String value) {
            this.values.add(MetadataAsmFactory.annotationValue(desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            MetadataAnnotation mda = new MetadataAnnotation();
            mda.setName((String)MetadataAsmFactory.processDescription(desc, false).get(0));
            this.values.add(mda);
            return new MetadataAnnotationVisitor(mda);
        }

        public void visitEnd() {
            this.annotation.addAttribute(this.attributeName, this.values.toArray());
        }
    }

    class MetadataAnnotationVisitor
    extends EclipseLinkAnnotationVisitor {
        private MetadataAnnotatedElement element;
        private MetadataAnnotation annotation;

        MetadataAnnotationVisitor(MetadataAnnotatedElement element, String name) {
            this(element, name, true);
        }

        MetadataAnnotationVisitor(MetadataAnnotatedElement element, String name, boolean isRegular) {
            this.element = element;
            this.annotation = new MetadataAnnotation();
            this.annotation.setName((String)MetadataAsmFactory.processDescription(name, false).get(0));
            this.annotation.setIsMeta(!isRegular);
        }

        public MetadataAnnotationVisitor(MetadataAnnotation annotation) {
            this.annotation = annotation;
        }

        public void visit(String name, Object value) {
            this.annotation.addAttribute(name, MetadataAsmFactory.annotationValue(null, value));
        }

        public void visitEnum(String name, String desc, String value) {
            this.annotation.addAttribute(name, MetadataAsmFactory.annotationValue(desc, value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            MetadataAnnotation mda = new MetadataAnnotation();
            mda.setName((String)MetadataAsmFactory.processDescription(desc, false).get(0));
            this.annotation.addAttribute(name, mda);
            return new MetadataAnnotationVisitor(mda);
        }

        public AnnotationVisitor visitArray(String name) {
            return new MetadataAnnotationArrayVisitor(this.annotation, name);
        }

        public void visitEnd() {
            if (this.element != null) {
                if (this.annotation.isMeta()) {
                    this.element.addMetaAnnotation(this.annotation);
                } else {
                    this.element.addAnnotation(this.annotation);
                }
            }
        }
    }

    public class ClassMetadataVisitor
    extends EclipseLinkClassVisitor {
        private boolean isLazy;
        private boolean processedMemeber;
        private MetadataClass classMetadata;

        ClassMetadataVisitor(MetadataClass metadataClass, boolean isLazy) {
            this.isLazy = isLazy;
            this.classMetadata = metadataClass;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            String className = MetadataAsmFactory.toClassName(name);
            if (this.classMetadata == null || !this.classMetadata.getName().equals(className)) {
                this.classMetadata = new MetadataClass(MetadataAsmFactory.this, className, this.isLazy);
                MetadataAsmFactory.this.addMetadataClass(this.classMetadata);
            }
            this.classMetadata.setName(className);
            this.classMetadata.setSuperclassName(MetadataAsmFactory.toClassName(superName));
            this.classMetadata.setModifiers(access);
            this.classMetadata.setGenericType(MetadataAsmFactory.processDescription(signature, true));
            for (String interfaceName : interfaces) {
                this.classMetadata.addInterface(MetadataAsmFactory.toClassName(interfaceName));
            }
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            this.processedMemeber = true;
            if (this.classMetadata.isLazy()) {
                return null;
            }
            return new MetadataFieldVisitor(this.classMetadata, access, name, desc, signature, value);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            this.processedMemeber = true;
            if (this.classMetadata.isLazy() || name.indexOf("init>") != -1) {
                return null;
            }
            return new MetadataMethodVisitor(this.classMetadata, access, name, signature, desc, exceptions);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            boolean isJPA = false;
            if (desc.startsWith("Lkotlin")) {
                return null;
            }
            if (desc.startsWith("Ljava")) {
                char c = desc.charAt(5);
                if (c == '/') {
                    return null;
                }
                if (desc.regionMatches(5, "x/", 0, 2)) {
                    if (desc.regionMatches(7, "persistence", 0, "persistence".length())) {
                        isJPA = true;
                    } else {
                        return null;
                    }
                }
            }
            if (desc.startsWith("Ljakarta")) {
                if (desc.regionMatches(9, "persistence", 0, "persistence".length())) {
                    isJPA = true;
                } else {
                    return null;
                }
            }
            if (!this.processedMemeber && this.classMetadata.isLazy()) {
                this.classMetadata.setIsLazy(false);
            }
            return new MetadataAnnotationVisitor(this.classMetadata, desc, isJPA || desc.startsWith("Lorg/eclipse/persistence"));
        }
    }
}

