/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ResourceLimitException;
import oracle.kv.impl.util.SerializationUtil;

public class ChildTableLimitException
extends ResourceLimitException {
    private static final long serialVersionUID = 1L;
    private final int childTableLimit;

    public ChildTableLimitException(String tableName, int childTableLimit, String msg) {
        super(tableName, msg);
        assert (tableName != null);
        this.childTableLimit = childTableLimit;
    }

    public ChildTableLimitException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.childTableLimit = SerializationUtil.readPackedInt(in);
    }

    public int getChildTableLimit() {
        return this.childTableLimit;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writePackedInt(out, this.childTableLimit);
    }
}

