/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.DoubleRangeValue;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.DoubleDef;
import oracle.kv.table.FieldDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
public class DoubleDefImpl
extends FieldDefImpl
implements DoubleDef {
    private static final long serialVersionUID = 1L;
    private Double min;
    private Double max;

    DoubleDefImpl(String description, Double min, Double max) {
        super(FieldDef.Type.DOUBLE, description);
        this.min = min;
        this.max = max;
        this.validate();
    }

    DoubleDefImpl(String description) {
        this(description, null, null);
    }

    DoubleDefImpl() {
        this(null, null, null);
    }

    private DoubleDefImpl(DoubleDefImpl impl) {
        super(impl);
        this.min = impl.min;
        this.max = impl.max;
    }

    @Override
    public DoubleDefImpl clone() {
        if (this == FieldDefImpl.doubleDef) {
            return this;
        }
        return new DoubleDefImpl(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.min != null ? this.min.hashCode() : 0) + (this.max != null ? this.max.hashCode() : 0);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof DoubleDefImpl;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public DoubleDef asDouble() {
        return this;
    }

    @Override
    public DoubleValueImpl createDouble(double value) {
        return this.hasMin() || this.hasMax() ? new DoubleRangeValue(value, this) : new DoubleValueImpl(value);
    }

    @Override
    DoubleValueImpl createDouble(String value) {
        return this.hasMin() || this.hasMax() ? new DoubleRangeValue(value, this) : new DoubleValueImpl(value);
    }

    @Override
    public short getRequiredSerialVersion() {
        return 4;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    @Override
    public Double getMax() {
        return this.max;
    }

    @Override
    public boolean hasMin() {
        return this.min != null;
    }

    @Override
    public boolean hasMax() {
        return this.max != null;
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isDouble() || superType.isNumber() || superType.isAny() || superType.isAnyAtomic() || superType.isAnyJsonAtomic() || superType.isJson();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        if (this.min != null) {
            node.put("min", this.min);
        }
        if (this.max != null) {
            node.put("max", this.max);
        }
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isDouble()) {
            throw new IllegalArgumentException("Default value for type DOUBLE is not double");
        }
        return this.createDouble(node.getDoubleValue());
    }

    private void validate() {
        if (this.min != null && this.max != null && this.min > this.max) {
            throw new IllegalArgumentException("Invalid min or max value");
        }
    }

    void validateValue(double val) {
        if (this.min != null && val < this.min || this.max != null && val > this.max) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value, ");
            sb.append(val);
            sb.append(", is outside of the allowed range");
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

