/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.clientserver;

import java.util.Random;
import java.util.Vector;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Address;
import org.eclipse.persistence.testing.tests.clientserver.Server;

public class ClientServerUpdateDeadlockTest
extends TestCase {
    protected DatabaseLogin login;
    protected UpdateDeadlockClient[] clients = new UpdateDeadlockClient[NUM_CLIENTS];
    protected Server server;
    public static int NUM_CLIENTS = 15;

    public ClientServerUpdateDeadlockTest() {
        this.setDescription("Tests running a number of threads updating the same employees.");
    }

    public void setup() {
        this.login = (DatabaseLogin)this.getSession().getLogin().clone();
        this.server = new Server(this.login);
        this.server.serverSession.setSessionLog(this.getSession().getSessionLog());
        this.server.login();
        this.server.copyDescriptors(this.getSession());
        for (int index = 0; index < NUM_CLIENTS; ++index) {
            this.clients[index] = new UpdateDeadlockClient(this.server, this.getSession(), "Client" + index, index);
        }
    }

    public void reset() {
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            this.clients[i].release();
        }
        this.server.logout();
        this.getDatabaseSession().logout();
        this.getDatabaseSession().login();
    }

    public void test() {
        int i;
        for (i = 0; i < NUM_CLIENTS; ++i) {
            this.clients[i].start();
        }
        try {
            for (i = 0; i < NUM_CLIENTS; ++i) {
                this.clients[i].join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void verify() {
        for (int i = 0; i < NUM_CLIENTS; ++i) {
            if (this.clients[i].exception == null) continue;
            throw new TestErrorException("Error occurred, check system.out");
        }
    }

    protected class UpdateDeadlockClient
    extends Thread {
        protected int index;
        protected Server server;
        protected Session clientSession;
        protected Session session;
        public Throwable exception;

        public UpdateDeadlockClient(Server server, Session session, String name, int index) {
            super(name);
            this.index = index;
            this.server = server;
            this.session = session;
            this.clientSession = this.server.serverSession.acquireClientSession();
        }

        public void release() {
            this.clientSession.release();
        }

        @Override
        public void run() {
            try {
                for (int index = 0; index < 5; ++index) {
                    UnitOfWork uow = this.clientSession.acquireUnitOfWork();
                    uow.setCommitOrder(UnitOfWork.CommitOrderType.ID);
                    Vector addresses = uow.readAllObjects(Address.class);
                    Random random = new Random();
                    for (Address address : addresses) {
                        if (!random.nextBoolean()) continue;
                        address.setCity(this.getName() + index);
                    }
                    uow.commit();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.exception = t;
            }
        }
    }
}

