/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.plsql;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.plsql.Address;
import org.eclipse.persistence.testing.models.plsql.Employee;
import org.eclipse.persistence.testing.models.plsql.PLSQLSystem;
import org.eclipse.persistence.testing.models.plsql.Phone;
import org.eclipse.persistence.testing.tests.plsql.PLSQLTest;

public class PLSQLTestModel
extends TestModel {
    public PLSQLTestModel() {
        this.setDescription("This model tests calling PLSQL stored procedures with PLSQL types.");
    }

    public void addRequiredSystems() {
        if (!this.getSession().getLogin().getPlatform().isOracle()) {
            PLSQLTestModel.warning((String)"PLSQL is only supported on Oracle.");
        }
        this.addRequiredSystem(new PLSQLSystem());
    }

    public void addTests() {
        this.addTest((Test)PLSQLTestModel.getSimpleTestSuite());
        this.addTest((Test)PLSQLTestModel.getRecordTestSuite());
        this.addTest((Test)PLSQLTestModel.getCollectionTestSuite());
        this.addTest((Test)PLSQLTestModel.getFunctionTestSuite());
        this.addTest((Test)PLSQLTestModel.getErrorTestSuite());
    }

    public static TestSuite getErrorTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("PLSQLErrorTestSuite");
        suite.setDescription("This suite tests calling PLSQL procedures with invalid arguments.");
        ArrayList<Object> args = new ArrayList<Object>();
        PLSQLTest test = new PLSQLTest("BadAddressOut", Address.class, args, (Object)QueryException.typeNameNotSet(null));
        test.setName("BadAddressOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        test = new PLSQLTest("MissingTypeAddressListOut", Address.class, args, (Object)QueryException.compatibleTypeNotSet(null));
        test.setName("MissingTypeAddressListOutTest");
        suite.addTest((Test)test);
        Employee employee = new Employee();
        employee.setId(new BigDecimal(123));
        employee.setName("Bad Jones");
        args = new ArrayList();
        DatabaseRecord result = new DatabaseRecord();
        result.put("P_EMP", (Object)employee);
        result.put("P_CITY", (Object)"Nepean");
        args.add(employee);
        args.add("Nepean");
        test = new PLSQLTest("EmployeeInOutObject", Employee.class, args, result);
        test.setName("EmptyEmployeeInOutObjectTest");
        return suite;
    }

    public static TestSuite getSimpleTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("PLSQLSimpleTestSuite");
        suite.setDescription("This suite tests calling PLSQL procedures that take simple types.");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("varchar");
        args.add(1);
        args.add(123);
        args.add(new BigDecimal("123.6"));
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(new BigDecimal("123.5"));
        PLSQLTest test = new PLSQLTest("SimpleIn", Address.class, args);
        test.setName("SimpleInTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(1);
        args.add(123);
        args.add(new BigDecimal("123.6"));
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(new BigDecimal("123.5"));
        test = new PLSQLTest("SimpleInDefaults", Address.class, args);
        test.setName("SimpleInDefaults");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        args.add(null);
        test = new PLSQLTest("SimpleInDefaults2", Address.class, args);
        test.setName("SimpleInDefaults2");
        suite.addTest((Test)test);
        args = new ArrayList();
        test = new PLSQLTest("SimpleOut", Address.class, args);
        test.setName("SimpleOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add("varchar");
        args.add(1);
        args.add(123);
        args.add(new BigDecimal("123.6"));
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(new BigDecimal("123.5"));
        test = new PLSQLTest("SimpleInOut", Address.class, args);
        test.setName("SimpleInOutTest");
        suite.addTest((Test)test);
        return suite;
    }

    public static TestSuite getFunctionTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("PLSQLFunctionTestSuite");
        suite.setDescription("This suite tests calling PLSQL functions.");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("varchar");
        args.add(1);
        args.add(123);
        args.add(new BigDecimal("123.6"));
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(1);
        args.add(new BigDecimal("123.5"));
        PLSQLTest test = new PLSQLTest("SimpleInFunc", Address.class, args);
        test.setName("SimpleInFuncTest");
        suite.addTest((Test)test);
        Address resultAddress = new Address();
        resultAddress.setId(new BigDecimal(1234));
        resultAddress.setNumber(17);
        resultAddress.setStreet("Bank");
        resultAddress.setCity("Ottawa");
        resultAddress.setState("ON");
        args = new ArrayList();
        DatabaseRecord result = new DatabaseRecord();
        result.put("RESULT", (Object)resultAddress);
        test = new PLSQLTest("AddressOutObjectFunc", Address.class, args, result);
        test.setName("AddressOutFuncTest");
        suite.addTest((Test)test);
        return suite;
    }

    public static TestSuite getRecordTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("PLSQLRecordTestSuite");
        suite.setDescription("This suite tests calling PLSQL procedures that take records.");
        Address address = new Address();
        address.setId(new BigDecimal(123));
        address.setNumber(17);
        address.setStreet("Bank");
        address.setCity("Ottawa");
        address.setState("ON");
        Address resultAddress = new Address();
        resultAddress.setId(new BigDecimal(1234));
        resultAddress.setNumber(17);
        resultAddress.setStreet("Bank");
        resultAddress.setCity("Ottawa");
        resultAddress.setState("ON");
        Phone phone = new Phone();
        phone.setAreaCode("613");
        phone.setNumber("7927711");
        Employee employee = new Employee();
        employee.setId(new BigDecimal(123));
        employee.setName("Bob Jones");
        employee.setAddress(address);
        employee.getPhones().add(phone);
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(address);
        DatabaseRecord result = new DatabaseRecord();
        result.put("P_ADDRESS", (Object)resultAddress);
        PLSQLTest test = new PLSQLTest("AddressInOutObject", Address.class, args, result);
        test.setName("AddressInOutObjectTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(address.getId());
        args.add(address.getNumber());
        args.add(address.getStreet());
        args.add(address.getCity());
        args.add(address.getState());
        args.add("Local");
        result = new DatabaseRecord();
        result.put("ADDRESS_ID", (Object)resultAddress.getId());
        result.put("ADDRESS_NUM", (Object)resultAddress.getNumber());
        result.put("STREET", (Object)resultAddress.getStreet());
        result.put("CITY", (Object)resultAddress.getCity());
        result.put("STATE", (Object)resultAddress.getState());
        result.put("P_LOCAL", (Object)"Nepean");
        test = new PLSQLTest("AddressInOutData", Address.class, args);
        test.setName("AddressInOutDataTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(address.getId());
        args.add(address.getNumber());
        args.add(address.getStreet());
        args.add(address.getCity());
        args.add(address.getState());
        args.add("Local");
        test = new PLSQLTest("AddressInData", Address.class, args);
        test.setName("AddressInDataTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(address);
        test = new PLSQLTest("AddressInObject", Address.class, args);
        test.setName("AddressInObjectTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        result = new DatabaseRecord();
        result.put("P_ADDRESS", (Object)resultAddress);
        test = new PLSQLTest("AddressOutObject", Address.class, args, result);
        test.setName("AddressOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        result = new DatabaseRecord();
        result.put("ADDRESS_ID", (Object)resultAddress.getId());
        result.put("STREET_NUM", (Object)resultAddress.getNumber());
        result.put("STREET", (Object)resultAddress.getStreet());
        result.put("CITY", (Object)resultAddress.getCity());
        result.put("STATE", (Object)resultAddress.getState());
        result.put("P_LOCAL", (Object)"Local");
        test = new PLSQLTest("AddressOutData", Address.class, args, result);
        test.setName("AddressOutDataTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(employee);
        args.add("Nepean");
        test = new PLSQLTest("EmployeeInObject", Employee.class, args);
        test.setName("EmployeeInObjectTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        result = new DatabaseRecord();
        result.put("P_EMP", (Object)new Employee());
        result.put("P_CITY", (Object)"Nepean");
        test = new PLSQLTest("EmployeeOutObject", Employee.class, args, result);
        test.setName("EmployeeOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        result = new DatabaseRecord();
        result.put("P_EMP", (Object)employee);
        result.put("P_CITY", (Object)"Nepean");
        args.add(employee);
        args.add("Nepean");
        test = new PLSQLTest("EmployeeInOutObject", Employee.class, args, result);
        test.setName("EmployeeInOutObjectTest");
        suite.addTest((Test)test);
        test = new PLSQLTest("AddressOutCursor", Address.class, new ArrayList(), new Vector());
        test.setName("AddressOutCursorTest");
        suite.addTest((Test)test);
        test = new PLSQLTest("AddressRecOutCursor", Address.class, new ArrayList(), new Vector());
        test.setName("AddressRecOutCursorTest");
        suite.addTest((Test)test);
        return suite;
    }

    public static TestSuite getCollectionTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("PLSQLCollectionTestSuite");
        suite.setDescription("This suite tests calling PLSQL procedures that take collections.");
        Address address = new Address();
        address.setId(new BigDecimal(123));
        address.setNumber(17);
        address.setStreet("Bank");
        address.setCity("Ottawa");
        address.setState("ON");
        Phone phone = new Phone();
        phone.setAreaCode("613");
        phone.setNumber("7927711");
        Employee employee = new Employee();
        employee.setId(new BigDecimal(123));
        employee.setName("Bob Jones");
        employee.setAddress(address);
        employee.getPhones().add(phone);
        ArrayList<Object> args = new ArrayList<Object>();
        DatabaseRecord result = new DatabaseRecord();
        ArrayList<Object> collection = new ArrayList<String>();
        collection.add("Ottawa");
        result.put("P_CITY_LIST", collection);
        result.put("P_CITY", (Object)"Nepean");
        PLSQLTest test = new PLSQLTest("CityListOut", Address.class, args, result);
        test.setName("CityListOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        collection = new ArrayList<String>(Arrays.asList("Ottawa", "Toronto"));
        args.add(collection);
        args.add("Nepean");
        result = new DatabaseRecord();
        result.put("P_CITY_LIST", collection);
        result.put("P_CITY", (Object)"Nepean");
        test = new PLSQLTest("CityListInOut", Address.class, args, result);
        test.setName("CityListInOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(new Object[]{address, address});
        args.add("Nepean");
        test = new PLSQLTest("AddressListIn", Address.class, args);
        test.setName("AddressListInTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        result = new DatabaseRecord();
        result.put("P_ADDRESS_LIST", new ArrayList());
        result.put("P_CITY", (Object)"Nepean");
        test = new PLSQLTest("AddressListOut", Address.class, args, result);
        test.setName("AddressListOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        collection = new ArrayList<Object>(Arrays.asList(address, address));
        args.add(collection);
        args.add("Nepean");
        result = new DatabaseRecord();
        result.put("P_ADDRESS_LIST", collection);
        result.put("P_CITY", (Object)"Nepean");
        test = new PLSQLTest("AddressListInOut", Address.class, args, result);
        test.setName("AddressListInOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        args.add(new Object[]{employee, employee});
        args.add("Nepean");
        test = new PLSQLTest("EmployeeListIn", Employee.class, args);
        test.setName("EmployeeListInTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        result = new DatabaseRecord();
        result.put("P_EMP_LIST", new ArrayList());
        result.put("P_CITY", (Object)"Nepean");
        test = new PLSQLTest("EmployeeListOut", Employee.class, args, result);
        test.setName("EmployeeListOutTest");
        suite.addTest((Test)test);
        args = new ArrayList();
        collection = new ArrayList<Object>(Arrays.asList(employee, employee));
        args.add(collection);
        args.add("Nepean");
        result = new DatabaseRecord();
        result.put("P_EMP_LIST", collection);
        result.put("P_CITY", (Object)"Nepean");
        test = new PLSQLTest("EmployeeListInOut", Employee.class, args, result);
        test.setName("EmployeeListInOutTest");
        suite.addTest((Test)test);
        return suite;
    }
}

