/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.readonly;

import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.readonly.Address;
import org.eclipse.persistence.testing.models.readonly.Country;
import org.eclipse.persistence.testing.models.readonly.Promoter;

public class ReadOnlyClassAccessingTestCase
extends TestCase {
    protected boolean areEqual(Set ht, Vector v1) {
        if (v1.size() != ht.size()) {
            return false;
        }
        Enumeration enumtr = v1.elements();
        while (enumtr.hasMoreElements()) {
            if (ht.contains(enumtr.nextElement())) continue;
            return false;
        }
        return true;
    }

    protected boolean areEqual(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            return false;
        }
        Enumeration enumtr = v1.elements();
        while (enumtr.hasMoreElements()) {
            if (v2.contains(enumtr.nextElement())) continue;
            return false;
        }
        enumtr = v2.elements();
        while (enumtr.hasMoreElements()) {
            if (v1.contains(enumtr.nextElement())) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        this.getSession().getProject().setDefaultReadOnlyClasses(new Vector());
    }

    protected void setup() {
        this.getSession().getProject().setDefaultReadOnlyClasses(new Vector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void test() {
        UnitOfWork uow1 = this.getSession().acquireUnitOfWork();
        if (!uow1.getReadOnlyClasses().isEmpty()) {
            throw new TestErrorException(" When acquiring a UnitOfWork from a Session, the read-only classes where not empty as expected.");
        }
        uow1.release();
        Vector<Class> classes = new Vector<Class>();
        classes.addElement(Promoter.class);
        classes.addElement(Country.class);
        UnitOfWork uow2 = this.getSession().acquireUnitOfWork();
        uow2.removeAllReadOnlyClasses();
        uow2.addReadOnlyClasses(classes);
        if (!this.areEqual(uow2.getReadOnlyClasses(), classes)) {
            throw new TestErrorException("When acquiring a UnitOfWork from a Session, the read-only classes specified did not get set in the UnitOfWork;");
        }
        Enumeration enumtr = classes.elements();
        while (enumtr.hasMoreElements()) {
            if (uow2.isClassReadOnly((Class)enumtr.nextElement())) continue;
            throw new TestErrorException("Testing whether a class is read-only or not has failed.");
        }
        if (uow2.isClassReadOnly(Vector.class)) {
            throw new TestErrorException("Testing whether a class is read-only or not has failed.");
        }
        uow2.removeReadOnlyClass(Promoter.class);
        if (uow2.isClassReadOnly(Promoter.class)) {
            throw new TestErrorException("The method removeReadOnlyClass(Class) failed.");
        }
        uow2.addReadOnlyClass(Promoter.class);
        if (!uow2.isClassReadOnly(Promoter.class)) {
            throw new TestErrorException("The method addReadOnlyClass(Class) failed.");
        }
        uow2.removeAllReadOnlyClasses();
        if (uow2.isClassReadOnly(Country.class) || !uow2.getReadOnlyClasses().isEmpty()) {
            throw new TestErrorException("Did not remove all the read-only classes from a UnitOfWork properly");
        }
        try {
            uow2.registerObject((Object)new Address());
            uow2.removeAllReadOnlyClasses();
            uow2.addReadOnlyClasses(classes);
            if (this.areEqual(uow2.getReadOnlyClasses(), classes)) {
                throw new TestErrorException("Shouldn't be able to change the readOnlyClasses of a UnitOfWork after an object was registered.");
            }
        }
        catch (ValidationException ex) {
            this.getSession().logMessage("Caught validation exeception...OK");
        }
        finally {
            uow2.release();
        }
        Vector<Class> someClasses = new Vector<Class>();
        someClasses.addElement(Country.class);
        someClasses.addElement(Address.class);
        this.getSession().getProject().setDefaultReadOnlyClasses(someClasses);
        UnitOfWork uow3 = this.getSession().acquireUnitOfWork();
        if (!this.areEqual(uow3.getReadOnlyClasses(), someClasses)) {
            throw new TestErrorException("The default read-only classes were not set properly when a UnitOfWork was aquired");
        }
        UnitOfWork uow4 = uow3.acquireUnitOfWork();
        try {
            uow4.removeAllReadOnlyClasses();
        }
        catch (ValidationException ex) {
            this.getSession().logMessage("Check the nested units of work read-only classes. OK");
        }
        finally {
            uow3.release();
            uow4.release();
        }
        UnitOfWork uow5 = this.getSession().acquireUnitOfWork();
        UnitOfWork uow6 = uow5.acquireUnitOfWork();
        if (!this.areEqual(((UnitOfWorkImpl)uow5).getDefaultReadOnlyClasses(), ((UnitOfWorkImpl)uow6).getDefaultReadOnlyClasses())) {
            throw new TestErrorException("Nested UnitOfWorks did not return consistent default read-only classes.");
        }
        uow5.release();
        uow6.release();
    }

    protected boolean vectorsEqual(Vector v1, Vector v2) {
        if (v1.size() != v2.size()) {
            return false;
        }
        Enumeration enumtr = v1.elements();
        while (enumtr.hasMoreElements()) {
            if (v2.contains(enumtr.nextElement())) continue;
            return false;
        }
        enumtr = v2.elements();
        while (enumtr.hasMoreElements()) {
            if (v1.contains(enumtr.nextElement())) continue;
            return false;
        }
        return true;
    }
}

