/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.stress;

import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.server.Server;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.relational.EmployeeSystem;
import org.eclipse.persistence.testing.tests.stress.ClientThread;

public class StressThreeTierTest
extends AutoVerifyTestCase {
    public int stressLevel;

    public StressThreeTierTest(int stressLevel) {
        this.stressLevel = stressLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        Server server = null;
        try {
            int i;
            server = new Project(this.getSession().getDatasourceLogin()).createServerSession();
            new EmployeeSystem().addDescriptors((DatabaseSession)server);
            server.addConnectionPool("default", this.getSession().getDatasourceLogin(), 3, 5);
            server.useReadConnectionPool(3, 3);
            server.login();
            long startTime = System.currentTimeMillis();
            ClientThread client = new ClientThread(server);
            client.start();
            try {
                client.join();
            }
            catch (InterruptedException exception) {
                throw new TestErrorException(exception.toString());
            }
            long endTime = System.currentTimeMillis();
            System.out.println("Single thread total time -> " + (endTime - startTime));
            ClientThread[] clients = new ClientThread[this.stressLevel];
            for (i = 0; i < this.stressLevel; ++i) {
                clients[i] = new ClientThread(server);
            }
            startTime = System.currentTimeMillis();
            for (i = 0; i < this.stressLevel; ++i) {
                clients[i].start();
            }
            for (i = 0; i < this.stressLevel; ++i) {
                try {
                    clients[i].join();
                    continue;
                }
                catch (InterruptedException exception) {
                    throw new TestErrorException(exception.toString());
                }
            }
            endTime = System.currentTimeMillis();
            System.out.println("Concurrent thread total time -> " + (endTime - startTime));
        }
        finally {
            server.logout();
        }
    }
}

