/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.advanced;

import java.sql.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.framework.TestException;
import org.eclipse.persistence.testing.models.jpa.advanced.Address;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.advanced.ModelExamples;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.advanced.Project;
import org.eclipse.persistence.testing.tests.jpa.EntityContainerTestBase;

public class EMModifyAndCommitTest
extends EntityContainerTestBase {
    protected boolean reset = false;
    public Integer[] empIDs = new Integer[3];
    public Integer[] projIDs = new Integer[2];

    public EMModifyAndCommitTest() {
        this.setDescription("Test modify and commit in EntityManager");
    }

    @Override
    public void setup() {
        super.setup();
        this.reset = true;
        Employee empClone1 = ModelExamples.employeeExample1();
        empClone1.setAddress(ModelExamples.addressExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample1());
        empClone1.addPhoneNumber(ModelExamples.phoneExample9());
        Employee empClone2 = ModelExamples.employeeExample2();
        empClone2.setAddress(ModelExamples.addressExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample2());
        empClone2.addPhoneNumber(ModelExamples.phoneExample8());
        Employee empClone3 = ModelExamples.employeeExample3();
        empClone3.setAddress(ModelExamples.addressExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample3());
        empClone3.addPhoneNumber(ModelExamples.phoneExample7());
        empClone1.addManagedEmployee(empClone2);
        empClone1.addManagedEmployee(empClone3);
        Project projClone1 = ModelExamples.projectExample1();
        Project projClone2 = ModelExamples.projectExample2();
        projClone1.setTeamLeader(empClone1);
        projClone1.addTeamMember(empClone1);
        projClone1.addTeamMember(empClone2);
        projClone1.addTeamMember(empClone3);
        empClone1.addProject(projClone1);
        empClone2.addProject(projClone1);
        empClone3.addProject(projClone1);
        try {
            this.beginTransaction();
            this.getEntityManager().persist((Object)empClone1);
            this.getEntityManager().persist((Object)empClone2);
            this.getEntityManager().persist((Object)empClone3);
            this.getEntityManager().persist((Object)projClone1);
            this.getEntityManager().persist((Object)projClone2);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestException("Unable to setup Test" + ex);
        }
        ((EntityManagerImpl)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        this.empIDs[0] = empClone1.getId();
        this.empIDs[1] = empClone2.getId();
        this.empIDs[2] = empClone3.getId();
        this.projIDs[0] = projClone1.getId();
        this.projIDs[1] = projClone2.getId();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    @Override
    public void reset() {
        if (this.reset) {
            this.reset = false;
        }
        super.reset();
    }

    public void test() {
        Employee employee;
        Employee employee2;
        try {
            this.beginTransaction();
            employee2 = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
            Project project = (Project)this.getEntityManager().find(Project.class, (Object)this.projIDs[1]);
            project.addTeamMember(employee2);
            employee2.addProject(project);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring assignment of employee to a project" + ex);
        }
        try {
            this.beginTransaction();
            Employee managed = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
            Employee manager = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
            manager.addManagedEmployee(managed);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring assignement of employe to a manager" + ex);
        }
        try {
            this.beginTransaction();
            PhoneNumber phone = ModelExamples.phoneExample4();
            this.getEntityManager().persist((Object)phone);
            employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
            employee.addPhoneNumber(phone);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring assignment of a phone to an employee" + ex);
        }
        try {
            this.beginTransaction();
            List employees = this.getEntityManager().createQuery("SELECT OBJECT(employee) FROM Employee employee").getResultList();
            Iterator employeesIter = employees.iterator();
            int totalRaisePercent = 103;
            while (employeesIter.hasNext()) {
                Employee employee3 = (Employee)employeesIter.next();
                int newSalary = (int)((double)employee3.getSalary() * ((double)totalRaisePercent / 100.0));
                employee3.setSalary(newSalary);
            }
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring employee raises" + ex);
        }
        try {
            this.beginTransaction();
            employee2 = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
            employee2.setFirstName("Wilfred");
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring the change of employee's name" + ex);
        }
        try {
            this.beginTransaction();
            Address address = ModelExamples.addressExample4();
            this.getEntityManager().persist((Object)address);
            employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
            employee.setAddress(address);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring the change of employee's address" + ex);
        }
        try {
            this.beginTransaction();
            EmploymentPeriod period = new EmploymentPeriod();
            employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
            period.setStartDate(employee.getPeriod().getStartDate());
            period.setEndDate(new Date(System.currentTimeMillis()));
            employee.setPeriod(period);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring the firing of an employee" + ex);
        }
        try {
            this.beginTransaction();
            employee2 = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
            employee2.setSalary(0);
            this.commitTransaction();
        }
        catch (Exception ex) {
            this.rollbackTransaction();
            throw new TestErrorException("Exception thrown durring setting of employee's salary" + ex);
        }
    }

    public void verify() {
        Employee employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (!employee.getFirstName().equals("Wilfred")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " First Name not Updated");
        }
        if (employee.getSalary() <= 15000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " Salary Not Updated");
        }
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
        if (employee.getManagedEmployees().size() <= 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Managed Employees not Updated");
        }
        if (employee.getPhoneNumbers().size() <= 2) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " PhoneNumbers not Updated");
        }
        if (!employee.getAddress().getStreet().equals("324 Bay Street")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Address not Updated");
        }
        if (employee.getPeriod().getEndDate().getTime() > System.currentTimeMillis()) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " EndDate not Updated");
        }
        if (employee.getSalary() != 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Salary Not updated");
        }
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
        if (!((Project)((List)employee.getProjects()).get(1)).getName().equals("Feline Demographics Assesment") && !((Project)((List)employee.getProjects()).get(0)).getName().equals("Feline Demographics Assesment")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Projects not Updated");
        }
        if (!employee.getManager().getId().equals(this.empIDs[2])) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Manager not Updated");
        }
        if (employee.getSalary() <= 1000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Salary Not updated");
        }
        ((JpaEntityManager)this.getEntityManager()).getActiveSession().getIdentityMapAccessor().initializeAllIdentityMaps();
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[0]);
        if (!employee.getFirstName().equals("Wilfred")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " First Name not Updated on Database");
        }
        if (employee.getSalary() <= 15000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[0] + " Salary Not Updated on Database");
        }
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[2]);
        if (employee.getManagedEmployees().size() <= 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Managed Employees not Updated on Database");
        }
        if (employee.getPhoneNumbers().size() <= 2) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " PhoneNumbers not Updated on Database");
        }
        if (!employee.getAddress().getStreet().equals("324 Bay Street")) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Address not Updated on Database");
        }
        if (employee.getPeriod().getEndDate().getTime() > System.currentTimeMillis()) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " EndDate not Updated on Database");
        }
        if (employee.getSalary() != 0) {
            throw new TestErrorException("Employee ID :" + this.empIDs[2] + " Salary Not updated on Database");
        }
        employee = (Employee)this.getEntityManager().find(Employee.class, (Object)this.empIDs[1]);
        if (employee.getProjects().size() != 2) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Projects not Updated on Database");
        }
        if (!employee.getManager().getId().equals(this.empIDs[2])) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Manager not Updated on Database");
        }
        if (employee.getSalary() <= 1000) {
            throw new TestErrorException("Employee ID :" + this.empIDs[1] + " Salary Not updated on Database");
        }
    }
}

