/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.delimited;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.sql.Date;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.delimited.Address;
import org.eclipse.persistence.testing.models.jpa.delimited.Employee;
import org.eclipse.persistence.testing.models.jpa.delimited.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.delimited.LargeProject;
import org.eclipse.persistence.testing.models.jpa.delimited.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.delimited.Project;
import org.eclipse.persistence.testing.models.jpa.delimited.SimpleImage;
import org.eclipse.persistence.testing.models.jpa.delimited.SmallProject;
import org.eclipse.persistence.testing.models.jpa.lob.ImageSimulator;
import org.junit.Assert;

public class DelimitedPUTestSuite
extends JUnitTestCase {
    private static Employee emp = null;
    private static Address addr = null;
    private static PhoneNumber pn = null;
    private static Employee emp2 = null;
    private static LargeProject lproj = null;
    private static SmallProject sproj = null;
    private static SimpleImage simage = null;

    public DelimitedPUTestSuite() {
    }

    public DelimitedPUTestSuite(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("DelimitedPUTestSuite");
        suite.addTest((Test)new DelimitedPUTestSuite("testPopulate"));
        suite.addTest((Test)new DelimitedPUTestSuite("testReadEmployee"));
        suite.addTest((Test)new DelimitedPUTestSuite("testNativeQuery"));
        suite.addTest((Test)new DelimitedPUTestSuite("testUpdateEmployee"));
        suite.addTest((Test)new DelimitedPUTestSuite("testReadImage"));
        return suite;
    }

    public void testPopulate() {
        EntityManager em = DelimitedPUTestSuite.createEntityManager((String)"delimited");
        this.beginTransaction(em);
        DelimitedPUTestSuite.createEmployee();
        DelimitedPUTestSuite.createAddress();
        DelimitedPUTestSuite.createPhoneNumber();
        DelimitedPUTestSuite.createEmployee2();
        DelimitedPUTestSuite.createLargeProject();
        DelimitedPUTestSuite.createSmallProject();
        em.persist((Object)emp);
        em.persist((Object)addr);
        em.persist((Object)pn);
        em.persist((Object)emp2);
        em.persist((Object)lproj);
        em.persist((Object)sproj);
        em.persist((Object)DelimitedPUTestSuite.createImage());
        addr.getEmployees().add(emp);
        emp.setAddress(addr);
        emp.addPhoneNumber(pn);
        pn.setOwner(emp);
        emp.addManagedEmployee(emp2);
        emp2.setManager(emp);
        lproj.setTeamLeader(emp);
        emp.addProject((Project)lproj);
        lproj.addTeamMember(emp2);
        emp2.addProject((Project)lproj);
        sproj.setTeamLeader(emp2);
        emp2.addProject((Project)sproj);
        this.commitTransaction(em);
        DelimitedPUTestSuite.clearCache((String)"delimited");
        this.closeEntityManager(em);
    }

    public void testReadEmployee() {
        EntityManager em = DelimitedPUTestSuite.createEntityManager((String)"delimited");
        Employee returnedEmp = (Employee)em.createQuery("select e from Employee e where e.firstName = 'Del' and e.lastName = 'Imited'").getSingleResult();
        Assert.assertTrue((String)"testCreateEmployee emp not properly persisted", (boolean)DelimitedPUTestSuite.getServerSession((String)"delimited").compareObjects((Object)emp, (Object)returnedEmp));
        Employee returnedWorker = (Employee)em.createQuery("select e from Employee e where e.firstName = 'Art' and e.lastName = 'Vandeleigh'").getSingleResult();
        Assert.assertTrue((String)"testCreateEmployee emp2 not properly persisted", (boolean)DelimitedPUTestSuite.getServerSession((String)"delimited").compareObjects((Object)emp2, (Object)returnedWorker));
        this.closeEntityManager(em);
    }

    public void testNativeQuery() {
        List result;
        DelimitedPUTestSuite.clearCache((String)"delimited");
        EntityManager em = DelimitedPUTestSuite.createEntityManager((String)"delimited");
        Query query = em.createNamedQuery("findAllSQLEmployees");
        DatabasePlatform platform = DelimitedPUTestSuite.getServerSession((String)"delimited").getPlatform();
        if (platform.getStartDelimiter() != "\"") {
            query = em.createNativeQuery("select * from " + platform.getStartDelimiter() + "CMP3_DEL_EMPLOYEE" + platform.getEndDelimiter(), Employee.class);
        }
        Assert.assertTrue((String)"testNativeQuery did not return result ", ((result = query.getResultList()).size() >= 2 ? 1 : 0) != 0);
        this.closeEntityManager(em);
    }

    public void testUpdateEmployee() {
        EntityManager em = DelimitedPUTestSuite.createEntityManager((String)"delimited");
        try {
            this.beginTransaction(em);
            Employee returnedEmp = (Employee)em.createQuery("select e from Employee e where e.firstName = 'Del' and e.lastName = 'Imited'").getSingleResult();
            returnedEmp.setFirstName("Redel");
            PhoneNumber pn = new PhoneNumber();
            pn.setType("home");
            pn.setAreaCode("123");
            returnedEmp.addPhoneNumber(pn);
            returnedEmp.getAddress().setCity("Reident");
            em.flush();
            DelimitedPUTestSuite.clearCache((String)"delimited");
            returnedEmp = (Employee)em.find(Employee.class, (Object)returnedEmp.getId());
            Assert.assertTrue((String)"testUpdateEmployee did not properly update firstName", (boolean)returnedEmp.getFirstName().equals("Redel"));
            Assert.assertTrue((String)"testUpdateEmployee did not properly update address", (boolean)returnedEmp.getAddress().getCity().equals("Reident"));
            Assert.assertTrue((String)"testUpdateEmployee did not properly add phone number", (returnedEmp.getPhoneNumbers().size() == 2 ? 1 : 0) != 0);
            this.commitTransaction(em);
        }
        catch (RuntimeException e) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw e;
        }
        finally {
            this.closeEntityManager(em);
        }
    }

    public void testReadImage() {
        EntityManager em = DelimitedPUTestSuite.createEntityManager((String)"delimited");
        try {
            this.beginTransaction(em);
            SimpleImage returnedImage = (SimpleImage)em.createQuery("select e from SimpleImage e where e.id = " + simage.getId()).getSingleResult();
            em.refresh((Object)returnedImage);
            Assert.assertTrue((String)"SimpleImage was not properly read back in", (boolean)DelimitedPUTestSuite.getServerSession((String)"delimited").compareObjects((Object)simage, (Object)returnedImage));
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    private static Employee createEmployee() {
        emp = new Employee();
        emp.setFirstName("Del");
        emp.setLastName("Imited");
        emp.setFemale();
        emp.addResponsibility("Supervise projects");
        emp.addResponsibility("Delimit Identifiers");
        Date startDate = Date.valueOf("2009-06-01");
        Date endDate = Date.valueOf("2009-08-01");
        EmploymentPeriod period = new EmploymentPeriod(startDate, endDate);
        emp.setPeriod(period);
        return emp;
    }

    private static Employee createEmployee2() {
        emp2 = new Employee();
        emp2.setFirstName("Art");
        emp2.setLastName("Vandeleigh");
        emp2.setMale();
        return emp2;
    }

    private static Address createAddress() {
        addr = new Address();
        addr.setCity("Ident");
        addr.setCountry("Ifier");
        addr.setPostalCode("A0A1B1");
        addr.setProvince("Delimitia");
        addr.setStreet("Del St.");
        return addr;
    }

    private static PhoneNumber createPhoneNumber() {
        pn = new PhoneNumber();
        pn.setAreaCode("709");
        pn.setNumber("5551234");
        pn.setType("work");
        return pn;
    }

    private static LargeProject createLargeProject() {
        lproj = new LargeProject();
        lproj.setBudget(1.0E7);
        lproj.setDescription("Allow delimited identifiers in persistence.xml");
        lproj.setName("PUDefaults");
        return lproj;
    }

    private static SmallProject createSmallProject() {
        sproj = new SmallProject();
        sproj.setDescription("Allow delimited identifiers in annotations");
        sproj.setName("Annotations");
        return sproj;
    }

    private static SimpleImage createImage() {
        simage = new SimpleImage();
        simage.setPicture(ImageSimulator.initObjectByteBase((int)100));
        simage.setScript(ImageSimulator.initStringBase((int)1));
        return simage;
    }
}

