/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.inheritance;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.inheritance.AAA;
import org.eclipse.persistence.testing.models.jpa.inheritance.AbstractBus;
import org.eclipse.persistence.testing.models.jpa.inheritance.Bus;
import org.eclipse.persistence.testing.models.jpa.inheritance.Car;
import org.eclipse.persistence.testing.models.jpa.inheritance.DDD;
import org.eclipse.persistence.testing.models.jpa.inheritance.InheritanceTableCreator;
import org.eclipse.persistence.testing.models.jpa.inheritance.MacBook;
import org.eclipse.persistence.testing.models.jpa.inheritance.SportsCar;
import org.eclipse.persistence.testing.models.jpa.inheritance.listeners.BusListener;
import org.eclipse.persistence.testing.models.jpa.inheritance.listeners.BusNativeListener;
import org.eclipse.persistence.testing.models.jpa.inheritance.listeners.FueledVehicleListener;
import org.eclipse.persistence.testing.models.jpa.inheritance.listeners.ListenerSuperclass;
import org.eclipse.persistence.testing.models.jpa.inheritance.listeners.VehicleListener;
import org.eclipse.persistence.testing.models.jpa.xml.inheritance.listeners.DefaultListener;

public class LifecycleCallbackJunitTest
extends JUnitTestCase {
    private static Number m_busID;

    public LifecycleCallbackJunitTest() {
    }

    public LifecycleCallbackJunitTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("LifecycleCallbackJunitTest");
        suite.addTest((Test)new LifecycleCallbackJunitTest("testSetup"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testPrePersistBusOverrideAndAbstractInheritAndDefault"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testPostPersistBusInheritAndDefault"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testPostLoadBusInheritAndDefault"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testPrePersistSportsCarInheritAndExcludeDefault"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testPostPersistSportsCarInheritAndExcludeDefault"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testPrePersistSportsCarOverride"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testQueryInNativePreUpdateEvent"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testDefaultListenerOnMacBook"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testPostLoadFromMembersOfSet"));
        suite.addTest((Test)new LifecycleCallbackJunitTest("testSessionEventListenerOnBus"));
        return suite;
    }

    public void testSetup() {
        new InheritanceTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testPostLoadFromMembersOfSet() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            int dddPostLoadCountInitial = 0;
            int dddListenerPostLoadCountInitial = 0;
            AAA aaa = new AAA();
            DDD ddd = new DDD();
            ddd.setAaa(aaa);
            aaa.getDdds().add(ddd);
            em.persist((Object)aaa);
            String aaaId = aaa.getId();
            em.flush();
            em.refresh((Object)aaa);
            DDD refreshedDDD = (DDD)aaa.getDdds().iterator().next();
            int dddPostLoadCountRefresh = refreshedDDD.getCount();
            int dddListenerPostLoadCountRefresh = refreshedDDD.getCount2();
            LifecycleCallbackJunitTest.assertTrue((String)"The PostLoad callback method on DDD was not called after the refresh.", (dddPostLoadCountRefresh - dddPostLoadCountInitial == 1 ? 1 : 0) != 0);
            LifecycleCallbackJunitTest.assertTrue((String)"The PostLoad callback method on the DDD Listener was not called after the refresh.", (dddListenerPostLoadCountRefresh - dddListenerPostLoadCountInitial == 1 ? 1 : 0) != 0);
            this.commitTransaction(em);
            this.clearCache();
            em.clear();
            AAA findAAA = (AAA)em.find(AAA.class, (Object)aaa.getId());
            DDD findDDD = (DDD)findAAA.getDdds().iterator().next();
            int dddPostLoadCountFind = findDDD.getCount();
            int dddListenerPostLoadCountFind = findDDD.getCount2();
            LifecycleCallbackJunitTest.assertTrue((String)"The PostLoad callback method on DDD was not called afer the find.", (dddPostLoadCountFind - dddPostLoadCountRefresh == 1 ? 1 : 0) != 0);
            LifecycleCallbackJunitTest.assertTrue((String)"The PostLoad callback method on the DDD Listener was not called afer the find.", (dddListenerPostLoadCountFind - dddListenerPostLoadCountRefresh == 1 ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
    }

    public void testPostLoadBusInheritAndDefault() {
        int vehiclePostLoadCountBefore = VehicleListener.POST_LOAD_COUNT;
        int defaultListenerPostLoadCountBefore = DefaultListener.POST_LOAD_COUNT;
        Bus bus = (Bus)this.createEntityManager().find(Bus.class, (Object)m_busID);
        int vehiclePostLoadCountAfter = VehicleListener.POST_LOAD_COUNT;
        int defaultListenerPostLoadCountAfter = DefaultListener.POST_LOAD_COUNT;
        LifecycleCallbackJunitTest.assertFalse((String)"The PostLoad callback method for Vehicle was not called.", (vehiclePostLoadCountBefore == vehiclePostLoadCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PostLoad callback method for DefaultListener was not called.", (defaultListenerPostLoadCountBefore == defaultListenerPostLoadCountAfter ? 1 : 0) != 0);
    }

    public void testPostPersistBusInheritAndDefault() {
        int defaultListenerPostLoadCountIntermidiate;
        int busListenerPostPersistCountBefore = BusListener.POST_PERSIST_COUNT;
        int fueledVehiclePostPersistCountBefore = FueledVehicleListener.POST_PERSIST_COUNT;
        int defaultListenerPostPersistCountBefore = DefaultListener.POST_PERSIST_COUNT;
        int defaultListenerPostLoadCountBefore = DefaultListener.POST_LOAD_COUNT;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Bus bus = new Bus();
            bus.setPassengerCapacity(Integer.valueOf(50));
            bus.setFuelCapacity(Integer.valueOf(175));
            bus.setDescription("OC Transpo Bus");
            bus.setFuelType("Diesel");
            em.persist((Object)bus);
            em.flush();
            em.refresh((Object)bus);
            defaultListenerPostLoadCountIntermidiate = DefaultListener.POST_LOAD_COUNT;
            Query q = em.createQuery("select distinct b from Bus b where b.id = " + bus.getId());
            q.getResultList();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        int busListenerPostPersistCountAfter = BusListener.POST_PERSIST_COUNT;
        int fueledVehiclePostPersistCountAfter = FueledVehicleListener.POST_PERSIST_COUNT;
        int defaultListenerPostPersistCountAfter = DefaultListener.POST_PERSIST_COUNT;
        int defaultListenerPostLoadCountAfter = DefaultListener.POST_LOAD_COUNT;
        LifecycleCallbackJunitTest.assertFalse((String)"The PostPersist callback method on BusListener was not called.", (busListenerPostPersistCountBefore == busListenerPostPersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PostPersist callback method on FueledVehicleListener was not called.", (fueledVehiclePostPersistCountBefore == fueledVehiclePostPersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PostPersist callback method on DefaultListener was not called.", (defaultListenerPostPersistCountBefore == defaultListenerPostPersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertTrue((String)"The PostLoad callback method on DefaultListener was called more than once, possibly on the refresh.", (defaultListenerPostLoadCountIntermidiate - defaultListenerPostLoadCountBefore == 1 ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertTrue((String)"The PostLoad callback method on DefaultListener was called on the getQueryResult().", (defaultListenerPostLoadCountIntermidiate == defaultListenerPostLoadCountAfter ? 1 : 0) != 0);
    }

    public void testPostPersistSportsCarInheritAndExcludeDefault() {
        int fueledVehiclePostPersistCountBefore = FueledVehicleListener.POST_PERSIST_COUNT;
        int defaultListenerPostPersistCountBefore = DefaultListener.POST_PERSIST_COUNT;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            SportsCar sportsCar = new SportsCar();
            sportsCar.setPassengerCapacity(Integer.valueOf(4));
            sportsCar.setFuelCapacity(Integer.valueOf(55));
            sportsCar.setDescription("Porshe");
            sportsCar.setFuelType("Gas");
            em.persist((Object)sportsCar);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        int fueledVehiclePostPersistCountAfter = FueledVehicleListener.POST_PERSIST_COUNT;
        int defaultListenerPostPersistCountAfter = DefaultListener.POST_PERSIST_COUNT;
        LifecycleCallbackJunitTest.assertFalse((String)"The PostPersist callback method on FueledVehicleListener was not called.", (fueledVehiclePostPersistCountBefore == fueledVehiclePostPersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertTrue((String)"The PostPersist callback method on DefaultListener was called.", (defaultListenerPostPersistCountBefore == defaultListenerPostPersistCountAfter ? 1 : 0) != 0);
    }

    public void testPrePersistBusOverrideAndAbstractInheritAndDefault() {
        int busListenerPrePersistCountBefore = BusListener.PRE_PERSIST_COUNT;
        int busNativeListenerPreWriteCountBefore = BusNativeListener.PRE_WRITE_COUNT;
        int busNativeListenerPostWriteCountBefore = BusNativeListener.POST_WRITE_COUNT;
        int listenerSuperclassPrePersistCountBefore = ListenerSuperclass.COMMON_PRE_PERSIST_COUNT;
        int abstractBusPrePeristCountBefore = AbstractBus.PRE_PERSIST_COUNT;
        int defaultListenerPrePersistCountBefore = DefaultListener.PRE_PERSIST_COUNT;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            Bus bus = new Bus();
            bus.setPassengerCapacity(Integer.valueOf(30));
            bus.setFuelCapacity(Integer.valueOf(100));
            bus.setDescription("School Bus");
            bus.setFuelType("Diesel");
            em.persist((Object)bus);
            m_busID = bus.getId();
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.closeEntityManager(em);
        int busListenerPrePersistCountAfter = BusListener.PRE_PERSIST_COUNT;
        int busNativeListenerPreWriteCountAfter = BusNativeListener.PRE_WRITE_COUNT;
        int busNativeListenerPostWriteCountAfter = BusNativeListener.POST_WRITE_COUNT;
        int listenerSuperclassPrePersistCountAfter = ListenerSuperclass.COMMON_PRE_PERSIST_COUNT;
        int abstractBusPrePeristCountAfter = AbstractBus.PRE_PERSIST_COUNT;
        int defaultListenerPrePersistCountAfter = DefaultListener.PRE_PERSIST_COUNT;
        LifecycleCallbackJunitTest.assertFalse((String)"The PrePersist callback method on BusListener was not called.", (busListenerPrePersistCountBefore == busListenerPrePersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PreWrite (native) callback method on BusNativeListener was not called.", (busNativeListenerPreWriteCountBefore == busNativeListenerPreWriteCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PostWrite (native) callback method on BusNativeListener was not called.", (busNativeListenerPostWriteCountBefore == busNativeListenerPostWriteCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertTrue((String)"The PrePersist callback method on ListenerSuperclass was called.", (listenerSuperclassPrePersistCountBefore == listenerSuperclassPrePersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PrePersist callback method on AbstractBus was not called.", (abstractBusPrePeristCountBefore == abstractBusPrePeristCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PrePersist callback method on DefaultListener was not called.", (defaultListenerPrePersistCountBefore == defaultListenerPrePersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PrePersist callback method on DefaultListener was called more than once.", (defaultListenerPrePersistCountAfter - defaultListenerPrePersistCountBefore > 1 ? 1 : 0) != 0);
    }

    public void testPrePersistSportsCarInheritAndExcludeDefault() {
        int listenerSuperclassPrePersistCountBefore = ListenerSuperclass.COMMON_PRE_PERSIST_COUNT;
        int defaultListenerPrePersistCountBefore = DefaultListener.PRE_PERSIST_COUNT;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            SportsCar sportsCar = new SportsCar();
            sportsCar.setPassengerCapacity(Integer.valueOf(2));
            sportsCar.setFuelCapacity(Integer.valueOf(60));
            sportsCar.setDescription("Corvette");
            sportsCar.setFuelType("Gas");
            em.persist((Object)sportsCar);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.closeEntityManager(em);
        int listenerSuperclassPrePersistCountAfter = ListenerSuperclass.COMMON_PRE_PERSIST_COUNT;
        int defaultListenerPrePersistCountAfter = DefaultListener.PRE_PERSIST_COUNT;
        LifecycleCallbackJunitTest.assertFalse((String)"The PrePersist callback method on ListenerSuperclass was not called.", (listenerSuperclassPrePersistCountBefore == listenerSuperclassPrePersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertTrue((String)"The PrePersist callback method on DefaultListener was called.", (defaultListenerPrePersistCountBefore == defaultListenerPrePersistCountAfter ? 1 : 0) != 0);
    }

    public void testPrePersistSportsCarOverride() {
        int carPrePersistCountBefore = Car.PRE_PERSIST_COUNT;
        int sportsCarPrePersistCountBefore = SportsCar.PRE_PERSIST_COUNT;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            SportsCar sportsCar = new SportsCar();
            sportsCar.setPassengerCapacity(Integer.valueOf(2));
            sportsCar.setFuelCapacity(Integer.valueOf(90));
            sportsCar.setDescription("Viper");
            sportsCar.setFuelType("Gas");
            em.persist((Object)sportsCar);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.closeEntityManager(em);
        int carPrePersistCountAfter = Car.PRE_PERSIST_COUNT;
        int sportsCarPrePersistCountAfter = SportsCar.PRE_PERSIST_COUNT;
        LifecycleCallbackJunitTest.assertTrue((String)"The PrePersist callback method on Car was called.", (carPrePersistCountBefore == carPrePersistCountAfter ? 1 : 0) != 0);
        LifecycleCallbackJunitTest.assertFalse((String)"The PrePersist callback method on Sports car was not called.", (sportsCarPrePersistCountBefore == sportsCarPrePersistCountAfter ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testQueryInNativePreUpdateEvent() {
        this.clearCache();
        EntityManager em = this.createEntityManager();
        List results = em.createQuery("Select e from Bus e").getResultList();
        for (Bus bus : results) {
            bus.setDescription("QueryInNativePreUpdateEvent");
        }
        this.beginTransaction(em);
        try {
            em.flush();
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    public void testDefaultListenerOnMacBook() {
        int defaultListenerPrePersistCountBefore = DefaultListener.PRE_PERSIST_COUNT;
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        try {
            MacBook macBook = new MacBook();
            macBook.setRam(Integer.valueOf(8));
            em.persist((Object)macBook);
            this.commitTransaction(em);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
            throw ex;
        }
        this.closeEntityManager(em);
        int defaultListenerPrePersistCountAfter = DefaultListener.PRE_PERSIST_COUNT;
        LifecycleCallbackJunitTest.assertFalse((String)"The PrePersist callback method on DefaultListener was not called.", (defaultListenerPrePersistCountBefore == defaultListenerPrePersistCountAfter ? 1 : 0) != 0);
    }

    public void testSessionEventListenerOnBus() {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Bus bus = new Bus();
            bus.setDescription("Listener test Bus1");
            em.persist((Object)bus);
            this.commitTransaction(em);
            List results = em.createQuery("select object(bus) from Bus bus where bus.description = 'Listener test Bus2'").getResultList();
            LifecycleCallbackJunitTest.assertTrue((String)"Did not find the bus created by the session listener.", (results.size() == 1 ? 1 : 0) != 0);
        }
        catch (RuntimeException ex) {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            throw ex;
        }
        finally {
            this.closeEntityManager(em);
        }
    }
}

