/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.performance;

import jakarta.persistence.EntityManager;
import jakarta.persistence.spi.PersistenceProvider;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.testing.framework.ConcurrencyTestAdapter;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestModel;
import org.eclipse.persistence.testing.framework.TestProblemException;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.models.jpa.performance.Address;
import org.eclipse.persistence.testing.models.jpa.performance.Employee;
import org.eclipse.persistence.testing.models.jpa.performance.EmployeeTableCreator;
import org.eclipse.persistence.testing.models.jpa.performance.EmploymentPeriod;
import org.eclipse.persistence.testing.models.jpa.performance.LargeProject;
import org.eclipse.persistence.testing.models.jpa.performance.PhoneNumber;
import org.eclipse.persistence.testing.models.jpa.performance.SmallProject;
import org.eclipse.persistence.testing.tests.jpa.performance.concurrent.JPAAddPhoneConcurrencyComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.concurrent.JPAComplexUpdateEmployeeConcurrencyComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.concurrent.JPAUpdateAddressConcurrencyComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.concurrent.JPAUpdateEmployeeConcurrencyComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllAddressNamedQueryPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllAddressSimpleExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeCompletelyJoinedPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeCompletelyPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeComplexDynamicExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeeComplexExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllLargeProjectPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllProjectPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadAllSmallProjectPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectAddressExpressionPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectAddressNamedQueryPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectCompletelyEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.reading.JPAReadObjectGetAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertDeleteAddressPerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertDeleteEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.jpa.performance.writing.JPAInsertEmployeePerformanceComparisonTest;
import org.eclipse.persistence.testing.tests.performance.concurrent.BasicMathConcurrentTest;
import org.eclipse.persistence.testing.tests.performance.emulateddb.EmulatedDriver;

public class JPAConcurrencyComparisonModel
extends TestModel {
    public JPAConcurrencyComparisonModel() {
        this.setDescription("Performance tests that compare JPA concurrency.");
    }

    public void addTests() {
        this.addTest((Test)new BasicMathConcurrentTest());
        this.addTest((Test)this.getReadingTestSuite());
        this.addTest((Test)this.getWritingTestSuite());
    }

    public TestSuite getReadingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPAConcurrentReadingTestSuite");
        suite.setDescription("This suite tests reading concurrency.");
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllAddressPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllAddressPerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllAddressSimpleExpressionPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllAddressNamedQueryPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeePerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeePerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeeComplexExpressionPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeeComplexDynamicExpressionPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeeCompletelyPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeeCompletelyPerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeeCompletelyJoinedPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllEmployeeCompletelyJoinedPerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllProjectPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllProjectPerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllSmallProjectPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllSmallProjectPerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllLargeProjectPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadAllLargeProjectPerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadObjectAddressPerformanceComparisonTest()));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadObjectGetAddressPerformanceComparisonTest()));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadObjectAddressExpressionPerformanceComparisonTest(true)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadObjectAddressExpressionPerformanceComparisonTest(false)));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadObjectAddressNamedQueryPerformanceComparisonTest()));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadObjectEmployeePerformanceComparisonTest()));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAReadObjectCompletelyEmployeePerformanceComparisonTest()));
        return suite;
    }

    public TestSuite getWritingTestSuite() {
        TestSuite suite = new TestSuite();
        suite.setName("JPAConcurrentWritingTestSuite");
        suite.setDescription("This suite tests writing concurrency.");
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAInsertAddressPerformanceComparisonTest()));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAInsertDeleteAddressPerformanceComparisonTest()));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAInsertEmployeePerformanceComparisonTest()));
        suite.addTest((Test)new ConcurrencyTestAdapter((TestCase)new JPAInsertDeleteEmployeePerformanceComparisonTest()));
        suite.addTest((Test)new JPAUpdateAddressConcurrencyComparisonTest());
        suite.addTest((Test)new JPAUpdateEmployeeConcurrencyComparisonTest());
        suite.addTest((Test)new JPAComplexUpdateEmployeeConcurrencyComparisonTest());
        suite.addTest((Test)new JPAAddPhoneConcurrencyComparisonTest());
        return suite;
    }

    public void setup() {
        int j;
        this.setupProvider();
        this.getSession().logMessage(this.getExecutor().getEntityManagerFactory().getClass().toString());
        System.out.println(this.getExecutor().getEntityManagerFactory().getClass().toString());
        EmulatedDriver.emulate = false;
        EntityManager manager = this.getExecutor().createEntityManager();
        try {
            new EmployeeTableCreator().replaceTables((DatabaseSession)((JpaEntityManager)manager).getServerSession());
        }
        catch (ClassCastException cast) {
            new EmployeeTableCreator().replaceTables(this.getDatabaseSession());
        }
        manager.getTransaction().begin();
        for (j = 0; j < 100; ++j) {
            Employee empInsert = new Employee();
            empInsert.setFirstName("Brendan");
            empInsert.setMale();
            empInsert.setLastName("" + j + "");
            empInsert.setSalary(100000);
            EmploymentPeriod employmentPeriod = new EmploymentPeriod();
            Date startDate = Helper.dateFromString((String)"1901-12-31");
            Date endDate = Helper.dateFromString((String)"1895-01-01");
            employmentPeriod.setEndDate(startDate);
            employmentPeriod.setStartDate(endDate);
            empInsert.setPeriod(employmentPeriod);
            empInsert.setAddress(new Address());
            empInsert.getAddress().setCity("Nepean");
            empInsert.getAddress().setPostalCode("N5J2N5");
            empInsert.getAddress().setProvince("ON");
            empInsert.getAddress().setStreet("1111 Mountain Blvd. Floor 13, suite " + j);
            empInsert.getAddress().setCountry("Canada");
            empInsert.addPhoneNumber(new PhoneNumber("Work Fax", "613", "2255943"));
            empInsert.addPhoneNumber(new PhoneNumber("Home", "613", "2224599"));
            manager.persist((Object)empInsert);
        }
        for (j = 0; j < 50; ++j) {
            SmallProject project = new SmallProject();
            project.setName("Tracker");
            manager.persist((Object)project);
            project = new LargeProject();
            project.setName("Tracker");
            manager.persist((Object)project);
        }
        manager.getTransaction().commit();
        manager.close();
        EmulatedDriver.emulate = true;
    }

    public void setupProvider() {
        String providerClass = "org.eclipse.persistence.jpa.PersistenceProvider";
        PersistenceProvider provider = null;
        try {
            provider = (PersistenceProvider)Class.forName(providerClass).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception error) {
            throw new TestProblemException("Failed to create persistence provider.", (Throwable)error);
        }
        Map properties = this.getPersistenceProperties();
        this.getExecutor().setEntityManagerFactory(provider.createEntityManagerFactory("performance", properties));
    }

    public Map getPersistenceProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("eclipselink.jdbc.driver", this.getSession().getLogin().getDriverClassName());
        properties.put("eclipselink.jdbc.url", this.getSession().getLogin().getConnectionString());
        properties.put("eclipselink.jdbc.user", this.getSession().getLogin().getUserName());
        properties.put("eclipselink.jdbc.password", this.getSession().getLogin().getPassword());
        properties.put("eclipselink.jdbc.write-connections.min", "32");
        properties.put("eclipselink.jdbc.write-connections.max", "32");
        properties.put("eclipselink.jdbc.read-connections.min", "32");
        properties.put("eclipselink.jdbc.read-connections.max", "32");
        properties.put("eclipselink.jdbc.batch-writing", "JDBC");
        properties.put("eclipselink.logging.level", this.getSession().getSessionLog().getLevelString());
        properties.put("eclipselink.jdbc.cache-statements", "true");
        return properties;
    }
}

