/*
 * Copyright (c) 2011, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */

// Contributors:
//  - rbarkhouse - 21 October 2011 - 2.4 - Initial implementation
package org.eclipse.persistence.testing.jaxb.idresolver;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;

@XmlRootElement
class Orange {

    @XmlID
    @XmlAttribute
    String id;

    @XmlAttribute
    Integer orangeCode;

    @XmlElement
    String size;

    @XmlTransient
    boolean processed = false;

    @Override
    public String toString() {
        return "O(" + id + "|" + orangeCode + ")" + size + "|" + (processed ? "Ok" : "XX");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Orange)) {
            return false;
        }
        Orange a = (Orange) obj;

        if (!this.id.equals(a.id)) {
            return false;
        }
        if (!this.orangeCode.equals(a.orangeCode)) {
            return false;
        }
        if (!this.size.equals(a.size)) {
            return false;
        }
        if (this.processed != a.processed) {
            return false;
        }

        return true;
    }

}
