/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.CollectionAttribute;
import jakarta.persistence.metamodel.ListAttribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.MapAttribute;
import jakarta.persistence.metamodel.PluralAttribute;
import jakarta.persistence.metamodel.SetAttribute;
import jakarta.persistence.metamodel.SingularAttribute;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.dynamic.ValuesAccessor;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.CollectionAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EmbeddableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.EntityTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.IdentifiableTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ListAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MapAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MappedSuperclassTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SetAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.SingularAttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.TypeImpl;
import org.eclipse.persistence.internal.localization.ExceptionLocalization;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredField;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredMethod;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;

public abstract class ManagedTypeImpl<X>
extends TypeImpl<X>
implements ManagedType<X> {
    protected ClassDescriptor descriptor;
    private Map<String, Attribute<X, ?>> members;
    protected MetamodelImpl metamodel;

    protected ManagedTypeImpl(MetamodelImpl metamodel, ClassDescriptor descriptor) {
        super(descriptor.getJavaClass(), descriptor.getJavaClassName());
        this.descriptor = descriptor;
        this.metamodel = metamodel;
        metamodel.getManagedTypesMap().put(descriptor.getJavaClassName(), this);
    }

    public Attribute<X, ?> getAttribute(String name) {
        if (!this.members.containsKey(name)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return this.members.get(name);
    }

    public Set<Attribute<? super X, ?>> getAttributes() {
        return new LinkedHashSet(this.members.values());
    }

    public CollectionAttribute<? super X, ?> getCollection(String name) {
        CollectionAttribute anAttribute = (CollectionAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    public <E> CollectionAttribute<? super X, E> getCollection(String name, Class<E> elementType) {
        Attribute<X, ?> anAttribute = this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        this.verifyAttributeTypeAndReturnType(anAttribute, elementType, PluralAttribute.CollectionType.COLLECTION);
        return (CollectionAttribute)anAttribute;
    }

    public Set<PluralAttribute<? super X, ?, ?>> getPluralAttributes() {
        Set<Attribute<X, ?>> allAttributes = this.getAttributes();
        LinkedHashSet pluralAttributes = new LinkedHashSet();
        for (Attribute<X, ?> anAttribute : allAttributes) {
            if (!anAttribute.isCollection()) continue;
            pluralAttributes.add((PluralAttribute)anAttribute);
        }
        return pluralAttributes;
    }

    protected Attribute<X, ?> getDeclaredAttribute(String name, boolean attributeKnownToExistOnLeafTarget) {
        Attribute<X, ?> anAttribute = this.getAttribute(name);
        ManagedTypeImpl aManagedSuperType = this.getManagedSuperType();
        if (null == aManagedSuperType) {
            return anAttribute;
        }
        boolean isDeclaredAboveLeaf = false;
        isDeclaredAboveLeaf = attributeKnownToExistOnLeafTarget ? aManagedSuperType.isAttributeDeclaredOnlyInLeafType(name, anAttribute) : aManagedSuperType.isAttributeDeclaredOnlyInLeafType(name);
        if (attributeKnownToExistOnLeafTarget && !isDeclaredAboveLeaf || !attributeKnownToExistOnLeafTarget && isDeclaredAboveLeaf) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_declared_attribute_not_present_but_is_on_superclass", new Object[]{name, this}));
        }
        return anAttribute;
    }

    public Attribute<X, ?> getDeclaredAttribute(String name) {
        return this.getDeclaredAttribute(name, false);
    }

    public Set<Attribute<X, ?>> getDeclaredAttributes() {
        LinkedHashSet allAttributes = new LinkedHashSet(this.members.values());
        LinkedHashSet declaredAttributes = new LinkedHashSet();
        for (Attribute attribute : allAttributes) {
            if (!this.isAttributeDeclaredOnlyInLeafType(attribute.getName())) continue;
            declaredAttributes.add(attribute);
        }
        return declaredAttributes;
    }

    public CollectionAttribute<X, ?> getDeclaredCollection(String name) {
        CollectionAttribute<X, ?> anAttribute = this.getCollection(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public <E> CollectionAttribute<X, E> getDeclaredCollection(String name, Class<E> elementType) {
        CollectionAttribute<X, E> anAttribute = this.getCollection(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public Set<PluralAttribute<X, ?, ?>> getDeclaredPluralAttributes() {
        Set<PluralAttribute<X, ?, ?>> pluralAttributes = this.getPluralAttributes();
        LinkedHashSet declaredAttributes = new LinkedHashSet();
        for (PluralAttribute<X, ?, ?> anAttribute : pluralAttributes) {
            ManagedTypeImpl potentialSuperType = this.getManagedSuperType();
            if (null == potentialSuperType) {
                declaredAttributes.add(anAttribute);
                continue;
            }
            if (potentialSuperType.isAttributeDeclaredOnlyInLeafType(anAttribute.getName())) continue;
            declaredAttributes.add(anAttribute);
        }
        return declaredAttributes;
    }

    protected static ManagedTypeImpl<?> create(MetamodelImpl metamodel, ClassDescriptor descriptor) {
        IdentifiableTypeImpl managedType = metamodel.getManagedTypesMap().get(descriptor.getJavaClassName());
        if (null == managedType) {
            if (descriptor.isDescriptorForInterface()) {
                managedType = new EntityTypeImpl(metamodel, descriptor);
            } else if (descriptor.isDescriptorTypeAggregate()) {
                managedType = new EmbeddableTypeImpl(metamodel, descriptor);
            } else if (descriptor.isDescriptorTypeNormal()) {
                managedType = metamodel.hasMappedSuperclass(descriptor.getJavaClassName()) ? MappedSuperclassTypeImpl.create(metamodel, descriptor) : new EntityTypeImpl(metamodel, descriptor);
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_interface_inheritance_not_supported", new Object[]{descriptor, "Unknown"}));
            }
        }
        return managedType;
    }

    public <E> ListAttribute<X, E> getDeclaredList(String name, Class<E> elementType) {
        ListAttribute<X, E> anAttribute = this.getList(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public ListAttribute<X, ?> getDeclaredList(String name) {
        ListAttribute<X, ?> anAttribute = this.getList(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public MapAttribute<X, ?, ?> getDeclaredMap(String name) {
        MapAttribute<X, ?, ?> anAttribute = this.getMap(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public <K, V> MapAttribute<X, K, V> getDeclaredMap(String name, Class<K> keyType, Class<V> valueType) {
        MapAttribute<X, K, V> anAttribute = this.getMap(name, keyType, valueType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public SetAttribute<X, ?> getDeclaredSet(String name) {
        SetAttribute<X, ?> anAttribute = this.getSet(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public <E> SetAttribute<X, E> getDeclaredSet(String name, Class<E> elementType) {
        SetAttribute<X, E> anAttribute = this.getSet(name, elementType);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public SingularAttribute<X, ?> getDeclaredSingularAttribute(String name) {
        SingularAttribute<X, ?> anAttribute = this.getSingularAttribute(name);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public <Y> SingularAttribute<X, Y> getDeclaredSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, Y> anAttribute = this.getSingularAttribute(name, type);
        this.getDeclaredAttribute(name);
        return anAttribute;
    }

    public Set<SingularAttribute<X, ?>> getDeclaredSingularAttributes() {
        LinkedHashSet allAttributes = new LinkedHashSet(this.members.values());
        LinkedHashSet declaredAttributes = new LinkedHashSet();
        for (Attribute attribute : allAttributes) {
            if (attribute.isCollection()) continue;
            declaredAttributes.add((SingularAttribute)attribute);
        }
        return declaredAttributes;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ListAttribute<? super X, ?> getList(String name) {
        return this.getList(name, true);
    }

    private ListAttribute<? super X, ?> getList(String name, boolean performNullCheck) {
        ListAttribute anAttribute = (ListAttribute)this.members.get(name);
        if (performNullCheck && null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    private void verifyAttributeTypeAndReturnType(Attribute anAttribute, Class attributeElementType, PluralAttribute.CollectionType aReturnCollectionType) {
        if (anAttribute.isCollection()) {
            if (((PluralAttribute)anAttribute).getCollectionType().equals((Object)aReturnCollectionType)) {
                Class aBindableJavaClass = ((PluralAttribute)anAttribute).getBindableJavaType();
                if (attributeElementType != aBindableJavaClass) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{anAttribute.getName(), this, attributeElementType, aBindableJavaClass}));
                }
            } else {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_return_type_incorrect", new Object[]{anAttribute.getName(), this, aReturnCollectionType, ((PluralAttribute)anAttribute).getCollectionType()}));
            }
        }
    }

    public <E> ListAttribute<? super X, E> getList(String name, Class<E> elementType) {
        ListAttribute anAttribute = (ListAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        this.verifyAttributeTypeAndReturnType((Attribute)anAttribute, elementType, PluralAttribute.CollectionType.LIST);
        return anAttribute;
    }

    private ManagedTypeImpl getManagedSuperType() {
        ManagedTypeImpl aSuperType = null;
        Class aSuperClass = this.getJavaType().getSuperclass();
        if (null != aSuperClass && aSuperClass != ClassConstants.OBJECT && this.getMetamodel().getType(aSuperClass).isManagedType()) {
            aSuperType = (ManagedTypeImpl)this.getMetamodel().managedType(aSuperClass);
        }
        return aSuperType;
    }

    public MapAttribute<? super X, ?, ?> getMap(String name) {
        MapAttribute anAttribute = (MapAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    public <K, V> MapAttribute<? super X, K, V> getMap(String name, Class<K> keyType, Class<V> valueType) {
        MapAttribute<X, ?, ?> anAttribute = this.getMap(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (valueType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, valueType, aClass}));
        }
        return anAttribute;
    }

    protected Map<String, Attribute<X, ?>> getMembers() {
        return this.members;
    }

    protected MetamodelImpl getMetamodel() {
        return this.metamodel;
    }

    public SetAttribute<? super X, ?> getSet(String name) {
        SetAttribute anAttribute = (SetAttribute)this.members.get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return anAttribute;
    }

    public <E> SetAttribute<? super X, E> getSet(String name, Class<E> elementType) {
        SetAttribute<X, ?> anAttribute = this.getSet(name);
        Class aClass = anAttribute.getElementType().getJavaType();
        if (elementType != aClass) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, elementType, aClass.getName()}));
        }
        return anAttribute;
    }

    public SingularAttribute<? super X, ?> getSingularAttribute(String name) {
        Attribute<X, ?> anAttribute = this.getMembers().get(name);
        if (null == anAttribute) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_not_present", new Object[]{name, this}));
        }
        return (SingularAttribute)anAttribute;
    }

    private boolean isAutoboxedType(Class targetPrimitiveOrWrapperClass, Class actualPrimitiveOrWrapperClass) {
        BasicTypeHelperImpl typeHelper = BasicTypeHelperImpl.getInstance();
        if (targetPrimitiveOrWrapperClass == null || actualPrimitiveOrWrapperClass == null) {
            return false;
        }
        if (targetPrimitiveOrWrapperClass == actualPrimitiveOrWrapperClass || targetPrimitiveOrWrapperClass.getCanonicalName().equals(actualPrimitiveOrWrapperClass.getCanonicalName())) {
            return false;
        }
        if (typeHelper.isWrapperClass(targetPrimitiveOrWrapperClass) || targetPrimitiveOrWrapperClass.isPrimitive()) {
            if (typeHelper.isBooleanType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isBooleanType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isByteType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isByteType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isShortType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isShortType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isCharacterType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isCharacterType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isIntType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isIntType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isLongType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isLongType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isFloatType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isFloatType(actualPrimitiveOrWrapperClass);
            }
            if (typeHelper.isDoubleType(targetPrimitiveOrWrapperClass)) {
                return typeHelper.isDoubleType(actualPrimitiveOrWrapperClass);
            }
        }
        return false;
    }

    public <Y> SingularAttribute<? super X, Y> getSingularAttribute(String name, Class<Y> type) {
        SingularAttribute<X, ?> anAttribute = this.getSingularAttribute(name);
        Class aClass = anAttribute.getType().getJavaType();
        if (type != aClass && !this.isAutoboxedType(type, aClass)) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("metamodel_managed_type_attribute_type_incorrect", new Object[]{name, this, type, aClass}));
        }
        return anAttribute;
    }

    public Set<SingularAttribute<? super X, ?>> getSingularAttributes() {
        LinkedHashSet singularAttributeSet = new LinkedHashSet();
        for (Attribute<X, ?> anAttribute : this.members.values()) {
            if (((AttributeImpl)anAttribute).isPlural()) continue;
            singularAttributeSet.add((SingularAttribute<X, ?>)anAttribute);
        }
        return singularAttributeSet;
    }

    private boolean isAttributeDeclaredOnlyInLeafType(String attributeName) {
        return this.isAttributeDeclaredOnlyInLeafType(attributeName, this.getMembers().get(attributeName));
    }

    private boolean isAttributeDeclaredOnlyInLeafType(String attributeName, Attribute firstLevelAttribute) {
        Attribute<X, ?> anAttribute = this.getMembers().get(attributeName);
        ManagedTypeImpl aSuperType = this.getManagedSuperType();
        if (null == aSuperType) {
            if (null == anAttribute && null != firstLevelAttribute) {
                return true;
            }
            return null != anAttribute && anAttribute == firstLevelAttribute;
        }
        Attribute<X, ?> aSuperTypeAttribute = aSuperType.getMembers().get(attributeName);
        if (null != aSuperTypeAttribute) {
            return false;
        }
        return aSuperType.isAttributeDeclaredOnlyInLeafType(attributeName, firstLevelAttribute);
    }

    private AttributeImpl initializePluralAttributeTypeNotFound(ManagedTypeImpl managedType, CollectionMapping collectionMapping, boolean validation) {
        ListAttributeImpl member = new ListAttributeImpl(managedType, collectionMapping, validation);
        return member;
    }

    protected void initialize() {
        if (null != this.members) {
            return;
        }
        this.members = new HashMap();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            AttributeImpl member;
            block35: {
                member = null;
                if (mapping instanceof CollectionMapping) {
                    CollectionMapping colMapping = (CollectionMapping)mapping;
                    ContainerPolicy collectionContainerPolicy = colMapping.getContainerPolicy();
                    if (collectionContainerPolicy.isMapPolicy()) {
                        member = new MapAttributeImpl(this, colMapping, true);
                    } else if (collectionContainerPolicy.isListPolicy()) {
                        Class<?> aType = null;
                        if (colMapping.getAttributeAccessor() instanceof ValuesAccessor) {
                            member = new ListAttributeImpl(this, colMapping);
                        } else if (colMapping.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
                            MappedSuperclassTypeImpl aMappedSuperclass;
                            AttributeImpl inheritingTypeMember;
                            Field aField = ((InstanceVariableAttributeAccessor)colMapping.getAttributeAccessor()).getAttributeField();
                            if (null == aField && this.isMappedSuperclass() && null != (inheritingTypeMember = (aMappedSuperclass = (MappedSuperclassTypeImpl)this).getMemberFromInheritingType(colMapping.getAttributeName()))) {
                                aField = ((InstanceVariableAttributeAccessor)inheritingTypeMember.getMapping().getAttributeAccessor()).getAttributeField();
                            }
                            member = (aType = null == aField ? this.getTypeClassFromAttributeOrMethodLevelAccessor(mapping) : aField.getType()) != null && List.class.isAssignableFrom(aType) ? new ListAttributeImpl(this, colMapping, true) : (aType != null && Collection.class.isAssignableFrom(aType) ? new CollectionAttributeImpl(this, colMapping, true) : this.initializePluralAttributeTypeNotFound(this, colMapping, true));
                        } else if (colMapping.getAttributeAccessor() instanceof MethodAttributeAccessor) {
                            aType = colMapping.getAttributeAccessor().getAttributeClass();
                            if (aType != null && List.class.isAssignableFrom(aType)) {
                                member = new ListAttributeImpl(this, colMapping, true);
                            } else if (aType != null && Collection.class.isAssignableFrom(aType)) {
                                member = new CollectionAttributeImpl(this, colMapping, true);
                            } else {
                                String getMethodName = ((MethodAttributeAccessor)colMapping.getAttributeAccessor()).getGetMethodName();
                                if (null == getMethodName) {
                                    try {
                                        Field field = null;
                                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                                            try {
                                                field = AccessController.doPrivileged(new PrivilegedGetDeclaredField(this.getJavaType(), colMapping.getAttributeName(), false));
                                            }
                                            catch (PrivilegedActionException exception) {
                                                member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                            }
                                        } else {
                                            field = PrivilegedAccessHelper.getDeclaredField(this.getJavaType(), colMapping.getAttributeName(), false);
                                        }
                                        if (null == field) {
                                            member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                            break block35;
                                        }
                                        aType = field.getType();
                                        if (aType != null && List.class.isAssignableFrom(aType)) {
                                            member = new ListAttributeImpl(this, colMapping, true);
                                            break block35;
                                        }
                                        if (aType != null && Collection.class.isAssignableFrom(aType)) {
                                            member = new CollectionAttributeImpl(this, colMapping, true);
                                            break block35;
                                        }
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                    catch (Exception e) {
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                } else {
                                    try {
                                        Method aMethod = null;
                                        aMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(this.getJavaType(), getMethodName, null)) : PrivilegedAccessHelper.getDeclaredMethod(this.getJavaType(), getMethodName, null);
                                        if (null == aMethod) {
                                            member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                            break block35;
                                        }
                                        aType = aMethod.getReturnType();
                                        if (aType != null && List.class.isAssignableFrom(aType)) {
                                            member = new ListAttributeImpl(this, colMapping, true);
                                            break block35;
                                        }
                                        if (aType != null && Collection.class.isAssignableFrom(aType)) {
                                            member = new CollectionAttributeImpl(this, colMapping, true);
                                            break block35;
                                        }
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                    catch (Exception e) {
                                        member = this.initializePluralAttributeTypeNotFound(this, colMapping, true);
                                    }
                                }
                            }
                        }
                    } else {
                        member = collectionContainerPolicy.getContainerClass() != null && Set.class.isAssignableFrom(collectionContainerPolicy.getContainerClass()) ? new SetAttributeImpl(this, colMapping, true) : (collectionContainerPolicy.isCollectionPolicy() ? new CollectionAttributeImpl(this, colMapping, true) : new CollectionAttributeImpl(this, colMapping));
                    }
                } else {
                    member = new SingularAttributeImpl(this, mapping, true);
                }
            }
            if (null == member) {
                AbstractSessionLog.getLog().log(1, "metamodel_attribute_getmember_is_null", mapping.getAttributeName(), (Object)this, (Object)this.descriptor);
            }
            this.members.put(mapping.getAttributeName(), member);
        }
    }

    protected Class getTypeClassFromAttributeOrMethodLevelAccessor(DatabaseMapping mapping) {
        Class<?> aType = null;
        Field aField = null;
        String getMethodName = null;
        if (mapping.getAttributeAccessor() instanceof MethodAttributeAccessor) {
            getMethodName = ((MethodAttributeAccessor)mapping.getAttributeAccessor()).getGetMethodName();
        } else if (mapping.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            aField = ((InstanceVariableAttributeAccessor)mapping.getAttributeAccessor()).getAttributeField();
        }
        if (null == aField && this.getJavaType() != null) {
            try {
                aField = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetDeclaredField(this.getJavaType(), mapping.getAttributeName(), false)) : PrivilegedAccessHelper.getDeclaredField(this.getJavaType(), mapping.getAttributeName(), false);
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        if (null == aField && this.getJavaType() != null && getMethodName != null) {
            Method aMethod = null;
            try {
                aMethod = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetDeclaredMethod(this.getJavaType(), getMethodName, null)) : PrivilegedAccessHelper.getDeclaredMethod(this.getJavaType(), getMethodName, null);
            }
            catch (PrivilegedActionException privilegedActionException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (NullPointerException npe) {
                npe.printStackTrace();
            }
            if (null != aMethod) {
                aType = aMethod.getReturnType();
            }
        }
        if (null == aField && null == aType && this.isMappedSuperclass()) {
            MappedSuperclassTypeImpl aMappedSuperclass = (MappedSuperclassTypeImpl)this;
            AttributeImpl inheritingTypeMember = aMappedSuperclass.getMemberFromInheritingType(mapping.getAttributeName());
            aField = ((InstanceVariableAttributeAccessor)inheritingTypeMember.getMapping().getAttributeAccessor()).getAttributeField();
        }
        if (null != aField) {
            aType = aField.getType();
        }
        if (null == aType) {
            aType = MetamodelImpl.DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS;
        }
        if (null == this.getJavaType()) {
            AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_relationaldescriptor_javaclass_null_on_managedType", (Object)this.descriptor, (Object)this);
        }
        return aType;
    }

    @Override
    protected boolean isIdentifiableType() {
        return false;
    }

    @Override
    protected boolean isManagedType() {
        return true;
    }

    @Override
    protected void toStringHelper(StringBuffer aBuffer) {
        aBuffer.append(" descriptor: ");
        aBuffer.append(this.getDescriptor());
        if (null != this.getDescriptor()) {
            aBuffer.append(", mappings: ");
            aBuffer.append(this.getDescriptor().getMappings().size());
        }
    }
}

