/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.criteria.CommonAbstractCriteria;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Subquery;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.jpa.querydef.CriteriaBuilderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.InternalExpression;
import org.eclipse.persistence.internal.jpa.querydef.InternalSelection;
import org.eclipse.persistence.internal.jpa.querydef.OrderImpl;
import org.eclipse.persistence.internal.jpa.querydef.ParameterExpressionImpl;
import org.eclipse.persistence.internal.jpa.querydef.PredicateImpl;
import org.eclipse.persistence.internal.jpa.querydef.RootImpl;
import org.eclipse.persistence.internal.jpa.querydef.SubQueryImpl;
import org.eclipse.persistence.queries.DatabaseQuery;

public abstract class CommonAbstractCriteriaImpl<T>
implements CommonAbstractCriteria,
Serializable {
    private static final long serialVersionUID = -2729946665208116620L;
    protected Metamodel metamodel;
    protected jakarta.persistence.criteria.Expression<Boolean> where;
    protected CriteriaBuilderImpl queryBuilder;
    protected Class queryType;
    protected Set<ParameterExpression<?>> parameters;

    public CommonAbstractCriteriaImpl(Metamodel metamodel, CriteriaBuilderImpl queryBuilder, Class<T> resultType) {
        this.metamodel = metamodel;
        this.queryBuilder = queryBuilder;
        this.queryType = resultType;
    }

    public Predicate getRestriction() {
        if (this.where == null) {
            return null;
        }
        if (((ExpressionImpl)this.where).isPredicate()) {
            return (Predicate)this.where;
        }
        return this.queryBuilder.isTrue(this.where);
    }

    public Class<T> getResultType() {
        return this.queryType;
    }

    public Root internalFrom(EntityType entity) {
        RootImpl root = new RootImpl((ManagedType)entity, this.metamodel, entity.getBindableJavaType(), (Expression)new ExpressionBuilder(entity.getBindableJavaType()), (Bindable)entity);
        this.integrateRoot(root);
        return root;
    }

    public Root internalFrom(Class entityClass) {
        EntityType entity = this.metamodel.entity(entityClass);
        return this.internalFrom(entity);
    }

    public CommonAbstractCriteria where(jakarta.persistence.criteria.Expression<Boolean> restriction) {
        this.findRootAndParameters(restriction);
        this.where = restriction;
        return this;
    }

    public CommonAbstractCriteria where(Predicate ... restrictions) {
        if (restrictions == null || restrictions.length == 0) {
            this.where = null;
        }
        Predicate predicate = this.queryBuilder.and(restrictions);
        this.findRootAndParameters((jakarta.persistence.criteria.Expression<?>)predicate);
        this.where = predicate;
        return this;
    }

    public <U> Subquery<U> subquery(Class<U> type) {
        return new SubQueryImpl(this.metamodel, type, this.queryBuilder, this);
    }

    protected abstract void integrateRoot(RootImpl var1);

    protected void findRootAndParameters(jakarta.persistence.criteria.Expression<?> predicate) {
        ((InternalSelection)predicate).findRootAndParameters(this);
    }

    protected void findRootAndParameters(Order order) {
        ((OrderImpl)order).findRootAndParameters(this);
    }

    protected abstract Expression getBaseExpression();

    public void addParameter(ParameterExpression<?> parameter) {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        this.parameters.add(parameter);
    }

    protected abstract DatabaseQuery getDatabaseQuery();

    public Set<ParameterExpression<?>> getParameters() {
        if (this.parameters == null) {
            this.parameters = new HashSet();
        }
        return this.parameters;
    }

    public DatabaseQuery translate() {
        DatabaseQuery query = this.getDatabaseQuery();
        for (ParameterExpression<?> parameter : this.getParameters()) {
            query.addArgument(((ParameterExpressionImpl)parameter).getInternalName(), parameter.getJavaType());
        }
        if (this.where != null) {
            if (((InternalExpression)this.where).isJunction()) {
                if (!((PredicateImpl)this.where).getJunctionValue().booleanValue()) {
                    query.setSelectionCriteria(new ConstantExpression(1, this.getBaseExpression()).equal(0));
                }
            } else {
                query.setSelectionCriteria(((InternalSelection)this.where).getCurrentNode());
            }
        }
        return query;
    }
}

