/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ArrayRecord;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.testing.framework.TestCase;

public class ClearDatabaseSchemaTest
extends TestCase {
    public ClearDatabaseSchemaTest() {
        this.setDescription("Clears the database for MYSQL, Oracle DB, Derby, MSSQL, HSQL, Postgres.");
    }

    @Override
    public void test() {
        AbstractSession session = (AbstractSession)this.getSession();
        Platform platform = session.getDatasourcePlatform();
        if (platform.isMySQL()) {
            this.resetMySQL(session);
        } else if (platform.isOracle()) {
            this.resetOracle(session);
        } else if (platform.isDerby()) {
            this.resetDerby(session);
        } else if (platform.isSQLServer()) {
            this.resetMSSQL(session);
        } else if (platform.isHSQL()) {
            this.resetHsql(session);
        } else if (platform.isPostgreSQL()) {
            this.resetPostgres(session);
        } else {
            ClearDatabaseSchemaTest.fail((String)"Clear DB test run on unsupported DB");
        }
        this.getDatabaseSession().logout();
        this.getDatabaseSession().login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMySQL(AbstractSession session) {
        ArrayRecord record = null;
        try {
            record = (ArrayRecord)session.executeSQL("select DATABASE()").get(0);
            session.executeNonSelectingSQL("drop database " + record.get("DATABASE()"));
        }
        catch (DatabaseException x) {
            AbstractSessionLog.getLog().warning("Failed to drop database");
            x.printStackTrace(System.err);
        }
        finally {
            if (record != null) {
                session.executeNonSelectingSQL("create database " + record.get("DATABASE()"));
            } else {
                DatabaseLogin databaseLogin = (DatabaseLogin)session.getDatasourceLogin();
                String url = databaseLogin.getDatabaseURL();
                Properties properties = new Properties();
                properties.put("user", databaseLogin.getUserName());
                properties.put("password", databaseLogin.getPassword());
                int databaseNameSeparatorIndex = url.lastIndexOf(47);
                String databaseName = url.substring(databaseNameSeparatorIndex + 1);
                int propertiesIndex = databaseName.indexOf(63);
                if (propertiesIndex > 0) {
                    for (String propertyString : databaseName.substring(propertiesIndex + 1).split("&")) {
                        String[] propertyDetails = propertyString.split("=");
                        properties.put(propertyDetails[0].trim(), propertyDetails[1].trim());
                    }
                    databaseName = databaseName.substring(0, propertiesIndex);
                }
                url = url.substring(0, databaseNameSeparatorIndex);
                try (Connection connection = DriverManager.getConnection(url, properties);){
                    connection.prepareStatement("create database " + databaseName).execute();
                }
                catch (SQLException e) {
                    e.printStackTrace(System.err);
                }
            }
        }
    }

    private void resetOracle(AbstractSession session) {
        session.executeNonSelectingSQL("BEGIN FOR cur_rec IN (\nSELECT object_name, object_type FROM user_objects WHERE object_type IN ('TABLE', 'VIEW', 'PACKAGE', 'PROCEDURE', 'FUNCTION', 'SEQUENCE', 'TYPE'))\nLOOP BEGIN IF cur_rec.object_type = 'TABLE' THEN EXECUTE IMMEDIATE 'DROP ' || cur_rec.object_type || ' \"' || cur_rec.object_name || '\" CASCADE CONSTRAINTS'; ELSIF cur_rec.object_type = 'TYPE' THEN EXECUTE IMMEDIATE 'DROP ' || cur_rec.object_type || ' \"' || cur_rec.object_name || '\" FORCE'; ELSE EXECUTE IMMEDIATE 'DROP ' || cur_rec.object_type || ' \"' || cur_rec.object_name || '\"'; END IF;\nEXCEPTION WHEN OTHERS THEN DBMS_OUTPUT.put_line ('FAILED: DROP ' || cur_rec.object_type || ' \"' || cur_rec.object_name || '\"');END;\nEND LOOP; END;");
        session.executeNonSelectingSQL("PURGE user_recyclebin");
        session.executeNonSelectingSQL("PURGE recyclebin");
    }

    private void resetDerby(AbstractSession session) {
        Vector result = session.executeSQL("SELECT 'ALTER TABLE '||S.SCHEMANAME||'.'||T.TABLENAME||' DROP CONSTRAINT '||C.CONSTRAINTNAME\nFROM SYS.SYSCONSTRAINTS C, SYS.SYSSCHEMAS S, SYS.SYSTABLES T\nWHERE C.SCHEMAID = S.SCHEMAID AND C.TABLEID = T.TABLEID AND S.SCHEMANAME = CURRENT SCHEMA ORDER BY C.REFERENCECOUNT DESC");
        List<String> toRetry = this.execStatements(session, result);
        int MAX_ROUNDS = 3;
        for (int round = 0; !toRetry.isEmpty() && round < 3; ++round) {
            Iterator<String> i = toRetry.iterator();
            while (i.hasNext()) {
                String stmt = i.next();
                try {
                    session.executeNonSelectingSQL(stmt);
                    i.remove();
                }
                catch (DatabaseException databaseException) {}
            }
        }
        result = session.executeSQL("SELECT 'DROP TABLE ' || schemaname ||'.' || tablename FROM SYS.SYSTABLES\nINNER JOIN SYS.SYSSCHEMAS ON SYS.SYSTABLES.SCHEMAID = SYS.SYSSCHEMAS.SCHEMAID\nWHERE schemaname = CURRENT SCHEMA");
        toRetry.addAll(this.execStatements(session, result));
        ClearDatabaseSchemaTest.assertTrue((String)(toRetry + " statements failed"), (boolean)toRetry.isEmpty());
    }

    private void resetMSSQL(AbstractSession session) {
        session.executeNonSelectingSQL("DECLARE @name VARCHAR(256)\nDECLARE @subName VARCHAR(256)\nDECLARE @statement VARCHAR(256)\nWHILE((SELECT COUNT(1) FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE constraint_catalog=DB_NAME()) > 0)\nBEGIN\n\tSELECT TOP 1 @name=TABLE_NAME, @subName=CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE constraint_catalog=DB_NAME() ORDER BY CONSTRAINT_TYPE\n    SELECT @statement = 'ALTER TABLE [dbo].[' + RTRIM(@name) +'] DROP CONSTRAINT [' + RTRIM(@subName) +']'\n    EXEC (@statement)\nEND\nWHILE((SELECT COUNT(1) FROM sysobjects WHERE [type] IN ('P', 'V', N'FN', N'IF', N'TF', N'FS', N'FT', 'U') AND category = 0) > 0)\nBEGIN\n\tSELECT TOP 1 @name=[name], @subName=[type] FROM sysobjects WHERE [type] IN ('P', 'V', N'FN', N'IF', N'TF', N'FS', N'FT', 'U') AND category = 0\n    SELECT @statement = 'DROP ' + CASE @subName WHEN 'P' THEN 'PROCEDURE' WHEN 'V' THEN 'VIEW' WHEN 'U' THEN 'TABLE' ELSE 'FUNCTION' END + ' [dbo].[' + RTRIM(@name) +']'\n    EXEC (@statement)\nEND");
    }

    private void resetHsql(AbstractSession session) {
        Vector result = session.executeSQL("select 'DROP TABLE \"' || table_name || '\" CASCADE' FROM INFORMATION_SCHEMA.system_tables WHERE table_type = 'TABLE' and table_schem = CURRENT_SCHEMA");
        List<String> toRetry = this.execStatements(session, result);
        ClearDatabaseSchemaTest.assertTrue((String)(toRetry + " statements failed"), (boolean)toRetry.isEmpty());
    }

    private void resetPostgres(AbstractSession session) {
        Vector result = this.getSession().executeSQL("SELECT 'DROP TABLE \"' || tablename || '\" CASCADE;' FROM pg_tables WHERE schemaname = current_schema();");
        List<String> toRetry = this.execStatements(session, result);
        ClearDatabaseSchemaTest.assertTrue((String)(toRetry + " statements failed"), (boolean)toRetry.isEmpty());
    }

    private List<String> execStatements(AbstractSession session, Vector<ArrayRecord> records) {
        ArrayList<String> failures = new ArrayList<String>();
        for (ArrayRecord ar : records) {
            for (Object o : ar.values()) {
                String stmt = (String)o;
                try {
                    session.executeNonSelectingSQL(stmt);
                }
                catch (DatabaseException t) {
                    failures.add(stmt);
                }
            }
        }
        return failures;
    }
}

