/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.MapEntryExpression;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.StringHelper;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ReportQuery;

public class ConstructorReportItem
extends ReportItem {
    private static final String TO_STR_PREFIX = "ConstructorReportItem(";
    private static final String TO_STR_ARRAY = " -> [";
    private static final String TO_STR_SUFFIX = "])";
    protected Class[] constructorArgTypes;
    protected List<DatabaseMapping> constructorMappings;
    protected List<ReportItem> reportItems;
    protected Constructor constructor;

    public ConstructorReportItem() {
    }

    public ConstructorReportItem(String name) {
        super(name, null);
    }

    public void addAttribute(Expression attributeExpression) {
        ReportItem item = new ReportItem(this.getName() + this.getReportItems().size(), attributeExpression);
        this.getReportItems().add(item);
    }

    public void addAttribute(String attributeName, Expression attributeExpression, List joinedExpressions) {
        ReportItem item = new ReportItem(attributeName, attributeExpression);
        item.getJoinedAttributeManager().setJoinedAttributeExpressions_(joinedExpressions);
        this.getReportItems().add(item);
    }

    public void addItem(ReportItem item) {
        this.getReportItems().add(item);
    }

    public Class[] getConstructorArgTypes() {
        return this.constructorArgTypes;
    }

    public List<DatabaseMapping> getConstructorMappings() {
        return this.constructorMappings;
    }

    public Constructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    public List<ReportItem> getReportItems() {
        if (this.reportItems == null) {
            this.reportItems = new ArrayList<ReportItem>();
        }
        return this.reportItems;
    }

    @Override
    public void initialize(ReportQuery query) throws QueryException {
        int size = this.getReportItems().size();
        ArrayList<DatabaseMapping> mappings = new ArrayList<DatabaseMapping>();
        for (int index = 0; index < size; ++index) {
            ReportItem item = this.reportItems.get(index);
            item.initialize(query);
            mappings.add(item.getMapping());
        }
        this.setConstructorMappings(mappings);
        int numberOfItems = this.getReportItems().size();
        if (this.getConstructorArgTypes() == null) {
            this.setConstructorArgTypes(new Class[numberOfItems]);
        }
        Class[] constructorArgTypes = this.getConstructorArgTypes();
        for (int index = 0; index < numberOfItems; ++index) {
            if (constructorArgTypes[index] != null) continue;
            ReportItem argumentItem = this.getReportItems().get(index);
            if (mappings.get(index) != null) {
                DatabaseMapping mapping = this.constructorMappings.get(index);
                if (argumentItem.getAttributeExpression() != null && argumentItem.getAttributeExpression().isMapEntryExpression()) {
                    if (((MapEntryExpression)argumentItem.getAttributeExpression()).shouldReturnMapEntry()) {
                        constructorArgTypes[index] = Map.Entry.class;
                        continue;
                    }
                    constructorArgTypes[index] = (Class)mapping.getContainerPolicy().getKeyType();
                    continue;
                }
                constructorArgTypes[index] = mapping.getAttributeClassification();
                continue;
            }
            constructorArgTypes[index] = argumentItem.getResultType() != null ? argumentItem.getResultType() : (argumentItem.getDescriptor() != null ? argumentItem.getDescriptor().getJavaClass() : (argumentItem.getAttributeExpression() != null && argumentItem.getAttributeExpression().isConstantExpression() ? ((ConstantExpression)argumentItem.getAttributeExpression()).getValue().getClass() : ClassConstants.OBJECT));
        }
        if (this.getConstructor() == null) {
            try {
                Constructor constructor = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        constructor = AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getResultType(), constructorArgTypes, true));
                    }
                    catch (PrivilegedActionException exception) {
                        throw QueryException.exceptionWhileUsingConstructorExpression(exception.getException(), query);
                    }
                } else {
                    constructor = PrivilegedAccessHelper.getConstructorFor(this.getResultType(), constructorArgTypes, true);
                }
                this.setConstructor(constructor);
            }
            catch (NoSuchMethodException exception) {
                throw QueryException.exceptionWhileUsingConstructorExpression(exception, query);
            }
        }
    }

    @Override
    public boolean isConstructorItem() {
        return true;
    }

    public void setConstructorArgTypes(Class[] constructorArgTypes) {
        this.constructorArgTypes = constructorArgTypes;
    }

    public void setConstructorMappings(List<DatabaseMapping> constructorMappings) {
        this.constructorMappings = constructorMappings;
    }

    public void setReportItems(List<ReportItem> reportItems) {
        this.reportItems = reportItems;
    }

    @Override
    public String toString() {
        String name = StringHelper.nonNullString(this.getName());
        int length = TO_STR_PREFIX.length() + name.length() + TO_STR_ARRAY.length() + TO_STR_SUFFIX.length();
        int size = this.reportItems != null ? this.reportItems.size() : 0;
        String[] items = new String[size];
        for (int i = 0; i < size; ++i) {
            items[i] = StringHelper.nonNullString(this.reportItems.get(i).toString());
            length += items[i].length();
        }
        StringBuilder str = new StringBuilder(length);
        str.append(TO_STR_PREFIX).append(name).append(TO_STR_ARRAY);
        for (int i = 0; i < size; ++i) {
            str.append(items[i]);
        }
        str.append(TO_STR_SUFFIX);
        return str.toString();
    }
}

