/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.tools.model;

import java.util.Stack;
import org.eclipse.persistence.jpa.jpql.Assert;
import org.eclipse.persistence.jpa.jpql.tools.model.IScalarExpressionStateObjectBuilder;
import org.eclipse.persistence.jpa.jpql.tools.model.query.StateObject;

public abstract class AbstractStateObjectBuilder {
    private final Stack<StateObject> stateObjects = new Stack();

    protected AbstractStateObjectBuilder() {
    }

    protected void add(StateObject stateObject) {
        this.stateObjects.add(stateObject);
    }

    protected final void checkBuilder(IScalarExpressionStateObjectBuilder<?> builder) {
        Assert.isEqual(this, builder, "Both builders have to be the same");
    }

    protected final <T extends IScalarExpressionStateObjectBuilder<?>> void checkBuilders(T ... builders) {
        for (T builder : builders) {
            this.checkBuilder((IScalarExpressionStateObjectBuilder<?>)builder);
        }
    }

    protected boolean hasStateObjects() {
        return !this.stateObjects.isEmpty();
    }

    protected final StateObject pop() {
        return this.stateObjects.pop();
    }
}

