/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api;

import java.util.concurrent.atomic.AtomicLong;
import oracle.kv.impl.api.ops.ThroughputTracker;

public class AggregateThroughputTracker
implements ThroughputTracker {
    private static final int RW_BLOCK_SIZE = 1024;
    private static final int INDEX_WRITE_KB = 1;
    private final AtomicLong rKB = new AtomicLong(0L);
    private final AtomicLong wKB = new AtomicLong(0L);

    public RWKB getRWKB() {
        return new RWKB(this.rKB.get(), this.wKB.get());
    }

    @Override
    public int addReadBytes(int bytes, boolean isAbsolute) {
        int readKB = this.getReadKBToAdd(bytes, isAbsolute);
        this.rKB.getAndAdd(readKB);
        return readKB;
    }

    @Override
    public int addWriteBytes(int bytes, int nIndexWrites) {
        int writeKB = this.roundUp(bytes) + nIndexWrites * 1;
        this.wKB.getAndAdd(writeKB);
        return writeKB;
    }

    @Override
    public int getReadKBToAdd(int bytes, boolean isAbsolute) {
        return this.roundUp(bytes);
    }

    private int roundUp(int bytes) {
        int roundedKB = bytes / 1024;
        if (bytes % 1024 != 0) {
            ++roundedKB;
        }
        return roundedKB;
    }

    public void accumulate(long readKB, long writeKB) {
        this.rKB.getAndAdd(readKB);
        this.wKB.getAndAdd(writeKB);
    }

    public static class RWKB {
        private final long timeMs = System.currentTimeMillis();
        private final long readKB;
        private final long writeKB;

        private RWKB(long readKB, long writeKB) {
            this.readKB = readKB;
            this.writeKB = writeKB;
        }

        public long getTimeMs() {
            return this.timeMs;
        }

        public long getKB() {
            return this.readKB + this.writeKB;
        }

        public int getKBPerSec(RWKB base) {
            long currPeriodRWKB = this.getKB() - base.getKB();
            long periodMs = this.timeMs - base.getTimeMs();
            return periodMs > 0L ? (int)(currPeriodRWKB * 1000L / periodMs) : 0;
        }
    }
}

