/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.Durability;
import oracle.kv.Key;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.AppendOperation;
import oracle.kv.impl.api.lob.DeleteOperation;
import oracle.kv.impl.api.lob.GetOperation;
import oracle.kv.impl.api.lob.LOBMetadataKeys;
import oracle.kv.impl.api.lob.PutOperation;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.lob.InputStreamVersion;
import oracle.kv.lob.KVLargeObject;

public class KVLargeObjectImpl
implements KVLargeObject,
LOBMetadataKeys {
    private volatile KVStoreImpl kvsImpl;
    private volatile byte[] lobSuffixBytes;

    public void setKVSImpl(KVStoreImpl kvsImpl) {
        this.kvsImpl = (KVStoreImpl)KVStoreImpl.makeInternalHandle(kvsImpl);
        try {
            this.lobSuffixBytes = kvsImpl.getDefaultLOBSuffix().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void renewLoginMgr(LoginManager loginMgr) {
        this.kvsImpl.renewLoginManager(loginMgr);
    }

    public byte[] getLOBSuffixBytes() {
        return this.lobSuffixBytes;
    }

    @Override
    public Version putLOB(Key appLobKey, InputStream lobStream, Durability durability, long chunkTimeout, TimeUnit timeoutUnit) throws IOException {
        ObjectUtil.checkNull("lobStream", lobStream);
        return new PutOperation(this.kvsImpl, appLobKey, lobStream, durability, chunkTimeout, timeoutUnit).execute(false, false);
    }

    @Override
    public InputStreamVersion getLOB(Key appLobKey, Consistency consistency, long chunkTimeout, TimeUnit timeoutUnit) {
        return new GetOperation(this.kvsImpl, appLobKey, consistency, chunkTimeout, timeoutUnit).execute();
    }

    @Override
    public boolean deleteLOB(Key appLobKey, Durability durability, long timeout, TimeUnit timeoutUnit) {
        return new DeleteOperation(this.kvsImpl, appLobKey, durability, timeout, timeoutUnit).execute(false);
    }

    @Override
    public Version putLOBIfAbsent(Key appLobKey, InputStream lobStream, Durability durability, long chunkTimeout, TimeUnit timeoutUnit) throws IOException {
        ObjectUtil.checkNull("lobStream", lobStream);
        return new PutOperation(this.kvsImpl, appLobKey, lobStream, durability, chunkTimeout, timeoutUnit).execute(false, true);
    }

    @Override
    public Version putLOBIfPresent(Key appLobKey, InputStream lobStream, Durability durability, long chunkTimeout, TimeUnit timeoutUnit) throws IOException {
        ObjectUtil.checkNull("lobStream", lobStream);
        return new PutOperation(this.kvsImpl, appLobKey, lobStream, durability, chunkTimeout, timeoutUnit).execute(true, false);
    }

    @Override
    public Version appendLOB(Key lobKey, InputStream lobAppendStream, Durability durability, long lobTimeout, TimeUnit timeoutUnit) throws IOException {
        ObjectUtil.checkNull("lobAppendStream", lobAppendStream);
        return new AppendOperation(this.kvsImpl, lobKey, lobAppendStream, durability, lobTimeout, timeoutUnit).execute();
    }

    public static boolean hasLOBSuffix(byte[] keyBytes, byte[] lobSuffixBytes) {
        if (lobSuffixBytes == null) {
            return false;
        }
        int j = keyBytes.length;
        int i = lobSuffixBytes.length;
        if (j < i) {
            return false;
        }
        while (i > 0) {
            if (lobSuffixBytes[--i] == keyBytes[--j]) continue;
            return false;
        }
        return true;
    }
}

