/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.util.Stack;
import oracle.kv.Version;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.EmptyValueImpl;
import oracle.kv.impl.api.table.EnumDefImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapValueImpl;
import oracle.kv.impl.api.table.NullJsonValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.impl.api.table.TimestampDefImpl;
import oracle.kv.impl.api.table.ValueReader;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.Table;

class FieldValueReaderImpl<T extends FieldValueImpl>
implements ValueReader<FieldValueImpl> {
    private Stack<ComplexValueImpl> complexValues;
    FieldValueImpl value;

    FieldValueReaderImpl() {
        this(null);
    }

    FieldValueReaderImpl(FieldValueImpl value) {
        this.value = value;
        this.complexValues = null;
    }

    @Override
    public void readInteger(String name, int val) {
        this.setFieldValue(name, FieldDefImpl.integerDef.createInteger(val));
    }

    @Override
    public void readLong(String name, long val) {
        this.setFieldValue(name, FieldDefImpl.longDef.createLong(val));
    }

    @Override
    public void readFloat(String name, float val) {
        this.setFieldValue(name, FieldDefImpl.floatDef.createFloat(val));
    }

    @Override
    public void readDouble(String name, double val) {
        this.setFieldValue(name, FieldDefImpl.doubleDef.createDouble(val));
    }

    @Override
    public void readNumber(String name, byte[] bytes) {
        this.setFieldValue(name, FieldDefImpl.numberDef.createNumber(bytes));
    }

    @Override
    public void readTimestamp(String name, FieldDef def, byte[] bytes) {
        this.setFieldValue(name, ((TimestampDefImpl)def.asTimestamp()).createTimestamp(bytes));
    }

    @Override
    public void readBinary(String name, byte[] bytes) {
        this.setFieldValue(name, (FieldValueImpl)((Object)FieldDefImpl.binaryDef.asBinary().createBinary(bytes)));
    }

    @Override
    public void readFixedBinary(String name, FieldDef def, byte[] bytes) {
        this.setFieldValue(name, (FieldValueImpl)((Object)def.asFixedBinary().createFixedBinary(bytes)));
    }

    @Override
    public void readString(String name, String val) {
        this.setFieldValue(name, FieldDefImpl.stringDef.createString(val));
    }

    @Override
    public void readBoolean(String name, boolean val) {
        this.setFieldValue(name, FieldDefImpl.booleanDef.createBoolean(val));
    }

    @Override
    public void readNull(String name) {
        this.setFieldValue(name, NullValueImpl.getInstance());
    }

    @Override
    public void readJsonNull(String name) {
        this.setFieldValue(name, NullJsonValueImpl.getInstance());
    }

    @Override
    public void readEmpty(String name) {
        this.setFieldValue(name, EmptyValueImpl.getInstance());
    }

    @Override
    public void readEnum(String name, FieldDef def, int index) {
        EnumDefImpl enumDef = (EnumDefImpl)def.asEnum();
        this.setFieldValue(name, enumDef.createEnum(index));
    }

    @Override
    public void startRecord(String name, FieldDef def) {
        RecordValueImpl rval = (RecordValueImpl)def.asRecord().createRecord();
        this.setFieldValue(name, rval);
        this.pushComplexValue(rval);
    }

    @Override
    public void endRecord() {
        this.popComplexValue();
    }

    @Override
    public void startMap(String name, FieldDef def) {
        MapValueImpl mval = (MapValueImpl)def.asMap().createMap();
        this.setFieldValue(name, mval);
        this.pushComplexValue(mval);
    }

    @Override
    public void endMap() {
        this.popComplexValue();
    }

    @Override
    public void startArray(String name, FieldDef def, FieldDef elemDef) {
        ArrayValueImpl aval = (ArrayValueImpl)def.asArray().createArray();
        if (elemDef != null) {
            aval.setHomogeneousType((FieldDefImpl)elemDef);
        }
        this.setFieldValue(name, aval);
        this.pushComplexValue(aval);
    }

    @Override
    public void endArray() {
        this.popComplexValue();
    }

    private void setFieldValue(String name, FieldValueImpl fieldValue) {
        ComplexValueImpl curVal;
        if (this.value == null) {
            this.value = fieldValue;
            return;
        }
        if (this.complexValues == null || this.complexValues.isEmpty()) {
            if (!this.value.isComplex()) {
                throw new IllegalStateException("value should be complex type, but " + this.value.getType());
            }
            curVal = (ComplexValueImpl)this.value;
        } else {
            curVal = this.complexValues.peek();
        }
        if (curVal.isRecord()) {
            ((RecordValueImpl)curVal).putInternal(name, (FieldValue)fieldValue, false);
        } else if (curVal.isMap()) {
            curVal.asMap().put(name, fieldValue);
        } else {
            assert (curVal.isArray());
            curVal.asArray().add(fieldValue);
        }
    }

    private void pushComplexValue(ComplexValueImpl fieldValue) {
        if (this.complexValues == null) {
            this.complexValues = new Stack();
        }
        this.complexValues.push(fieldValue);
    }

    private void popComplexValue() {
        if (this.complexValues != null) {
            this.complexValues.pop();
        }
    }

    @Override
    public FieldValueImpl getValue() {
        return this.value;
    }

    @Override
    public Table getTable() {
        return null;
    }

    @Override
    public void setTableVersion(int tableVersion) {
    }

    @Override
    public void setExpirationTime(long expirationTime) {
    }

    @Override
    public void setVersion(Version version) {
    }

    @Override
    public void reset() {
        this.complexValues = null;
        this.value = null;
    }

    @Override
    public void setValue(FieldValueImpl value) {
        this.value = value;
    }
}

