/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.LongRangeValue;
import oracle.kv.impl.api.table.LongValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.util.SortableString;
import oracle.kv.table.FieldDef;
import oracle.kv.table.LongDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
public class LongDefImpl
extends FieldDefImpl
implements LongDef {
    private static final long serialVersionUID = 1L;
    private Long min;
    private Long max;
    private int encodingLength;

    LongDefImpl(String description, Long min, Long max) {
        super(FieldDef.Type.LONG, description);
        this.min = min;
        this.max = max;
        this.validate();
    }

    LongDefImpl(String description) {
        this(description, null, null);
    }

    LongDefImpl() {
        super(FieldDef.Type.LONG);
        this.min = null;
        this.max = null;
        this.encodingLength = 0;
    }

    private LongDefImpl(LongDefImpl impl) {
        super(impl);
        this.min = impl.min;
        this.max = impl.max;
        this.encodingLength = impl.encodingLength;
    }

    @Override
    public LongDefImpl clone() {
        if (this == FieldDefImpl.longDef) {
            return this;
        }
        return new LongDefImpl(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + (this.min != null ? this.min.hashCode() : 0) + (this.max != null ? this.max.hashCode() : 0);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof LongDefImpl;
    }

    @Override
    public boolean isValidKeyField() {
        return true;
    }

    @Override
    public boolean isValidIndexField() {
        return true;
    }

    @Override
    public LongDef asLong() {
        return this;
    }

    @Override
    public Long getMin() {
        return this.min;
    }

    @Override
    public Long getMax() {
        return this.max;
    }

    @Override
    int getEncodingLength() {
        return this.encodingLength;
    }

    @Override
    public boolean hasMin() {
        return this.min != null;
    }

    @Override
    public boolean hasMax() {
        return this.max != null;
    }

    @Override
    public boolean isSubtype(FieldDefImpl superType) {
        return superType.isLong() || superType.isNumber() || superType.isAny() || superType.isAnyJsonAtomic() || superType.isAnyAtomic() || superType.isJson();
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        if (this.min != null) {
            node.put("min", this.min);
        }
        if (this.max != null) {
            node.put("max", this.max);
        }
    }

    @Override
    public LongValueImpl createLong(long value) {
        return this.hasMin() || this.hasMax() ? new LongRangeValue(value, this) : new LongValueImpl(value);
    }

    @Override
    LongValueImpl createLong(String value) {
        return this.hasMin() || this.hasMax() ? new LongRangeValue(value, this) : new LongValueImpl(value);
    }

    @Override
    public short getRequiredSerialVersion() {
        return 4;
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isLong()) {
            throw new IllegalArgumentException("Default value for type LONG is not long");
        }
        return this.createLong(node.getLongValue());
    }

    private void validate() {
        if (this.min != null && this.max != null && this.min > this.max) {
            throw new IllegalArgumentException("Invalid minimum or maximum value");
        }
        this.encodingLength = SortableString.encodingLength(this.min, this.max);
    }

    void validateValue(long val) {
        if (this.min != null && val < this.min || this.max != null && val > this.max) {
            StringBuilder sb = new StringBuilder();
            sb.append("Value, ");
            sb.append(val);
            sb.append(", is outside of the allowed range");
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

