/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.async.dialog.nio;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.async.dialog.nio.NioChannelExecutor;
import oracle.kv.impl.util.KVThreadFactory;

public class NioChannelThreadPool {
    private static final AtomicInteger sequencer = new AtomicInteger(0);
    private final Logger logger;
    private final int id;
    private final AtomicReferenceArray<NioChannelExecutor> executors;
    private final AtomicInteger index = new AtomicInteger();
    private final KVThreadFactory threadFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioChannelThreadPool(Logger logger, int num) throws IOException, InterruptedException {
        if (num <= 0) {
            throw new IllegalArgumentException(String.format("Number of executors should be positive, got %d", num));
        }
        this.logger = logger;
        this.id = sequencer.incrementAndGet();
        this.executors = new AtomicReferenceArray(num);
        this.threadFactory = new KVThreadFactory(NioChannelThreadPool.class.getName(), logger);
        Thread[] threads = new Thread[num];
        for (int i = 0; i < num; ++i) {
            boolean success = false;
            try {
                Thread thread = this.createExecutor(i);
                if (thread == null) {
                    throw new IllegalStateException("Concurrent initialization of executors during thread pool construction; something is wrong");
                }
                threads[i] = thread;
                success = true;
                continue;
            }
            finally {
                if (!success) {
                    for (int j = 0; j < i; ++j) {
                        NioChannelExecutor executor = this.executors.get(j);
                        if (executor != null) {
                            executor.shutdownNow();
                        }
                        threads[j].join();
                    }
                }
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public NioChannelExecutor next() {
        return this.executors.get(Math.abs(this.index.getAndIncrement() % this.executors.length()));
    }

    public void shutdown(boolean force) {
        for (int i = 0; i < this.executors.length(); ++i) {
            NioChannelExecutor executor = this.executors.get(i);
            if (executor == null) continue;
            if (force) {
                executor.shutdownNow();
                continue;
            }
            executor.shutdown();
        }
    }

    private Thread createExecutor(int childId) throws IOException {
        NioChannelExecutor executor;
        NioChannelExecutor prev = this.executors.get(childId);
        if (prev != null) {
            prev.shutdownNow();
        }
        if (this.executors.compareAndSet(childId, prev, executor = new NioChannelExecutor(this.logger, this, childId))) {
            Thread thread = this.threadFactory.newThread(executor);
            thread.start();
            this.logger.log(Level.FINE, "New executor started: {0}", executor);
            return thread;
        }
        return null;
    }
}

