/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.ssl;

import com.sleepycat.je.rep.net.SSLAuthenticator;
import java.util.Arrays;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import oracle.kv.impl.admin.param.RMISocketPolicyBuilder;
import oracle.kv.impl.admin.param.RepNetConfigBuilder;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.security.ssl.KeyStorePasswordSource;
import oracle.kv.impl.security.ssl.SSLConfig;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.ssl.SSLServerSocketPolicy;

public class SSLTransport
implements RMISocketPolicyBuilder,
RepNetConfigBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMISocketPolicy makeSocketPolicy(SecurityParams sp, ParameterMap map) throws Exception {
        KeyStorePasswordSource pwdSrc = KeyStorePasswordSource.create(sp);
        char[] ksPwd = pwdSrc == null ? null : pwdSrc.getPassword();
        try {
            SSLConfig clientConfig = this.makeSSLConfig(sp, map, ksPwd, false);
            SSLConfig serverConfig = this.makeSSLConfig(sp, map, ksPwd, true);
            SSLServerSocketPolicy sSLServerSocketPolicy = new SSLServerSocketPolicy(serverConfig.makeSSLControl(true), clientConfig.makeSSLControl(false));
            return sSLServerSocketPolicy;
        }
        finally {
            if (ksPwd != null) {
                Arrays.fill(ksPwd, ' ');
            }
        }
    }

    public Properties getClientAccessProperties(SecurityParams sp, ParameterMap map) {
        Properties props = this.getSSLProperties(sp, map, false, false);
        if (props.getProperty("oracle.kv.ssl.keyStoreAlias") == null) {
            props.remove("oracle.kv.ssl.keyStore");
        }
        return props;
    }

    public KeyManagerFactory createKeyManagerFactory(SecurityParams sp, ParameterMap map) throws Exception {
        KeyStorePasswordSource pwdSrc = KeyStorePasswordSource.create(sp);
        char[] ksPwd = pwdSrc == null ? null : pwdSrc.getPassword();
        SSLConfig config = this.makeSSLConfig(sp, map, ksPwd, true);
        return config.makeSSLKeyManagerFactory();
    }

    public Properties makeChannelProperties(SecurityParams sp, ParameterMap map) {
        String srvrIdentAllowed;
        String clntIdentAllowed;
        String serverProtocols;
        String serverCipherSuites;
        String clientKeyAlias;
        String serverKeyAlias;
        String truststoreType;
        String truststoreFile;
        KeyStorePasswordSource pwdSrc;
        String keystoreType;
        Properties props = new Properties();
        props.setProperty("je.rep.channelType", "ssl");
        String keystoreFile = sp.getKeystoreFile();
        if (keystoreFile != null) {
            props.setProperty("je.rep.ssl.keyStoreFile", sp.resolveFile(keystoreFile).getPath());
        }
        if ((keystoreType = sp.getKeystoreType()) != null) {
            props.setProperty("je.rep.ssl.keyStoreType", keystoreType);
        }
        if ((pwdSrc = KeyStorePasswordSource.create(sp)) != null) {
            props.setProperty("je.rep.ssl.keyStorePasswordClass", pwdSrc.getClass().getName());
            props.setProperty("je.rep.ssl.keyStorePasswordParams", pwdSrc.getParamString());
        }
        if ((truststoreFile = sp.getTruststoreFile()) != null) {
            props.setProperty("je.rep.ssl.trustStoreFile", sp.resolveFile(truststoreFile).getPath());
        }
        if ((truststoreType = sp.getTruststoreType()) != null) {
            props.setProperty("je.rep.ssl.trustStoreType", truststoreType);
        }
        if ((serverKeyAlias = sp.getTransServerKeyAlias(map)) != null) {
            props.setProperty("je.rep.ssl.serverKeyAlias", serverKeyAlias);
        }
        if ((clientKeyAlias = sp.getTransClientKeyAlias(map)) != null) {
            props.setProperty("je.rep.ssl.clientKeyAlias", clientKeyAlias);
        }
        if ((serverCipherSuites = sp.getTransAllowCipherSuites(map)) != null) {
            props.setProperty("je.rep.ssl.cipherSuites", serverCipherSuites);
        }
        if ((serverProtocols = sp.getTransAllowProtocols(map)) != null) {
            props.setProperty("je.rep.ssl.protocols", serverProtocols);
        }
        if ((clntIdentAllowed = sp.getTransClientIdentityAllowed(map)) != null) {
            SSLConfig.InstanceInfo<SSLAuthenticator> authInstInfo = SSLConfig.makeAuthenticatorInfo(clntIdentAllowed);
            props.setProperty("je.rep.ssl.authenticatorClass", authInstInfo.jeImplClass);
            props.setProperty("je.rep.ssl.authenticatorParams", authInstInfo.jeImplParams);
        }
        if ((srvrIdentAllowed = sp.getTransServerIdentityAllowed(map)) != null) {
            SSLConfig.InstanceInfo<HostnameVerifier> verifierInstInfo = SSLConfig.makeHostVerifierInfo(srvrIdentAllowed);
            props.setProperty("je.rep.ssl.hostVerifierClass", verifierInstInfo.jeImplClass);
            props.setProperty("je.rep.ssl.hostVerifierParams", verifierInstInfo.jeImplParams);
        }
        return props;
    }

    SSLConfig makeSSLConfig(SecurityParams sp, ParameterMap map, char[] ksPwd, boolean isServer) {
        Properties props = this.getSSLProperties(sp, map, true, isServer);
        SSLConfig cfg = new SSLConfig(props);
        cfg.setKeystorePassword(ksPwd);
        return cfg;
    }

    Properties getSSLProperties(SecurityParams sp, ParameterMap map, boolean resolveFiles, boolean isServer) {
        String alias;
        String tsFile;
        String ksFile;
        String allowProtocols;
        Properties props = new Properties();
        String allowCipherSuites = sp.getTransAllowCipherSuites(map);
        if (allowCipherSuites != null) {
            props.setProperty("oracle.kv.ssl.ciphersuites", allowCipherSuites);
        }
        if ((allowProtocols = sp.getTransAllowProtocols(map)) != null) {
            props.setProperty("oracle.kv.ssl.protocols", allowProtocols);
        }
        if (!isServer) {
            String clientAllowProtocols;
            String clientAllowCipherSuites = sp.getTransClientAllowCipherSuites(map);
            if (clientAllowCipherSuites != null) {
                props.setProperty("oracle.kv.ssl.ciphersuites", clientAllowCipherSuites);
            }
            if ((clientAllowProtocols = sp.getTransClientAllowProtocols(map)) != null) {
                props.setProperty("oracle.kv.ssl.protocols", clientAllowProtocols);
            }
        }
        if ((ksFile = sp.getKeystoreFile()) != null) {
            props.setProperty("oracle.kv.ssl.keyStore", resolveFiles ? sp.resolveFile(ksFile).getPath() : ksFile);
            String ksType = sp.getKeystoreType();
            if (ksType != null) {
                props.setProperty("oracle.kv.ssl.keyStoreType", ksType);
            }
        }
        if ((tsFile = sp.getTruststoreFile()) != null) {
            props.setProperty("oracle.kv.ssl.trustStore", resolveFiles ? sp.resolveFile(tsFile).getPath() : tsFile);
            String tsType = sp.getTruststoreType();
            if (tsType != null) {
                props.setProperty("oracle.kv.ssl.trustStoreType", tsType);
            }
        }
        if (isServer) {
            String clientIdentityAllowed;
            alias = sp.getTransServerKeyAlias(map);
            if (alias != null) {
                props.setProperty("oracle.kv.ssl.keyStoreAlias", alias);
            }
            if ((clientIdentityAllowed = sp.getTransClientIdentityAllowed(map)) != null) {
                props.setProperty("oracle.kv.ssl.clientAuthenticator", clientIdentityAllowed);
            }
        } else {
            String serverIdentityAllowed;
            alias = sp.getTransClientKeyAlias(map);
            if (alias != null) {
                props.setProperty("oracle.kv.ssl.keyStoreAlias", alias);
            }
            if ((serverIdentityAllowed = sp.getTransServerIdentityAllowed(map)) != null) {
                props.setProperty("oracle.kv.ssl.hostnameVerifier", serverIdentityAllowed);
            }
        }
        return props;
    }
}

