/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util.registry;

import java.rmi.RemoteException;
import oracle.kv.impl.util.SerialVersion;
import oracle.kv.impl.util.registry.VersionedRemote;

public abstract class RemoteAPI {
    private final short serialVersion;
    private final VersionedRemote remote;

    protected RemoteAPI(VersionedRemote remote) throws RemoteException {
        short serverVersion = remote.getSerialVersion();
        if (serverVersion < SerialVersion.MINIMUM) {
            throw SerialVersion.serverUnsupportedException(serverVersion, SerialVersion.MINIMUM);
        }
        this.serialVersion = (short)Math.min(SerialVersion.CURRENT, serverVersion);
        this.remote = remote;
    }

    public short getSerialVersion() {
        return this.serialVersion;
    }

    public int hashCode() {
        return this.remote.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RemoteAPI)) {
            return false;
        }
        RemoteAPI o = (RemoteAPI)other;
        return this.remote.equals(o.remote);
    }
}

