/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.fetchgroups;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.testing.models.jpa.advanced.Employee;
import org.eclipse.persistence.testing.models.jpa.advanced.PhoneNumber;
import org.eclipse.persistence.testing.tests.jpa.fetchgroups.BaseFetchGroupTests;

public class SimpleNamedFetchGroupTests
extends BaseFetchGroupTests {
    public SimpleNamedFetchGroupTests() {
    }

    public SimpleNamedFetchGroupTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("SimpleNamedFetchGroupTests");
        suite.addTest((Test)new SimpleNamedFetchGroupTests("testSetup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("findDefaultFetchGroup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("singleResultDefaultFetchGroup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("resultListDefaultFetchGroup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("singleResultNoFetchGroup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("resultListNoFetchGroup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("managerFetchGroup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("namedEmptyFetchGroupUsingGetSingleResult"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("namedNamesFetchGroupUsingGetSingleResult"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("joinFetchEmployeeAddressWithDynamicFetchGroup"));
        suite.addTest((Test)new SimpleNamedFetchGroupTests("joinFetchEmployeeAddressPhoneWithDynamicFetchGroup"));
        return suite;
    }

    @Override
    public void setUp() {
        super.setUp();
        FetchGroup namedEmpFG = new FetchGroup("Employee.test");
        namedEmpFG.addAttribute("firstName");
        namedEmpFG.addAttribute("lastName");
        this.employeeDescriptor.getFetchGroupManager().addFetchGroup(namedEmpFG);
        FetchGroup namedPhoneFG = new FetchGroup("Phone.test");
        namedPhoneFG.addAttribute("number");
        this.phoneDescriptor.getFetchGroupManager().addFetchGroup(namedPhoneFG);
        FetchGroup namedAddressFG = new FetchGroup("Address.test");
        namedAddressFG.addAttribute("city");
        this.addressDescriptor.getFetchGroupManager().addFetchGroup(namedAddressFG);
        this.assertConfig(this.employeeDescriptor, null, 1);
        this.assertConfig(this.phoneDescriptor, null, 1);
        this.assertConfig(this.addressDescriptor, null, 1);
    }

    @org.junit.Test
    public void findDefaultFetchGroup() throws Exception {
        EntityManager em = this.createEntityManager();
        Employee emp = SimpleNamedFetchGroupTests.minimumEmployee(em);
        SimpleNamedFetchGroupTests.assertNotNull((Object)emp);
        SimpleNamedFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp);
        emp.getSalary();
        SimpleNamedFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp.getAddress());
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        for (PhoneNumber phone : emp.getPhoneNumbers()) {
            this.assertNoFetchGroup(phone);
        }
        int nSqlExpected = 3;
        if (SimpleNamedFetchGroupTests.usesSOP()) {
            --nSqlExpected;
        }
        SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        if (emp.getManager() != null) {
            this.assertNoFetchGroup(emp.getManager());
            SimpleNamedFetchGroupTests.assertEquals((int)(++nSqlExpected), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        } else {
            SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
    }

    @org.junit.Test
    public void singleResultDefaultFetchGroup() throws Exception {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleNamedFetchGroupTests.minimumEmployeeId(em));
        Employee emp = (Employee)query.getSingleResult();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emp);
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp);
        emp.getSalary();
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp.getAddress());
        SimpleNamedFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        for (PhoneNumber phone : emp.getPhoneNumbers()) {
            this.assertNoFetchGroup(phone);
        }
        int nSqlExpected = 4;
        if (SimpleNamedFetchGroupTests.usesSOP()) {
            --nSqlExpected;
        }
        SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        if (emp.getManager() != null) {
            this.assertNoFetchGroup(emp.getManager());
            SimpleNamedFetchGroupTests.assertEquals((int)(++nSqlExpected), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        } else {
            SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
    }

    @org.junit.Test
    public void resultListDefaultFetchGroup() throws Exception {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleNamedFetchGroupTests.minimumEmployeeId(em));
        List emps = query.getResultList();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emps);
        SimpleNamedFetchGroupTests.assertEquals((int)1, (int)emps.size());
        Employee emp = (Employee)emps.get(0);
        SimpleNamedFetchGroupTests.assertNotNull((Object)emp);
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp);
        emp.getSalary();
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp.getAddress());
        SimpleNamedFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        for (PhoneNumber phone : emp.getPhoneNumbers()) {
            this.assertNoFetchGroup(phone);
        }
        int nSqlExpected = 4;
        if (SimpleNamedFetchGroupTests.usesSOP()) {
            --nSqlExpected;
        }
        SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        if (emp.getManager() != null) {
            this.assertNoFetchGroup(emp.getManager());
            SimpleNamedFetchGroupTests.assertEquals((int)(++nSqlExpected), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        } else {
            SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
    }

    @org.junit.Test
    public void singleResultNoFetchGroup() throws Exception {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleNamedFetchGroupTests.minimumEmployeeId(em));
        Employee emp = (Employee)query.getSingleResult();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emp);
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp);
        emp.getSalary();
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp.getAddress());
        SimpleNamedFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        for (PhoneNumber phone : emp.getPhoneNumbers()) {
            this.assertNoFetchGroup(phone);
        }
        int nSqlExpected = 4;
        if (SimpleNamedFetchGroupTests.usesSOP()) {
            --nSqlExpected;
        }
        SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        if (emp.getManager() != null) {
            this.assertNoFetchGroup(emp.getManager());
            SimpleNamedFetchGroupTests.assertEquals((int)(++nSqlExpected), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        } else {
            SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
    }

    @org.junit.Test
    public void resultListNoFetchGroup() throws Exception {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleNamedFetchGroupTests.minimumEmployeeId(em));
        List emps = query.getResultList();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emps);
        SimpleNamedFetchGroupTests.assertEquals((int)1, (int)emps.size());
        Employee emp = (Employee)emps.get(0);
        SimpleNamedFetchGroupTests.assertNotNull((Object)emp);
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp);
        emp.getSalary();
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        this.assertNoFetchGroup(emp.getAddress());
        SimpleNamedFetchGroupTests.assertEquals((int)3, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        for (PhoneNumber phone : emp.getPhoneNumbers()) {
            this.assertNoFetchGroup(phone);
        }
        int nSqlExpected = 4;
        if (SimpleNamedFetchGroupTests.usesSOP()) {
            --nSqlExpected;
        }
        SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        if (emp.getManager() != null) {
            this.assertNoFetchGroup(emp.getManager());
            SimpleNamedFetchGroupTests.assertEquals((int)(++nSqlExpected), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        } else {
            SimpleNamedFetchGroupTests.assertEquals((int)nSqlExpected, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @org.junit.Test
    public void managerFetchGroup() throws Exception {
        EntityManager em = this.createEntityManager();
        try {
            this.beginTransaction(em);
            Query query = em.createQuery("SELECT e FROM Employee e WHERE e.manager IS NOT NULL AND NOT EXISTS(SELECT e2 FROM Employee e2 WHERE e2.manager = e) AND e.manager.department IS NULL");
            FetchGroup managerFG = new FetchGroup();
            managerFG.addAttribute("manager");
            query.setHint("eclipselink.fetch-group", (Object)managerFG);
            SimpleNamedFetchGroupTests.assertNotNull((Object)this.getFetchGroup(query));
            SimpleNamedFetchGroupTests.assertSame((Object)managerFG, (Object)this.getFetchGroup(query));
            Employee emp = (Employee)query.getSingleResult();
            this.assertFetched((Object)emp, managerFG);
            SimpleNamedFetchGroupTests.assertEquals((int)1, (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            int nSqlToAdd = 0;
            if (emp.getManager() != null) {
                this.assertFetchedAttribute(emp, "manager");
                ++nSqlToAdd;
            }
            SimpleNamedFetchGroupTests.assertEquals((int)(1 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            emp.getLastName();
            SimpleNamedFetchGroupTests.assertEquals((int)(2 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
            this.assertNoFetchGroup(emp);
            for (PhoneNumber phone : emp.getPhoneNumbers()) {
                this.assertNoFetchGroup(phone);
            }
            SimpleNamedFetchGroupTests.assertEquals((int)(3 + nSqlToAdd), (int)this.getQuerySQLTracker(em).getTotalSQLSELECTCalls());
        }
        finally {
            if (this.isTransactionActive(em)) {
                this.rollbackTransaction(em);
            }
            this.closeEntityManager(em);
        }
    }

    @org.junit.Test
    public void namedEmptyFetchGroupUsingGetSingleResult() throws Exception {
        ClassDescriptor descriptor = this.getDescriptor("Employee");
        FetchGroup fetchGroup = new FetchGroup("test");
        descriptor.getFetchGroupManager().addFetchGroup(fetchGroup);
        SimpleNamedFetchGroupTests.assertTrue((boolean)fetchGroup.getItems().isEmpty());
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)descriptor.getFetchGroupManager().getFetchGroups().size());
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleNamedFetchGroupTests.minimumEmployeeId(em));
        query.setHint("eclipselink.fetch-group.name", (Object)"test");
        Employee emp = (Employee)query.getSingleResult();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emp);
        FetchGroupTracker tracker = (FetchGroupTracker)emp;
        SimpleNamedFetchGroupTests.assertNotNull((Object)tracker);
        FetchGroup usedFG = tracker._persistence_getFetchGroup();
        SimpleNamedFetchGroupTests.assertNotNull((String)"No FetchGroup found on read Employee", (Object)usedFG);
        SimpleNamedFetchGroupTests.assertTrue((boolean)fetchGroup.getAttributeNames().equals(usedFG.getAttributeNames()));
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)fetchGroup.getItems().size());
        SimpleNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
        SimpleNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
        SimpleNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
        SimpleNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("firstName"));
        SimpleNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("lastName"));
    }

    @org.junit.Test
    public void namedNamesFetchGroupUsingGetSingleResult() throws Exception {
        ClassDescriptor descriptor = this.getDescriptor("Employee");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        descriptor.getFetchGroupManager().addFetchGroup(fetchGroup);
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)fetchGroup.getItems().size());
        SimpleNamedFetchGroupTests.assertEquals((int)2, (int)descriptor.getFetchGroupManager().getFetchGroups().size());
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e WHERE e.id = :ID");
        query.setParameter("ID", (Object)SimpleNamedFetchGroupTests.minimumEmployeeId(em));
        query.setHint("eclipselink.fetch-group.name", (Object)"names");
        Employee emp = (Employee)query.getSingleResult();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emp);
        FetchGroupTracker tracker = (FetchGroupTracker)emp;
        SimpleNamedFetchGroupTests.assertNotNull((Object)tracker);
        FetchGroup usedFG = tracker._persistence_getFetchGroup();
        SimpleNamedFetchGroupTests.assertNotNull((String)"No FetcGroup found on read Employee", (Object)fetchGroup);
        SimpleNamedFetchGroupTests.assertEquals((int)4, (int)fetchGroup.getItems().size());
        SimpleNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("id"));
        SimpleNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("version"));
        SimpleNamedFetchGroupTests.assertFalse((boolean)tracker._persistence_isAttributeFetched("salary"));
        SimpleNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("firstName"));
        SimpleNamedFetchGroupTests.assertTrue((boolean)tracker._persistence_isAttributeFetched("lastName"));
    }

    @Override
    @org.junit.Test
    public void joinFetchEmployeeAddressWithDynamicFetchGroup() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emps);
    }

    @Override
    @org.junit.Test
    public void joinFetchEmployeeAddressPhoneWithDynamicFetchGroup() {
        EntityManager em = this.createEntityManager();
        Query query = em.createQuery("SELECT e FROM Employee e JOIN FETCH e.address WHERE e.id IN (SELECT p.id FROM PhoneNumber p)");
        FetchGroup fetchGroup = new FetchGroup("names");
        fetchGroup.addAttribute("firstName");
        fetchGroup.addAttribute("lastName");
        query.setHint("eclipselink.fetch-group", (Object)fetchGroup);
        List emps = query.getResultList();
        SimpleNamedFetchGroupTests.assertNotNull((Object)emps);
    }
}

