/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.jpa.privateowned;

import jakarta.persistence.EntityManager;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.server.ServerSession;
import org.eclipse.persistence.testing.framework.QuerySQLTracker;
import org.eclipse.persistence.testing.framework.junit.JUnitTestCase;
import org.eclipse.persistence.testing.models.jpa.privateowned.Chassis;
import org.eclipse.persistence.testing.models.jpa.privateowned.Engine;
import org.eclipse.persistence.testing.models.jpa.privateowned.Mount;
import org.eclipse.persistence.testing.models.jpa.privateowned.MountPK;
import org.eclipse.persistence.testing.models.jpa.privateowned.PrivateOwnedModelTableCreator;
import org.eclipse.persistence.testing.models.jpa.privateowned.SparkPlug;
import org.eclipse.persistence.testing.models.jpa.privateowned.SpecificVehicle;
import org.eclipse.persistence.testing.models.jpa.privateowned.Tire;
import org.eclipse.persistence.testing.models.jpa.privateowned.Vehicle;
import org.eclipse.persistence.testing.models.jpa.privateowned.Wheel;
import org.eclipse.persistence.testing.models.jpa.privateowned.WheelNut;
import org.eclipse.persistence.testing.models.jpa.privateowned.WheelRim;

public class PrivateOwnedJUnitTestCase
extends JUnitTestCase {
    public PrivateOwnedJUnitTestCase(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Private Owned Suite");
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testSetup"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToManyPrivateOwnedRemoval"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToManyPrivateOwnedRemovalWithInheritance"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToManyPrivateOwnedRemovalWithCascade"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToManyPrivateOwnedRemovalWithCascadeFromPO"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToOnePrivateOwnedRemovalWithCascade"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToOnePrivateOwnedRemovalWithCascadeFromPO"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testEmbeddedWithCascadeFromPO"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToOnePrivateOwnedFromExistingObject"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToManyPrivateOwnedExistingObjectModification"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testPrivateOwnedOneToOneChangeFromExistingObject"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToOnePrivateOwnedRemovalWithCascadeUsingClassic"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToManyPrivateOwnedRemovalUsingClassic"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testEmbeddedWithCascadeFromPOUsingClassic"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testOneToOnePrivateOwnedFromExistingObjectUsingClassic"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testPrivateOwnedCycleWithOneToMany"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testDeleteAll"));
        suite.addTest((Test)new PrivateOwnedJUnitTestCase("testDeleteObjectOneByOne"));
        return suite;
    }

    public void testSetup() {
        new PrivateOwnedModelTableCreator().replaceTables((DatabaseSession)JUnitTestCase.getServerSession());
        this.clearCache();
    }

    public void testOneToManyPrivateOwnedExistingObjectModification() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis1 = new Chassis(1L);
        vehicle.setChassis(chassis1);
        chassis1.addWheel(new Wheel(1L));
        chassis1.addWheel(new Wheel(2L));
        em.persist((Object)vehicle);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleRead);
        Chassis chassis = vehicleRead.getChassis();
        for (Wheel wheel : chassis.getWheels()) {
            wheel.setSerialNumber(wheel.getSerialNumber() + 10L);
        }
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicleReadAgain = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleReadAgain);
        for (Wheel wheel : vehicleReadAgain.getChassis().getWheels()) {
            PrivateOwnedJUnitTestCase.assertTrue((String)"All wheels should have a S/N > 10 after modification", (wheel.getSerialNumber() > 10L ? 1 : 0) != 0);
        }
        em.remove((Object)vehicleReadAgain);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToOnePrivateOwnedFromExistingObject() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis1 = new Chassis(1L);
        vehicle.setChassis(chassis1);
        em.persist((Object)vehicle);
        this.commitTransaction(em);
        this.beginTransaction(em);
        Vehicle vehicleToModify = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        vehicleToModify.setModel("GT-X2");
        em.persist((Object)vehicleToModify);
        Chassis chassis2 = new Chassis(2L);
        vehicleToModify.setChassis(chassis2);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleRead);
        Chassis chassis1Read = (Chassis)em.find(Chassis.class, (Object)chassis1.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Chassis1 should have been removed", (Object)chassis1Read);
        Chassis chassis2Read = (Chassis)em.find(Chassis.class, (Object)chassis2.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis2 should have been inserted", (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis2", (Object)vehicleRead.getChassis(), (Object)chassis2Read);
        em.remove((Object)vehicleRead);
        em.remove((Object)chassis2Read);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testEmbeddedWithCascadeFromPO() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis1 = new Chassis(1L);
        vehicle.setChassis(chassis1);
        Wheel wheel1 = new Wheel(1L);
        chassis1.addWheel(wheel1);
        Tire tire1 = new Tire();
        tire1.setManufacturer("ACME");
        tire1.setType("Radial");
        wheel1.setTire(tire1);
        em.persist((Object)vehicle);
        Chassis chassis2 = new Chassis(2L);
        vehicle.setChassis(chassis2);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleRead);
        Chassis chassis1Read = (Chassis)em.find(Chassis.class, (Object)chassis1.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Chassis 1 should not have been inserted", (Object)chassis1Read);
        Chassis chassis2Read = (Chassis)em.find(Chassis.class, (Object)chassis2.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis 2 should have been inserted", (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis2", (Object)vehicleRead.getChassis(), (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertEquals((String)"Chassis 2 should not reference any wheels", (int)0, (int)chassis2Read.getWheels().size());
        Wheel wheel1Read = (Wheel)em.find(Wheel.class, (Object)wheel1.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel 1 should not have been inserted", (Object)wheel1Read);
        em.remove((Object)vehicleRead);
        em.remove((Object)chassis2Read);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToManyPrivateOwnedRemovalWithCascadeFromPO() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis = new Chassis(1L);
        vehicle.setChassis(chassis);
        Wheel wheel1 = new Wheel(1L);
        chassis.addWheel(wheel1);
        WheelNut wheelNut1 = new WheelNut();
        WheelNut wheelNut2 = new WheelNut();
        WheelNut wheelNut3 = new WheelNut();
        WheelNut wheelNut4 = new WheelNut();
        wheel1.addWheelNut(wheelNut1);
        wheel1.addWheelNut(wheelNut2);
        wheel1.addWheelNut(wheelNut3);
        wheel1.addWheelNut(wheelNut4);
        em.persist((Object)vehicle);
        WheelNut wheelNut5 = new WheelNut();
        WheelNut wheelNut6 = new WheelNut();
        wheel1.removeWheelNut(wheelNut3);
        wheel1.removeWheelNut(wheelNut4);
        wheel1.addWheelNut(wheelNut5);
        wheel1.addWheelNut(wheelNut6);
        Wheel wheel2 = new Wheel(2L);
        chassis.addWheel(wheel2);
        em.persist((Object)vehicle);
        wheel2.addWheelNut(wheelNut3);
        wheel2.addWheelNut(wheelNut4);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        WheelNut wheelNut3Read = (WheelNut)em.find(WheelNut.class, (Object)wheelNut3.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"WheelNut3 should have been inserted", (Object)wheelNut3Read);
        WheelNut wheelNut4Read = (WheelNut)em.find(WheelNut.class, (Object)wheelNut4.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"WheelNut4 should have been inserted", (Object)wheelNut4Read);
        Wheel wheel1Read = (Wheel)em.find(Wheel.class, (Object)wheel1.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Wheel1 should have been inserted", (Object)wheel1Read);
        PrivateOwnedJUnitTestCase.assertEquals((String)"Wheel1 should reference 4 WheelNuts", (int)4, (int)wheel1Read.getWheelNuts().size());
        PrivateOwnedJUnitTestCase.assertFalse((String)"Wheel1 should not reference wheelNut3", (boolean)wheel1Read.getWheelNuts().contains(wheelNut3Read));
        PrivateOwnedJUnitTestCase.assertFalse((String)"Wheel1 should not reference wheelNut4", (boolean)wheel1Read.getWheelNuts().contains(wheelNut4Read));
        Wheel wheel2Read = (Wheel)em.find(Wheel.class, (Object)wheel2.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Wheel2 should have been inserted", (Object)wheel2Read);
        PrivateOwnedJUnitTestCase.assertEquals((String)"Wheel2 should reference 2 wheelnuts", (int)2, (int)wheel2Read.getWheelNuts().size());
        PrivateOwnedJUnitTestCase.assertTrue((String)"Wheel2 should reference wheelNut3", (boolean)wheel2Read.getWheelNuts().contains(wheelNut3Read));
        PrivateOwnedJUnitTestCase.assertTrue((String)"Wheel2 should reference wheelNut4", (boolean)wheel2Read.getWheelNuts().contains(wheelNut4Read));
        em.remove(em.find(Vehicle.class, (Object)vehicle.getId()));
        for (WheelNut nut : wheel1Read.getWheelNuts()) {
            em.remove((Object)nut);
        }
        for (WheelNut nut : wheel2Read.getWheelNuts()) {
            em.remove((Object)nut);
        }
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToOnePrivateOwnedRemovalWithCascadeFromPO() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis = new Chassis(1L);
        vehicle.setChassis(chassis);
        Wheel wheel1 = new Wheel(1L);
        WheelRim wheelRim1 = new WheelRim();
        wheel1.setWheelRim(wheelRim1);
        chassis.addWheel(wheel1);
        Wheel wheel2 = new Wheel(2L);
        WheelRim wheelRim2 = new WheelRim();
        wheel2.setWheelRim(wheelRim2);
        chassis.addWheel(wheel2);
        Wheel wheel3 = new Wheel(3L);
        WheelRim wheelRim3 = new WheelRim();
        wheel3.setWheelRim(wheelRim3);
        chassis.addWheel(wheel3);
        Wheel wheel4 = new Wheel(4L);
        WheelRim wheelRim4 = new WheelRim();
        wheel4.setWheelRim(wheelRim4);
        chassis.addWheel(wheel4);
        em.persist((Object)vehicle);
        vehicle.setChassis(null);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Object wheel1Read = em.find(Wheel.class, (Object)wheel1.getId());
        Object wheel2Read = em.find(Wheel.class, (Object)wheel2.getId());
        Object wheel3Read = em.find(Wheel.class, (Object)wheel3.getId());
        Object wheel4Read = em.find(Wheel.class, (Object)wheel4.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel1 should not be inserted", (Object)wheel1Read);
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel2 should not be inserted", (Object)wheel2Read);
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel3 should not be inserted", (Object)wheel3Read);
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel4 should not be inserted", (Object)wheel4Read);
        Object wheelRim1Read = em.find(WheelRim.class, (Object)wheelRim1.getId());
        Object wheelRim2Read = em.find(WheelRim.class, (Object)wheelRim2.getId());
        Object wheelRim3Read = em.find(WheelRim.class, (Object)wheelRim3.getId());
        Object wheelRim4Read = em.find(WheelRim.class, (Object)wheelRim4.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"WheelRim1 should be inserted", (Object)wheelRim1Read);
        PrivateOwnedJUnitTestCase.assertNotNull((String)"WheelRim2 should be inserted", (Object)wheelRim2Read);
        PrivateOwnedJUnitTestCase.assertNotNull((String)"WheelRim3 should be inserted", (Object)wheelRim3Read);
        PrivateOwnedJUnitTestCase.assertNotNull((String)"WheelRim4 should be inserted", (Object)wheelRim4Read);
        Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should be inserted", (Object)vehicleRead);
        Chassis chassisRead = (Chassis)em.find(Chassis.class, (Object)chassis.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Chassis should not be inserted", (Object)chassisRead);
        PrivateOwnedJUnitTestCase.assertNull((String)"Vehicle should not reference Chassis", (Object)vehicleRead.getChassis());
        em.remove((Object)vehicleRead);
        em.remove(wheelRim1Read);
        em.remove(wheelRim2Read);
        em.remove(wheelRim3Read);
        em.remove(wheelRim4Read);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToManyPrivateOwnedRemovalWithCascade() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Engine engine = new Engine(123456789L);
        SparkPlug plug1 = new SparkPlug(1L);
        SparkPlug plug2 = new SparkPlug(2L);
        SparkPlug plug3 = new SparkPlug(3L);
        SparkPlug plug4 = new SparkPlug(4L);
        SparkPlug plug5 = new SparkPlug(5L);
        SparkPlug plug6 = new SparkPlug(6L);
        vehicle.setEngine(engine);
        engine.addSparkPlug(plug1);
        engine.addSparkPlug(plug2);
        engine.addSparkPlug(plug3);
        engine.addSparkPlug(plug4);
        engine.addSparkPlug(plug5);
        engine.addSparkPlug(plug6);
        em.persist((Object)vehicle);
        engine.removeSparkPlug(plug3);
        engine.removeSparkPlug(plug5);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        SparkPlug sparkPlug3Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug3.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"SparkPlug3 should not be inserted", (Object)sparkPlug3Read);
        SparkPlug sparkPlug5Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug5.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"SparkPlug5 should not be inserted", (Object)sparkPlug5Read);
        Engine engineRead = (Engine)em.find(Engine.class, (Object)engine.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Engine should be inserted", (Object)engineRead);
        PrivateOwnedJUnitTestCase.assertEquals((String)"Engine should contain 4 spark plugs", (int)4, (int)engineRead.getSparkPlugs().size());
        PrivateOwnedJUnitTestCase.assertFalse((String)"Engine should not contain SparkPlug3", (boolean)engine.getSparkPlugs().contains(sparkPlug3Read));
        PrivateOwnedJUnitTestCase.assertFalse((String)"Engine should not contain SparkPlug5", (boolean)engine.getSparkPlugs().contains(sparkPlug5Read));
        SparkPlug sparkPlug1Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug1.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)sparkPlug1Read);
        SparkPlug sparkPlug2Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug2.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)sparkPlug2Read);
        SparkPlug sparkPlug4Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug4.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)sparkPlug4Read);
        SparkPlug sparkPlug6Read = (SparkPlug)em.find(SparkPlug.class, (Object)plug6.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)sparkPlug6Read);
        PrivateOwnedJUnitTestCase.assertEquals((int)4, (int)engineRead.getSparkPlugs().size());
        PrivateOwnedJUnitTestCase.assertTrue((String)"Engine should contain SparkPlug1", (boolean)engineRead.getSparkPlugs().contains(sparkPlug1Read));
        PrivateOwnedJUnitTestCase.assertTrue((String)"Engine should contain SparkPlug2", (boolean)engineRead.getSparkPlugs().contains(sparkPlug2Read));
        PrivateOwnedJUnitTestCase.assertTrue((String)"Engine should contain SparkPlug4", (boolean)engineRead.getSparkPlugs().contains(sparkPlug4Read));
        PrivateOwnedJUnitTestCase.assertTrue((String)"Engine should contain SparkPlug6", (boolean)engineRead.getSparkPlugs().contains(sparkPlug6Read));
        em.remove(em.find(Vehicle.class, (Object)vehicle.getId()));
        em.remove((Object)engineRead);
        em.remove((Object)sparkPlug1Read);
        em.remove((Object)sparkPlug2Read);
        em.remove((Object)sparkPlug4Read);
        em.remove((Object)sparkPlug6Read);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToOnePrivateOwnedRemovalWithCascade() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis1 = new Chassis(1L);
        vehicle.setChassis(chassis1);
        em.persist((Object)vehicle);
        Chassis chassis2 = new Chassis(2L);
        vehicle.setChassis(chassis2);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should be inserted", (Object)vehicleRead);
        Chassis chassis1Read = (Chassis)em.find(Chassis.class, (Object)chassis1.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Chassis1 should not be inserted", (Object)chassis1Read);
        Chassis chassis2Read = (Chassis)em.find(Chassis.class, (Object)chassis2.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis2 should be inserted", (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis2", (Object)chassis2Read, (Object)vehicleRead.getChassis());
        em.remove((Object)vehicleRead);
        em.remove((Object)chassis2Read);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToManyPrivateOwnedRemoval() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis = new Chassis(1L);
        vehicle.setChassis(chassis);
        Wheel wheel1 = new Wheel(1L);
        Wheel wheel2 = new Wheel(2L);
        Wheel wheel3 = new Wheel(3L);
        Wheel wheel4 = new Wheel(4L);
        Wheel wheel5 = new Wheel(5L);
        chassis.addWheel(wheel1);
        chassis.addWheel(wheel2);
        chassis.addWheel(wheel3);
        chassis.addWheel(wheel4);
        chassis.addWheel(wheel5);
        em.persist((Object)vehicle);
        chassis.removeWheel(wheel5);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should be inserted", (Object)vehicleRead);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)vehicleRead.getChassis());
        Chassis chassisRead = (Chassis)em.find(Chassis.class, (Object)chassis.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis should be inserted", (Object)chassisRead);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis", (Object)chassisRead, (Object)vehicleRead.getChassis());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)chassisRead.getWheels());
        PrivateOwnedJUnitTestCase.assertEquals((int)4, (int)chassisRead.getWheels().size());
        Wheel wheel1Read = (Wheel)em.find(Wheel.class, (Object)wheel1.getId());
        Wheel wheel2Read = (Wheel)em.find(Wheel.class, (Object)wheel2.getId());
        Wheel wheel3Read = (Wheel)em.find(Wheel.class, (Object)wheel3.getId());
        Wheel wheel4Read = (Wheel)em.find(Wheel.class, (Object)wheel4.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel1Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel2Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel3Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel4Read);
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel1Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel2Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel3Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel4Read));
        Wheel wheel5Read = (Wheel)em.find(Wheel.class, (Object)wheel5.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel5 should not be inserted", (Object)wheel5Read);
        PrivateOwnedJUnitTestCase.assertFalse((String)"Chassis should not reference Wheel5", (boolean)chassisRead.getWheels().contains(wheel5Read));
        em.remove((Object)vehicleRead);
        em.remove((Object)chassisRead);
        em.remove((Object)wheel1Read);
        em.remove((Object)wheel2Read);
        em.remove((Object)wheel3Read);
        em.remove((Object)wheel4Read);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToManyPrivateOwnedRemovalWithInheritance() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        SpecificVehicle vehicle = new SpecificVehicle("GT-X");
        Chassis chassis = new Chassis(1L);
        vehicle.setChassis(chassis);
        Wheel wheel1 = new Wheel(1L);
        Wheel wheel2 = new Wheel(2L);
        Wheel wheel3 = new Wheel(3L);
        Wheel wheel4 = new Wheel(4L);
        Wheel wheel5 = new Wheel(5L);
        chassis.addWheel(wheel1);
        chassis.addWheel(wheel2);
        chassis.addWheel(wheel3);
        chassis.addWheel(wheel4);
        chassis.addWheel(wheel5);
        em.persist((Object)vehicle);
        chassis.removeWheel(wheel5);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        this.beginTransaction(em);
        SpecificVehicle vehicleRead = (SpecificVehicle)em.find(SpecificVehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should be inserted", (Object)vehicleRead);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)vehicleRead.getChassis());
        Chassis chassisRead = (Chassis)em.find(Chassis.class, (Object)chassis.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis should be inserted", (Object)chassisRead);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis", (Object)chassisRead, (Object)vehicleRead.getChassis());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)chassisRead.getWheels());
        PrivateOwnedJUnitTestCase.assertEquals((int)4, (int)chassisRead.getWheels().size());
        Wheel wheel1Read = (Wheel)em.find(Wheel.class, (Object)wheel1.getId());
        Wheel wheel2Read = (Wheel)em.find(Wheel.class, (Object)wheel2.getId());
        Wheel wheel3Read = (Wheel)em.find(Wheel.class, (Object)wheel3.getId());
        Wheel wheel4Read = (Wheel)em.find(Wheel.class, (Object)wheel4.getId());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel1Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel2Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel3Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel4Read);
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel1Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel2Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel3Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel4Read));
        Wheel wheel5Read = (Wheel)em.find(Wheel.class, (Object)wheel5.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel5 should not be inserted", (Object)wheel5Read);
        PrivateOwnedJUnitTestCase.assertFalse((String)"Chassis should not reference Wheel5", (boolean)chassisRead.getWheels().contains(wheel5Read));
        em.remove((Object)vehicleRead);
        em.remove((Object)chassisRead);
        em.remove((Object)wheel1Read);
        em.remove((Object)wheel2Read);
        em.remove((Object)wheel3Read);
        em.remove((Object)wheel4Read);
        this.commitTransaction(em);
        this.closeEntityManager(em);
    }

    public void testOneToOnePrivateOwnedRemovalWithCascadeUsingClassic() {
        ServerSession serverSession = PrivateOwnedJUnitTestCase.getServerSession();
        UnitOfWorkImpl uow = serverSession.acquireUnitOfWork();
        Vehicle vehicle = new Vehicle("GT-X Mk2");
        Chassis chassis1 = new Chassis(11L);
        vehicle.setChassis(chassis1);
        Vehicle vehicleClone = (Vehicle)uow.registerObject((Object)vehicle);
        Chassis chassis2 = new Chassis(22L);
        vehicleClone.setChassis(chassis2);
        uow.commit();
        serverSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = serverSession.acquireUnitOfWork();
        Vehicle vehicleRead = (Vehicle)uow.readObject(Vehicle.class, new ExpressionBuilder().get("id").equal(vehicle.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should be inserted", (Object)vehicleRead);
        Chassis chassis1Read = (Chassis)uow.readObject(Chassis.class, new ExpressionBuilder().get("id").equal(chassis1.getId()));
        PrivateOwnedJUnitTestCase.assertNull((String)"Chassis1 should not be inserted", (Object)chassis1Read);
        Chassis chassis2Read = (Chassis)uow.readObject(Chassis.class, new ExpressionBuilder().get("id").equal(chassis2.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis2 should be inserted", (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis2", (Object)chassis2Read, (Object)vehicleRead.getChassis());
        uow.deleteObject((Object)vehicleRead);
        uow.deleteObject((Object)chassis2Read);
        uow.commit();
    }

    public void testOneToManyPrivateOwnedRemovalUsingClassic() {
        ServerSession serverSession = PrivateOwnedJUnitTestCase.getServerSession();
        UnitOfWorkImpl uow = serverSession.acquireUnitOfWork();
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis = new Chassis(1L);
        vehicle.setChassis(chassis);
        Wheel wheel1 = new Wheel(1L);
        Wheel wheel2 = new Wheel(2L);
        Wheel wheel3 = new Wheel(3L);
        Wheel wheel4 = new Wheel(4L);
        Wheel wheel5 = new Wheel(5L);
        chassis.addWheel(wheel1);
        chassis.addWheel(wheel2);
        chassis.addWheel(wheel3);
        chassis.addWheel(wheel4);
        chassis.addWheel(wheel5);
        Vehicle vehicleClone = (Vehicle)uow.registerObject((Object)vehicle);
        Wheel theFifthWheel = null;
        for (Wheel wheel : vehicleClone.getChassis().getWheels()) {
            if (wheel.getSerialNumber() != wheel5.getSerialNumber()) continue;
            theFifthWheel = wheel;
        }
        PrivateOwnedJUnitTestCase.assertNotNull(theFifthWheel);
        vehicleClone.getChassis().removeWheel(theFifthWheel);
        PrivateOwnedJUnitTestCase.assertEquals((int)4, (int)vehicleClone.getChassis().getWheels().size());
        uow.commit();
        serverSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = serverSession.acquireUnitOfWork();
        Vehicle vehicleRead = (Vehicle)uow.readObject(Vehicle.class, new ExpressionBuilder().get("id").equal(vehicle.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should be inserted", (Object)vehicleRead);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)vehicleRead.getChassis());
        Chassis chassisRead = (Chassis)uow.readObject(Chassis.class, new ExpressionBuilder().get("id").equal(chassis.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis should be inserted", (Object)chassisRead);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis", (Object)chassisRead, (Object)vehicleRead.getChassis());
        PrivateOwnedJUnitTestCase.assertNotNull((Object)chassisRead.getWheels());
        Wheel wheel5Read = (Wheel)uow.readObject(Wheel.class, new ExpressionBuilder().get("id").equal(wheel5.getId()));
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel5 should not be inserted", (Object)wheel5Read);
        PrivateOwnedJUnitTestCase.assertFalse((String)"Chassis should not reference Wheel5", (boolean)chassisRead.getWheels().contains(wheel5Read));
        PrivateOwnedJUnitTestCase.assertEquals((int)4, (int)chassisRead.getWheels().size());
        Wheel wheel1Read = (Wheel)uow.readObject(Wheel.class, new ExpressionBuilder().get("id").equal(wheel1.getId()));
        Wheel wheel2Read = (Wheel)uow.readObject(Wheel.class, new ExpressionBuilder().get("id").equal(wheel2.getId()));
        Wheel wheel3Read = (Wheel)uow.readObject(Wheel.class, new ExpressionBuilder().get("id").equal(wheel3.getId()));
        Wheel wheel4Read = (Wheel)uow.readObject(Wheel.class, new ExpressionBuilder().get("id").equal(wheel4.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel1Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel2Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel3Read);
        PrivateOwnedJUnitTestCase.assertNotNull((Object)wheel4Read);
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel1Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel2Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel3Read));
        PrivateOwnedJUnitTestCase.assertTrue((boolean)chassisRead.getWheels().contains(wheel4Read));
        uow.deleteObject((Object)vehicleRead);
        uow.deleteObject((Object)chassisRead);
        uow.deleteAllObjects((Collection)chassisRead.getWheels());
        uow.commit();
    }

    public void testEmbeddedWithCascadeFromPOUsingClassic() {
        ServerSession serverSession = PrivateOwnedJUnitTestCase.getServerSession();
        UnitOfWorkImpl uow = serverSession.acquireUnitOfWork();
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis1 = new Chassis(1L);
        vehicle.setChassis(chassis1);
        Wheel wheel1 = new Wheel(1L);
        chassis1.addWheel(wheel1);
        Tire tire1 = new Tire();
        tire1.setManufacturer("ACME");
        tire1.setType("Radial");
        wheel1.setTire(tire1);
        Vehicle vehicleClone = (Vehicle)uow.registerObject((Object)vehicle);
        Chassis chassis2 = new Chassis(2L);
        vehicleClone.setChassis(chassis2);
        uow.commit();
        serverSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        uow = serverSession.acquireUnitOfWork();
        Vehicle vehicleRead = (Vehicle)uow.readObject(Vehicle.class, new ExpressionBuilder().get("id").equal(vehicle.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleRead);
        Chassis chassis1Read = (Chassis)uow.readObject(Chassis.class, new ExpressionBuilder().get("id").equal(chassis1.getId()));
        PrivateOwnedJUnitTestCase.assertNull((String)"Chassis 1 should not have been inserted", (Object)chassis1Read);
        Chassis chassis2Read = (Chassis)uow.readObject(Chassis.class, new ExpressionBuilder().get("id").equal(chassis2.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis 2 should have been inserted", (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis2", (Object)vehicleRead.getChassis(), (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertEquals((String)"Chassis 2 should not reference any wheels", (int)0, (int)chassis2Read.getWheels().size());
        Wheel wheel1Read = (Wheel)uow.readObject(Wheel.class, new ExpressionBuilder().get("id").equal(wheel1.getId()));
        PrivateOwnedJUnitTestCase.assertNull((String)"Wheel 1 should not have been inserted", (Object)wheel1Read);
        uow.deleteObject((Object)vehicleRead);
        uow.deleteObject((Object)chassis2Read);
        uow.commit();
    }

    public void testOneToOnePrivateOwnedFromExistingObjectUsingClassic() {
        ServerSession serverSession = PrivateOwnedJUnitTestCase.getServerSession();
        UnitOfWorkImpl uow = serverSession.acquireUnitOfWork();
        Vehicle vehicle = new Vehicle("GT-X");
        Chassis chassis1 = new Chassis(1L);
        vehicle.setChassis(chassis1);
        uow.registerObject((Object)vehicle);
        uow.commit();
        uow = serverSession.acquireUnitOfWork();
        Vehicle vehicleToModify = (Vehicle)uow.readObject(Vehicle.class, new ExpressionBuilder().get("id").equal(vehicle.getId()));
        vehicleToModify.setModel("GT-X2");
        Chassis chassis2 = new Chassis(2L);
        vehicleToModify.setChassis(chassis2);
        uow.commit();
        serverSession.getIdentityMapAccessor().initializeAllIdentityMaps();
        this.clearCache();
        uow = serverSession.acquireUnitOfWork();
        Vehicle vehicleRead = (Vehicle)uow.readObject(Vehicle.class, new ExpressionBuilder().get("id").equal(vehicle.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleRead);
        Chassis chassis1Read = (Chassis)uow.readObject(Chassis.class, new ExpressionBuilder().get("id").equal(chassis1.getId()));
        PrivateOwnedJUnitTestCase.assertNull((String)"Chassis1 should have been removed", (Object)chassis1Read);
        Chassis chassis2Read = (Chassis)uow.readObject(Chassis.class, new ExpressionBuilder().get("id").equal(chassis2.getId()));
        PrivateOwnedJUnitTestCase.assertNotNull((String)"Chassis2 should have been inserted", (Object)chassis2Read);
        PrivateOwnedJUnitTestCase.assertSame((String)"Vehicle should reference Chassis2", (Object)vehicleRead.getChassis(), (Object)chassis2Read);
        uow.deleteObject((Object)vehicleRead);
        uow.deleteObject((Object)chassis2Read);
        uow.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrivateOwnedOneToOneChangeFromExistingObject() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle("GT-X7");
        Chassis chassis = new Chassis(1234567L);
        vehicle.setChassis(chassis);
        em.persist((Object)vehicle);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicleRead = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        long newSerialNumber = 7654321L;
        vehicleRead.getChassis().setSerialNumber(newSerialNumber);
        em.persist((Object)vehicleRead);
        this.commitTransaction(em);
        this.closeEntityManager(em);
        this.clearCache();
        em = this.createEntityManager();
        Vehicle vehicleReadAgain = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        try {
            PrivateOwnedJUnitTestCase.assertNotNull((String)"Vehicle should have been inserted", (Object)vehicleReadAgain);
            long serialNumberFromDatabase = vehicleReadAgain.getChassis().getSerialNumber();
            PrivateOwnedJUnitTestCase.assertEquals((String)"Chassis serial number should have been changed on the DB", (long)newSerialNumber, (long)serialNumberFromDatabase);
        }
        finally {
            this.beginTransaction(em);
            vehicleReadAgain = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
            em.remove((Object)vehicleReadAgain.getChassis());
            em.remove((Object)vehicleReadAgain);
            this.commitTransaction(em);
            this.closeEntityManager(em);
        }
    }

    public void testPrivateOwnedCycleWithOneToMany() {
        EntityManager em = this.createEntityManager();
        this.beginTransaction(em);
        Vehicle vehicle = new Vehicle();
        Chassis chassis = new Chassis();
        Mount mount = new Mount();
        vehicle.setChassis(chassis);
        chassis.addMount(mount);
        mount.setVehicle(vehicle);
        em.persist((Object)vehicle);
        em.flush();
        this.clearCache();
        em.clear();
        MountPK pk = new MountPK(mount.getId(), chassis.getId());
        vehicle = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        em.remove((Object)vehicle);
        em.flush();
        this.clearCache();
        em.clear();
        vehicle = (Vehicle)em.find(Vehicle.class, (Object)vehicle.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"vehicle was not deleted.", (Object)vehicle);
        chassis = (Chassis)em.find(Chassis.class, (Object)chassis.getId());
        PrivateOwnedJUnitTestCase.assertNull((String)"chassis was not deleted.", (Object)chassis);
        mount = (Mount)em.find(Mount.class, (Object)pk);
        PrivateOwnedJUnitTestCase.assertNull((String)"mount was not deleted.", (Object)mount);
        this.rollbackTransaction(em);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteAll() {
        EntityManager em = this.createEntityManager();
        QuerySQLTracker counter = new QuerySQLTracker((Session)PrivateOwnedJUnitTestCase.getServerSession());
        this.beginTransaction(em);
        Chassis chassis = new Chassis();
        Wheel wheel = new Wheel();
        chassis.addWheel(wheel);
        wheel = new Wheel();
        chassis.addWheel(wheel);
        em.persist((Object)chassis);
        em.flush();
        em.clear();
        this.clearCache();
        chassis = (Chassis)em.find(Chassis.class, (Object)chassis.getId());
        em.remove((Object)chassis);
        counter.getQueries().clear();
        counter.getSqlStatements().clear();
        em.flush();
        try {
            PrivateOwnedJUnitTestCase.assertTrue((String)"An incorrect number of SQL statements were issued.", (counter.getSqlStatements().size() == 2 ? 1 : 0) != 0);
        }
        finally {
            counter.remove();
            this.rollbackTransaction(em);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteObjectOneByOne() {
        EntityManager em = this.createEntityManager();
        CollectionMapping mapping = (CollectionMapping)PrivateOwnedJUnitTestCase.getServerSession().getDescriptor(Engine.class).getMappingForAttributeName("sparkPlugs");
        boolean deleteOneByOne = mapping.mustDeleteReferenceObjectsOneByOne();
        mapping.setMustDeleteReferenceObjectsOneByOne(Boolean.valueOf(true));
        try {
            this.beginTransaction(em);
            Engine eng = new Engine();
            eng.setSerialNumber(2222L);
            em.persist((Object)eng);
            SparkPlug plug = new SparkPlug();
            plug.setSerialNumber(1111L);
            eng.addSparkPlug(plug);
            em.persist((Object)plug);
            em.flush();
            plug = new SparkPlug();
            plug.setSerialNumber(3333L);
            eng.addSparkPlug(plug);
            em.remove((Object)eng);
            this.commitTransaction(em);
        }
        finally {
            mapping.setMustDeleteReferenceObjectsOneByOne(Boolean.valueOf(deleteOneByOne));
        }
    }
}

