/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.weaving;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.TableGenerator;
import jakarta.persistence.Version;
import java.io.Serializable;
import java.util.Collection;
import org.eclipse.persistence.testing.models.weaving.Order;

@Entity
@Table(name="CMP3_CUSTOMER")
@NamedQuery(name="findAllCustomers", query="SELECT OBJECT(thecust) FROM Customer thecust")
public class Customer
implements Serializable {
    private Integer customerId;
    private int version;
    private String city;
    private String name;
    private Collection<Order> orders;

    @Id
    @GeneratedValue(strategy=GenerationType.TABLE, generator="CUSTOMER_TABLE_GENERATOR")
    @TableGenerator(name="CUSTOMER_TABLE_GENERATOR", table="CMP3_CUSTOMER_SEQ", pkColumnName="SEQ_NAME", valueColumnName="SEQ_COUNT", pkColumnValue="CUST_SEQ")
    @Column(name="CUST_ID")
    public Integer getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Integer id) {
        this.customerId = id;
    }

    @Version
    @Column(name="CUST_VERSION")
    public int getVersion() {
        return this.version;
    }

    protected void setVersion(int version) {
        this.version = version;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String aCity) {
        this.city = aCity;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="customer")
    public Collection<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(Collection<Order> newValue) {
        this.orders = newValue;
    }

    public void addOrder(Order anOrder) {
        this.getOrders().add(anOrder);
        anOrder.setCustomer(this);
    }

    public void removeOrder(Order anOrder) {
        this.getOrders().remove(anOrder);
    }
}

