/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.models.mapping;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.internal.identitymaps.FullIdentityMap;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.SerializedObjectConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.testing.models.mapping.Address;
import org.eclipse.persistence.testing.models.mapping.CompanyCard;
import org.eclipse.persistence.testing.models.mapping.Computer;
import org.eclipse.persistence.testing.models.mapping.Cubicle;
import org.eclipse.persistence.testing.models.mapping.EmergencyExit;
import org.eclipse.persistence.testing.models.mapping.Employee;
import org.eclipse.persistence.testing.models.mapping.Hardware;
import org.eclipse.persistence.testing.models.mapping.Identification;
import org.eclipse.persistence.testing.models.mapping.Monitor;
import org.eclipse.persistence.testing.models.mapping.Peripheral;
import org.eclipse.persistence.testing.models.mapping.Phone;
import org.eclipse.persistence.testing.models.mapping.SecureSystem;
import org.eclipse.persistence.testing.models.mapping.Shipment;

public class MappingProject
extends Project {
    public MappingProject() {
        this.setName("ComplexMappingSystem");
        this.buildAddressDescriptor();
        this.buildCompanyCardDescriptor();
        this.buildComputerDescriptor();
        this.buildCubicleDescriptor();
        this.buildEmergencyExitDescriptor();
        this.buildEmployeeDescriptor();
        this.buildHardwareDescriptor();
        this.buildMonitorDescriptor();
        this.buildPhoneDescriptor();
        this.buildShipmentDescriptor();
        this.buildSecureSystemDescriptor();
        this.buildIdentificationDescriptor();
        this.buildPeripheralDescriptor();
    }

    protected void buildAddressDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Address.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_ADD");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_ADD.A_ID");
        descriptor.setSequenceNumberName("SEQ_ID");
        descriptor.setSequenceNumberFieldName("A_ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.useWeakIdentityMap();
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_ADD.A_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("location");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_ADD.LOCATION");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addTargetForeignKeyFieldName("MAP_EMP.A_ID", "MAP_ADD.A_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        TransformationMapping transformationmapping = new TransformationMapping();
        transformationmapping.setAttributeName("province");
        transformationmapping.setIsReadOnly(false);
        transformationmapping.setUsesIndirection(false);
        transformationmapping.setAttributeTransformation("getProvinceFromRow");
        transformationmapping.addFieldTransformation("MAP_ADD.PROVINCE", "getProvinceFromObject");
        descriptor.addMapping((DatabaseMapping)transformationmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildCompanyCardDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(CompanyCard.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_CARD");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_CARD.COM_ID");
        descriptor.setIdentityMapClass(FullIdentityMap.class);
        descriptor.setExistenceChecking("Check cache");
        descriptor.setIdentityMapSize(100);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("number");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_CARD.CARDNUMBER");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("limit");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("MAP_CARD.AMOUNT_LIMIT");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToOneMapping oneToOneMapping = new OneToOneMapping();
        oneToOneMapping.setReferenceClass(Address.class);
        oneToOneMapping.setAttributeName("owner");
        oneToOneMapping.setIsReadOnly(false);
        oneToOneMapping.addForeignKeyFieldName("MAP_CARD.COM_ID", "MAP_ADD.A_ID");
        oneToOneMapping.dontUseIndirection();
        descriptor.addMapping((DatabaseMapping)oneToOneMapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildComputerDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Computer.class);
        descriptor.getInheritancePolicy().setParentClass(Hardware.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_COM");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_COM.ID");
        descriptor.getInheritancePolicy().setShouldReadSubclasses(false);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("static method");
        descriptor.getInstantiationPolicy().setMethodName("createNew");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("description");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_COM.DESCRIP");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_COM.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("serialNumber");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getSerialNumber");
        directtofieldmapping2.setSetMethodName("setSerialNumber");
        directtofieldmapping2.setFieldName("MAP_COM.SERL_NO");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping objecttypemapping = new DirectToFieldMapping();
        ObjectTypeConverter objecttypeconverter = new ObjectTypeConverter();
        objecttypemapping.setAttributeName("isMacintosh");
        objecttypemapping.setIsReadOnly(false);
        objecttypemapping.setFieldName("MAP_COM.IS_MAC");
        objecttypeconverter.addConversionValue((Object)"No", (Object)Boolean.FALSE);
        objecttypeconverter.addConversionValue((Object)"Yes", (Object)Boolean.TRUE);
        objecttypemapping.setNullValue((Object)Boolean.FALSE);
        objecttypemapping.setConverter((Converter)objecttypeconverter);
        descriptor.addMapping((DatabaseMapping)objecttypemapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("monitor");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setGetMethodName("getMonitor");
        onetoonemapping.setSetMethodName("setMonitor");
        onetoonemapping.setReferenceClass(Monitor.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addForeignKeyFieldName("MAP_COM.MON_SER", "MAP_MON.SERL_NO");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildCubicleDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Cubicle.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_CUB");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_CUB.C_ID");
        descriptor.setSequenceNumberName("SEQ_ID");
        descriptor.setSequenceNumberFieldName("C_ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping typeConversionMapping = new DirectToFieldMapping();
        TypeConversionConverter typeConversionConverter = new TypeConversionConverter();
        typeConversionMapping.setAttributeName("id");
        typeConversionMapping.setIsReadOnly(false);
        typeConversionMapping.setFieldName("MAP_CUB.C_ID");
        typeConversionConverter.setObjectClass(BigDecimal.class);
        typeConversionConverter.setDataClass(String.class);
        typeConversionMapping.setConverter((Converter)typeConversionConverter);
        descriptor.addMapping((DatabaseMapping)typeConversionMapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("location");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_CUB.LOCATION");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("emergencyExits");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setReferenceClass(EmergencyExit.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("CUBICLE_EMERGENCYEXIT");
        manytomanymapping.addSourceRelationKeyFieldName("CUBICLE_EMERGENCYEXIT.CUBICLE_LOCATION", "MAP_CUB.LOCATION");
        manytomanymapping.addTargetRelationKeyFieldName("CUBICLE_EMERGENCYEXIT.EXIT_ID", "MAP_EMERGENCYEXIT.EXIT_ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmergencyExitDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(EmergencyExit.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_EMERGENCYEXIT");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_EMERGENCYEXIT.EXIT_ID");
        descriptor.setSequenceNumberName("SEQ_ID");
        descriptor.setSequenceNumberFieldName("EXIT_ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_EMERGENCYEXIT.EXIT_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("location");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_EMERGENCYEXIT.LOCATION");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildEmployeeDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Employee.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_EMP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_EMP.FNAME");
        descriptor.addPrimaryKeyFieldName("MAP_EMP.LNAME");
        descriptor.addPrimaryKeyFieldName("MAP_EMP.SEX");
        descriptor.createCopyPolicy("constructor");
        descriptor.useSoftIdentityMap();
        descriptor.createInstantiationPolicy("constructor");
        DirectCollectionMapping directcollectionmapping = new DirectCollectionMapping();
        directcollectionmapping.setAttributeName("policies");
        directcollectionmapping.setIsReadOnly(false);
        directcollectionmapping.setUsesIndirection(true);
        directcollectionmapping.setIsPrivateOwned(false);
        directcollectionmapping.setDirectFieldName("MAP_POL.POLICY");
        directcollectionmapping.setReferenceTableName("MAP_POL");
        directcollectionmapping.addReferenceKeyFieldName("MAP_POL.LNAME", "MAP_EMP.LNAME");
        directcollectionmapping.addReferenceKeyFieldName("MAP_POL.FNAME", "MAP_EMP.FNAME");
        descriptor.addMapping((DatabaseMapping)directcollectionmapping);
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("firstName");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_EMP.FNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("lastName");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToOneMapping onetoonemapping1 = new OneToOneMapping();
        onetoonemapping1.setAttributeName("cubicle");
        onetoonemapping1.setIsReadOnly(false);
        onetoonemapping1.setUsesIndirection(false);
        onetoonemapping1.setReferenceClass(Cubicle.class);
        onetoonemapping1.setIsPrivateOwned(true);
        onetoonemapping1.addForeignKeyFieldName("MAP_EMP.C_ID", "MAP_CUB.C_ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping1);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("phoneNumbers");
        manytomanymapping.setIsReadOnly(false);
        manytomanymapping.setUsesIndirection(true);
        manytomanymapping.setReferenceClass(Phone.class);
        manytomanymapping.setIsPrivateOwned(true);
        manytomanymapping.setRelationTableName("MAP_EMPH");
        manytomanymapping.addSourceRelationKeyFieldName("MAP_EMPH.LNAME", "MAP_EMP.LNAME");
        manytomanymapping.addSourceRelationKeyFieldName("MAP_EMPH.FNAME", "MAP_EMP.FNAME");
        manytomanymapping.addTargetRelationKeyFieldName("MAP_EMPH.P_ID", "MAP_PHO.P_ID");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        ManyToManyMapping manytomanymapping1 = new ManyToManyMapping();
        manytomanymapping1.setAttributeName("shipments");
        manytomanymapping1.setIsReadOnly(false);
        manytomanymapping1.setUsesIndirection(false);
        manytomanymapping1.setReferenceClass(Shipment.class);
        manytomanymapping1.setIsPrivateOwned(false);
        manytomanymapping1.setRelationTableName("MAP_EMSP");
        manytomanymapping1.addSourceRelationKeyFieldName("MAP_EMSP.EMP_LNAME", "MAP_EMP.LNAME");
        manytomanymapping1.addSourceRelationKeyFieldName("MAP_EMSP.EMP_FNAME", "MAP_EMP.FNAME");
        manytomanymapping1.addTargetRelationKeyFieldName("MAP_EMSP.SP_TSMIL", "MAP_SHIP.SP_TSMIL");
        manytomanymapping1.addTargetRelationKeyFieldName("MAP_EMSP.SP_TS", "MAP_SHIP.SP_TS");
        descriptor.addMapping((DatabaseMapping)manytomanymapping1);
        DirectToFieldMapping objecttypemapping = new DirectToFieldMapping();
        ObjectTypeConverter objecttypeconverter = new ObjectTypeConverter();
        objecttypemapping.setAttributeName("sex");
        objecttypemapping.setIsReadOnly(false);
        objecttypemapping.setFieldName("MAP_EMP.SEX");
        objecttypeconverter.setDefaultAttributeValue((Object)"female");
        objecttypeconverter.addConversionValue((Object)"F", (Object)"female");
        objecttypeconverter.addConversionValue((Object)"M", (Object)"male");
        objecttypemapping.setConverter((Converter)objecttypeconverter);
        descriptor.addMapping((DatabaseMapping)objecttypemapping);
        OneToManyMapping onetomanymapping = new OneToManyMapping();
        onetomanymapping.setAttributeName("managedEmployees");
        onetomanymapping.setIsReadOnly(false);
        onetomanymapping.setUsesIndirection(false);
        onetomanymapping.setGetMethodName("getManagedEmployeesForTOPLink");
        onetomanymapping.setSetMethodName("setManagedEmployeesFromTOPLink");
        onetomanymapping.setReferenceClass(Employee.class);
        onetomanymapping.setIsPrivateOwned(false);
        onetomanymapping.addTargetForeignKeyFieldName("MAP_EMP.M_LNAME", "MAP_EMP.LNAME");
        onetomanymapping.addTargetForeignKeyFieldName("MAP_EMP.M_FNAME", "MAP_EMP.FNAME");
        descriptor.addMapping((DatabaseMapping)onetomanymapping);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("computer");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setGetMethodName("getComputer");
        onetoonemapping.setSetMethodName("setComputer");
        onetoonemapping.setReferenceClass(Hardware.class);
        onetoonemapping.setIsPrivateOwned(true);
        onetoonemapping.addTargetForeignKeyFieldName("MAP_HRW.EMP_FNAME", "MAP_EMP.FNAME");
        onetoonemapping.addTargetForeignKeyFieldName("MAP_HRW.EMP_LNAME", "MAP_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        OneToOneMapping onetoonemapping2 = new OneToOneMapping();
        onetoonemapping2.setAttributeName("manager");
        onetoonemapping2.setIsReadOnly(false);
        onetoonemapping2.setUsesIndirection(false);
        onetoonemapping2.setGetMethodName("getManager");
        onetoonemapping2.setSetMethodName("setManager");
        onetoonemapping2.setReferenceClass(Employee.class);
        onetoonemapping2.setIsPrivateOwned(false);
        onetoonemapping2.addForeignKeyFieldName("MAP_EMP.M_FNAME", "MAP_EMP.FNAME");
        onetoonemapping2.addForeignKeyFieldName("MAP_EMP.M_LNAME", "MAP_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping2);
        DirectToFieldMapping serializedmapping = new DirectToFieldMapping();
        SerializedObjectConverter serializedconverter = new SerializedObjectConverter();
        serializedmapping.setAttributeName("jobDescription");
        serializedmapping.setIsReadOnly(false);
        serializedmapping.setGetMethodName("getJobDescription");
        serializedmapping.setSetMethodName("setJobDescription");
        serializedmapping.setFieldName("MAP_EMP.JDESC");
        serializedmapping.setConverter((Converter)serializedconverter);
        descriptor.addMapping((DatabaseMapping)serializedmapping);
        TransformationMapping transformationmapping = new TransformationMapping();
        transformationmapping.setAttributeName("dateAndTimeOfBirth");
        transformationmapping.setIsReadOnly(false);
        transformationmapping.setUsesIndirection(false);
        transformationmapping.setAttributeTransformation("setDateAndTime");
        transformationmapping.addFieldTransformation("MAP_EMP.BDAY", "getDate");
        transformationmapping.addFieldTransformation("MAP_EMP.BTIME", "getTime");
        descriptor.addMapping((DatabaseMapping)transformationmapping);
        TransformationMapping transformationmapping1 = new TransformationMapping();
        transformationmapping1.setAttributeName("designation");
        transformationmapping1.setIsReadOnly(false);
        transformationmapping1.setUsesIndirection(true);
        transformationmapping1.setGetMethodName("getDesignation");
        transformationmapping1.setSetMethodName("setDesignation");
        transformationmapping1.setAttributeTransformation("getRankFromRow");
        transformationmapping1.addFieldTransformation("MAP_EMP.ERANK", "getRankFromObject");
        descriptor.addMapping((DatabaseMapping)transformationmapping1);
        DirectToFieldMapping typeconversionmapping = new DirectToFieldMapping();
        TypeConversionConverter typeconversionconverter = new TypeConversionConverter();
        typeconversionmapping.setAttributeName("joiningDate");
        typeconversionmapping.setIsReadOnly(false);
        typeconversionmapping.setFieldName("MAP_EMP.JDAY");
        typeconversionconverter.setObjectClass(java.util.Date.class);
        typeconversionconverter.setDataClass(Date.class);
        typeconversionmapping.setConverter((Converter)typeconversionconverter);
        descriptor.addMapping((DatabaseMapping)typeconversionmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildIdentificationDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Identification.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_IDENTIFICATION");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_IDENTIFICATION.ID");
        descriptor.setSequenceNumberName("SEQ_ID");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("id");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_IDENTIFICATION.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildHardwareDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Hardware.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_HRW");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_HRW.ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.getInheritancePolicy().setShouldReadSubclasses(true);
        descriptor.getInheritancePolicy().setClassIndicatorFieldName("TYPE");
        descriptor.getInheritancePolicy().setShouldUseClassNameAsIndicator(false);
        descriptor.getInheritancePolicy().addClassIndicator(Computer.class, (Object)"C");
        descriptor.getInheritancePolicy().addClassIndicator(Monitor.class, (Object)"M");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("distibuted");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_HRW.DIST");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_HRW.ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("employee");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setReferenceClass(Employee.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("MAP_HRW.EMP_FNAME", "MAP_EMP.FNAME");
        onetoonemapping.addForeignKeyFieldName("MAP_HRW.EMP_LNAME", "MAP_EMP.LNAME");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildMonitorDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Monitor.class);
        descriptor.getInheritancePolicy().setParentClass(Hardware.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_MON");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_MON.ID");
        descriptor.getInheritancePolicy().setShouldReadSubclasses(false);
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("brand");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setGetMethodName("getBrand");
        directtofieldmapping.setSetMethodName("setBrand");
        directtofieldmapping.setFieldName("MAP_MON.BRAND");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("serialNumber");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setGetMethodName("getSerialNumber");
        directtofieldmapping1.setSetMethodName("setSerialNumber");
        directtofieldmapping1.setFieldName("MAP_MON.SERL_NO");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("size");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setGetMethodName("getSize");
        directtofieldmapping2.setSetMethodName("setSize");
        directtofieldmapping2.setFieldName("MAP_MON.MSIZE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        OneToOneMapping onetoonemapping = new OneToOneMapping();
        onetoonemapping.setAttributeName("computer");
        onetoonemapping.setIsReadOnly(false);
        onetoonemapping.setUsesIndirection(false);
        onetoonemapping.setGetMethodName("getComputer");
        onetoonemapping.setSetMethodName("setComputer");
        onetoonemapping.setReferenceClass(Computer.class);
        onetoonemapping.setIsPrivateOwned(false);
        onetoonemapping.addForeignKeyFieldName("MAP_MON.COM_SER", "MAP_COM.SERL_NO");
        descriptor.addMapping((DatabaseMapping)onetoonemapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildPhoneDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Phone.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_PHO");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_PHO.P_ID");
        descriptor.setSequenceNumberName("SEQ_ID");
        descriptor.setSequenceNumberFieldName("P_ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.useHardCacheWeakIdentityMap();
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("areaCode");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_PHO.AREACODE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("id");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_PHO.P_ID");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("number");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("MAP_PHO.PNUMBER");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildSecureSystemDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(SecureSystem.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_SECURE");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_SECURE.MANUFACTURER");
        descriptor.addPrimaryKeyFieldName("MAP_SECURE.IDENTIFICATION_ID");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("manufacturer");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_SECURE.MANUFACTURER");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        OneToOneMapping onetoonemapping1 = new OneToOneMapping();
        onetoonemapping1.setAttributeName("id");
        onetoonemapping1.setIsReadOnly(false);
        onetoonemapping1.setUsesIndirection(false);
        onetoonemapping1.setReferenceClass(Identification.class);
        onetoonemapping1.setIsPrivateOwned(false);
        onetoonemapping1.addForeignKeyFieldName("MAP_SECURE.IDENTIFICATION_ID", "MAP_IDENTIFICATION.ID");
        descriptor.addMapping((DatabaseMapping)onetoonemapping1);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    protected void buildShipmentDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Shipment.class);
        Vector<String> vector = new Vector<String>();
        vector.addElement("MAP_SHIP");
        descriptor.setTableNames(vector);
        descriptor.addPrimaryKeyFieldName("MAP_SHIP.SP_TS");
        descriptor.addPrimaryKeyFieldName("MAP_SHIP.SP_TSMIL");
        descriptor.getEventManager().setPreInsertSelector("prepareForInsert");
        descriptor.createCopyPolicy("constructor");
        descriptor.createInstantiationPolicy("constructor");
        DirectToFieldMapping directtofieldmapping = new DirectToFieldMapping();
        directtofieldmapping.setAttributeName("creationTimestamp");
        directtofieldmapping.setIsReadOnly(false);
        directtofieldmapping.setFieldName("MAP_SHIP.SP_TS");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping);
        DirectToFieldMapping directtofieldmapping1 = new DirectToFieldMapping();
        directtofieldmapping1.setAttributeName("creationTimestampMillis");
        directtofieldmapping1.setIsReadOnly(false);
        directtofieldmapping1.setFieldName("MAP_SHIP.SP_TSMIL");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping1);
        DirectToFieldMapping directtofieldmapping2 = new DirectToFieldMapping();
        directtofieldmapping2.setAttributeName("quantityShipped");
        directtofieldmapping2.setIsReadOnly(false);
        directtofieldmapping2.setFieldName("MAP_SHIP.QUANTITY");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping2);
        DirectToFieldMapping directtofieldmapping3 = new DirectToFieldMapping();
        directtofieldmapping3.setAttributeName("shipMode");
        directtofieldmapping3.setIsReadOnly(false);
        directtofieldmapping3.setFieldName("MAP_SHIP.SHP_MODE");
        descriptor.addMapping((DatabaseMapping)directtofieldmapping3);
        ManyToManyMapping manytomanymapping = new ManyToManyMapping();
        manytomanymapping.setAttributeName("employees");
        manytomanymapping.setIsReadOnly(true);
        manytomanymapping.setUsesIndirection(false);
        manytomanymapping.setReferenceClass(Employee.class);
        manytomanymapping.setIsPrivateOwned(false);
        manytomanymapping.setRelationTableName("MAP_EMSP");
        manytomanymapping.addSourceRelationKeyFieldName("MAP_EMSP.SP_TSMIL", "MAP_SHIP.SP_TSMIL");
        manytomanymapping.addSourceRelationKeyFieldName("MAP_EMSP.SP_TS", "MAP_SHIP.SP_TS");
        manytomanymapping.addTargetRelationKeyFieldName("MAP_EMSP.EMP_LNAME", "MAP_EMP.LNAME");
        manytomanymapping.addTargetRelationKeyFieldName("MAP_EMSP.EMP_FNAME", "MAP_EMP.FNAME");
        descriptor.addMapping((DatabaseMapping)manytomanymapping);
        this.addDescriptor((ClassDescriptor)descriptor);
    }

    public void buildPeripheralDescriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(Peripheral.class);
        descriptor.addTableName("MAP_PERIPHERAL");
        descriptor.addPrimaryKeyFieldName("MAP_PERIPHERAL.ID");
        descriptor.setAlias("Peripheral");
        descriptor.setAmendmentClass(Peripheral.class);
        descriptor.setAmendmentMethodName("addToDescriptor");
        descriptor.getQueryManager().checkCacheForDoesExist();
        DirectToFieldMapping validMapping = new DirectToFieldMapping();
        validMapping.setAttributeName("valid");
        validMapping.setFieldName("MAP_PERIPHERAL.VALID");
        ObjectTypeConverter validMappingConverter = new ObjectTypeConverter();
        validMappingConverter.addConversionValue((Object)Character.valueOf('N'), (Object)Boolean.valueOf("false"));
        validMappingConverter.addConversionValue((Object)Character.valueOf('Y'), (Object)Boolean.valueOf("true"));
        validMapping.setConverter((Converter)validMappingConverter);
        descriptor.addMapping((DatabaseMapping)validMapping);
        DirectToFieldMapping idMapping = new DirectToFieldMapping();
        idMapping.setAttributeName("id");
        idMapping.setFieldName("MAP_PERIPHERAL.ID");
        descriptor.addMapping((DatabaseMapping)idMapping);
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("MAP_PERIPHERAL.NAME");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        descriptor.applyAmendmentMethod();
        this.addDescriptor((ClassDescriptor)descriptor);
    }
}

