/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork.writechanges;

import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;

public class WriteChanges_IssueSQL_TestCase
extends AutoVerifyTestCase {
    protected Exception exception;
    Vector result;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        try {
            uow.writeChanges();
            uow.executeNonSelectingCall((Call)new SQLCall("UPDATE EMPLOYEE SET F_NAME = 'Steve'"));
            Expression expression = new ExpressionBuilder().get("firstName").equal((Object)"Steve");
            ReportQuery query = new ReportQuery(Employee.class, expression);
            query.addAttribute("id");
            this.result = (Vector)uow.executeQuery((DatabaseQuery)query);
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            uow.release();
        }
    }

    public void verify() {
        if (this.exception != null) {
            throw new TestErrorException("Exception thrown during the test.", (Throwable)this.exception);
        }
        if (this.result.size() != 12) {
            throw new TestErrorException("Not all employees were updated.  All 12 should have been, instead: " + this.result.size() + " were.");
        }
    }

    public void reset() {
        this.result = null;
        this.exception = null;
    }
}

