/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.client.admin;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import oracle.kv.ExecutionFuture;
import oracle.kv.FaultException;
import oracle.kv.KVSecurityException;
import oracle.kv.KVVersion;
import oracle.kv.StatementResult;
import oracle.kv.impl.admin.AdminFaultException;
import oracle.kv.impl.client.admin.AdminResult;
import oracle.kv.impl.client.admin.ClientAdminServiceAPI;
import oracle.kv.impl.client.admin.DdlStatementExecutor;
import oracle.kv.impl.client.admin.ExecutionInfo;
import oracle.kv.impl.client.admin.ExecutionInfoImpl;

public class DdlFuture
implements ExecutionFuture {
    private static final short CURRENT_VERSION = 1;
    static Charset UTF8 = Charset.forName("UTF-8");
    private final char[] statement;
    private volatile boolean cancelRequested;
    private volatile boolean isCancelled;
    private volatile boolean isDone;
    private final DdlStatementExecutor statementExec;
    private final CountDownLatch countdown;
    private final int planId;
    private volatile ExecutionInfo lastExecInfo;
    private volatile Throwable firstProblem;

    public DdlFuture(int planId, DdlStatementExecutor statementExecutor) {
        assert (planId > 0);
        this.statement = null;
        this.planId = planId;
        this.statementExec = statementExecutor;
        this.countdown = new CountDownLatch(1);
    }

    public DdlFuture(byte[] futureBytes, DdlStatementExecutor statementExecutor) {
        this.statementExec = statementExecutor;
        ByteBuffer buf = ByteBuffer.wrap(futureBytes);
        short version = buf.getShort();
        if (version != 1) {
            throw new IllegalArgumentException("Version " + KVVersion.CURRENT_VERSION + "of the NoSQL DB client cannot accept a serialized ExecutionFuture that is version " + version);
        }
        this.planId = buf.getInt();
        short statementLen = buf.getShort();
        this.statement = statementLen > 0 ? this.readCharArrayAndReposition(buf, statementLen) : new char[0];
        if (this.planId > 0) {
            this.countdown = new CountDownLatch(1);
            return;
        }
        this.isDone = true;
        this.countdown = new CountDownLatch(0);
        int statusLen = buf.getInt();
        String status = this.readStringAndReposition(buf, statusLen);
        int statusAsJsonLen = buf.getInt();
        String statusAsJson = this.readStringAndReposition(buf, statusAsJsonLen);
        int resultLen = buf.getInt();
        String result = this.readStringAndReposition(buf, resultLen);
        this.lastExecInfo = new ExecutionInfoImpl(this.planId, true, status, statusAsJson, true, false, null, false, result);
    }

    private String readStringAndReposition(ByteBuffer buf, int stringLen) {
        String result = null;
        if (stringLen > 0) {
            result = new String(buf.array(), buf.position(), stringLen, UTF8);
            buf.position(buf.position() + stringLen);
        }
        return result;
    }

    private char[] readCharArrayAndReposition(ByteBuffer buf, int stringLen) {
        char[] res = null;
        if (stringLen > 0) {
            ByteBuffer buf2 = ByteBuffer.wrap(buf.array(), buf.position(), stringLen);
            res = UTF8.decode(buf2).array();
            buf.position(buf.position() + stringLen);
        }
        return res;
    }

    public DdlFuture(char[] statement, ExecutionInfo executionInfo, DdlStatementExecutor statementExecutor) {
        this.statement = statement;
        this.planId = executionInfo.getPlanId();
        this.lastExecInfo = executionInfo;
        this.statementExec = statementExecutor;
        if (this.planId > 0) {
            this.countdown = new CountDownLatch(1);
        } else {
            this.isDone = true;
            this.countdown = new CountDownLatch(0);
        }
        this.applyNewInfo(executionInfo, null);
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) throws FaultException {
        if (this.isDone) {
            return false;
        }
        if (this.isCancelled) {
            return false;
        }
        if (!mayInterruptIfRunning) {
            return false;
        }
        try {
            this.cancelRequested = true;
            ExecutionInfo newInfo = DdlFuture.cancelAndGetStatus(this.statementExec, this.planId);
            this.applyNewInfo(newInfo, null);
            this.statementExec.updateWaiters(newInfo);
            return this.isCancelled();
        }
        catch (AdminFaultException e) {
            throw new FaultException("Problem cancelling " + new String(this.statement) + ", planId = " + this.planId + ": " + e, false);
        }
        catch (RemoteException e) {
            throw new FaultException("Communication problem cancelling  for " + new String(this.statement) + ", plan " + this.planId + ", retry:" + e, false);
        }
    }

    @Override
    public StatementResult get() throws InterruptedException, ExecutionException {
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (!this.isDone) {
            this.statementExec.startPolling(this.planId, this);
        }
        this.countdown.await();
        this.checkForError();
        return this.getLastStatus();
    }

    @Override
    public StatementResult get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean finished;
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (!this.isDone) {
            this.statementExec.startPolling(this.planId, this);
        }
        if (!(finished = this.countdown.await(timeout, unit))) {
            throw new TimeoutException("Statement '" + new String(this.statement) + "' did not finish within " + timeout + " " + (Object)((Object)unit));
        }
        this.checkForError();
        return this.getLastStatus();
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public boolean isDone() {
        this.updateStatus();
        return this.isDone;
    }

    @Override
    public StatementResult updateStatus() {
        if (this.isDone) {
            return this.getLastStatus();
        }
        try {
            ClientAdminServiceAPI ca = this.statementExec.getClientAdminService();
            ExecutionInfo newInfo = ca.getExecutionStatus(this.planId);
            newInfo = DdlFuture.checkForNeedsCancel(newInfo, this.statementExec, this.planId);
            this.applyNewInfo(newInfo, null);
        }
        catch (AdminFaultException e) {
            throw new FaultException("Problem updating status for '" + new String(this.statement) + "', planId = " + this.planId + ": " + e, false);
        }
        catch (RemoteException e) {
            throw new FaultException("Communication problem updating status  for '" + new String(this.statement) + "', plan " + this.planId + ", retry:" + e, false);
        }
        return this.getLastStatus();
    }

    @Override
    public synchronized StatementResult getLastStatus() {
        return new AdminResult(this.planId, this.lastExecInfo, this.isDone, this.isCancelled);
    }

    @Override
    public String getStatement() {
        return new String(this.statement);
    }

    private synchronized void checkForError() throws ExecutionException, KVSecurityException {
        if (this.firstProblem != null && this.firstProblem instanceof KVSecurityException) {
            KVSecurityException k = (KVSecurityException)this.firstProblem;
            throw k;
        }
        if (this.lastExecInfo != null && this.lastExecInfo.getErrorMessage() != null) {
            throw new ExecutionException(new FaultException(this.lastExecInfo.getErrorMessage(), false));
        }
    }

    synchronized void applyNewInfo(ExecutionInfo newInfo, Throwable t) {
        if (this.isDone) {
            return;
        }
        if (this.firstProblem == null) {
            this.firstProblem = t;
        }
        this.lastExecInfo = newInfo;
        this.isDone = newInfo.isTerminated();
        boolean bl = this.isCancelled = newInfo.isCancelled() && this.cancelRequested;
        if (newInfo.isTerminated() || t != null) {
            this.countdown.countDown();
        }
    }

    static ExecutionInfo checkForNeedsCancel(ExecutionInfo info, DdlStatementExecutor statementExec, int planId) throws RemoteException {
        if (info.needsTermination()) {
            return DdlFuture.cancelAndGetStatus(statementExec, planId);
        }
        return info;
    }

    static ExecutionInfo cancelAndGetStatus(DdlStatementExecutor statementExec, int planId) throws RemoteException {
        ClientAdminServiceAPI ca = statementExec.getClientAdminService();
        return ca.interruptAndCancel(planId);
    }

    @Override
    public byte[] toByteArray() {
        String status = null;
        String statusAsJson = null;
        String result = null;
        if (this.lastExecInfo != null) {
            status = this.lastExecInfo.getInfo();
            statusAsJson = this.lastExecInfo.getJSONInfo();
            result = this.lastExecInfo.getResult();
        }
        return DdlFuture.toByteArray(this.planId, this.statement, status, statusAsJson, result);
    }

    public static byte[] toByteArray(int planId) {
        return DdlFuture.toByteArray(planId, new char[0], null, null, null);
    }

    public int getPlanId() {
        return this.planId;
    }

    private static byte[] toByteArray(int planId, char[] statement, String status, String statusAsJson, String result) {
        int serializedLen = 8;
        ByteBuffer bb = UTF8.encode(CharBuffer.wrap(statement));
        byte[] statementBytes = bb.array();
        int statementLength = bb.remaining();
        serializedLen += statementLength;
        int statusLen = 0;
        int statusAsJsonLen = 0;
        int resultLen = 0;
        byte[] statusBytes = null;
        byte[] statusAsJsonBytes = null;
        byte[] resultBytes = null;
        if (planId == 0) {
            if (status != null) {
                statusBytes = status.getBytes(UTF8);
                statusLen = statusBytes.length;
            }
            if (statusAsJson != null) {
                statusAsJsonBytes = statusAsJson.getBytes(UTF8);
                statusAsJsonLen = statusAsJsonBytes.length;
            }
            if (result != null) {
                resultBytes = result.getBytes(UTF8);
                resultLen = resultBytes.length;
            }
            serializedLen += 12 + statusLen + statusAsJsonLen + resultLen;
        }
        ByteBuffer buf = ByteBuffer.allocate(serializedLen);
        buf.putShort((short)1);
        buf.putInt(planId);
        buf.putShort((short)statementLength);
        if (statementLength > 0) {
            buf.put(statementBytes, 0, statementLength);
        }
        if (planId == 0) {
            buf.putInt(statusLen);
            if (statusLen > 0) {
                buf.put(statusBytes);
            }
            buf.putInt(statusAsJsonLen);
            if (statusAsJsonLen > 0) {
                buf.put(statusAsJsonBytes);
            }
            buf.putInt(resultLen);
            if (resultLen > 0) {
                buf.put(resultBytes);
            }
        }
        return buf.array();
    }
}

