/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.aggregate;

import java.util.ArrayList;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.models.aggregate.Parent;
import org.eclipse.persistence.testing.models.aggregate.Relative;

public class AggregateRelationshipsManyToManyTestCase
extends TestCase {
    protected Parent originalParent;
    protected Parent readParent;

    public AggregateRelationshipsManyToManyTestCase() {
        this.setDescription("AggregateRelationships: test ManyToManyMapping");
    }

    public void setup() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.originalParent = new Parent();
        Relative relative1 = new Relative();
        Relative relative2 = new Relative();
        Relative relative3 = new Relative();
        this.originalParent.addRelative(relative1);
        this.originalParent.addRelative(relative2);
        this.originalParent.addRelative(relative3);
        uow.registerObject((Object)this.originalParent);
        uow.commit();
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
    }

    public void test() {
        int id = this.originalParent.getId();
        try {
            this.readParent = (Parent)this.getSession().readObject(Parent.class, new ExpressionBuilder().get("id").equal(id));
        }
        catch (EclipseLinkException exception) {
            this.throwError("An exception occurred whilst reading back a Parent object with id " + id, exception);
        }
    }

    public void verify() {
        AggregateRelationshipsManyToManyTestCase.assertNotNull((String)"Parent read back should not be null", (Object)this.readParent);
        this.compareObjects(this.originalParent, this.readParent);
        AggregateRelationshipsManyToManyTestCase.assertEquals((int)this.originalParent.getAggregate().getRelatives().size(), (int)this.readParent.getAggregate().getRelatives().size());
    }

    public void reset() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        Parent parent = (Parent)uow.registerObject((Object)this.originalParent);
        ArrayList<Relative> relatives = new ArrayList<Relative>(parent.getAggregate().getRelatives());
        for (Relative relative : relatives) {
            parent.removeRelative(relative);
            uow.deleteObject((Object)relative);
        }
        uow.deleteObject((Object)this.originalParent);
        uow.commit();
    }
}

