/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.collections.map;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.collections.map.EEOTMMapValue;
import org.eclipse.persistence.testing.models.collections.map.EntityEntity1MMapHolder;
import org.eclipse.persistence.testing.models.collections.map.EntityMapKey;
import org.eclipse.persistence.testing.tests.collections.map.TestReadEntityEntity1MMapMapping;

public class TestUpdateEntityEntity1MMapMapping
extends TestReadEntityEntity1MMapMapping {
    protected OneToManyMapping mapping = null;
    private boolean usePrivateOwned = false;
    private boolean oldValuePrivateOwnedValue = false;
    protected ForeignReferenceMapping keyMapping = null;
    private boolean oldKeyPrivateOwnedValue = false;
    protected EntityEntity1MMapHolder changedHolder = null;

    public TestUpdateEntityEntity1MMapMapping() {
    }

    public TestUpdateEntityEntity1MMapMapping(boolean usePrivateOwned) {
        this();
        this.usePrivateOwned = usePrivateOwned;
        this.setName("TestUpdateEntityEntity1MMapMapping privateOwned=" + usePrivateOwned);
    }

    @Override
    public void setup() {
        this.mapping = (OneToManyMapping)this.getSession().getProject().getDescriptor(EntityEntity1MMapHolder.class).getMappingForAttributeName("entityToEntityMap");
        this.oldValuePrivateOwnedValue = this.mapping.isPrivateOwned();
        this.mapping.setIsPrivateOwned(this.usePrivateOwned);
        this.keyMapping = (ForeignReferenceMapping)((MappedKeyMapContainerPolicy)this.mapping.getContainerPolicy()).getKeyMapping();
        this.oldKeyPrivateOwnedValue = this.keyMapping.isPrivateOwned();
        this.keyMapping.setIsPrivateOwned(this.usePrivateOwned);
        super.setup();
    }

    @Override
    public void test() {
        UnitOfWork uow = this.getSession().acquireUnitOfWork();
        this.holders = uow.readAllObjects(EntityEntity1MMapHolder.class, this.holderExp);
        this.changedHolder = (EntityEntity1MMapHolder)this.holders.get(0);
        EntityMapKey key = new EntityMapKey();
        key.setId(11);
        this.changedHolder.removeEntityToEntityMapItem(key);
        EEOTMMapValue mapValue = new EEOTMMapValue();
        mapValue.setId(3);
        mapValue = (EEOTMMapValue)uow.registerObject((Object)mapValue);
        key = new EntityMapKey();
        key.setId(33);
        key = (EntityMapKey)uow.registerObject((Object)key);
        mapValue.getHolder().setValue((Object)this.changedHolder);
        this.changedHolder.addEntityToEntityMapItem(key, mapValue);
        uow.commit();
        Object holderForComparison = uow.readObject((Object)this.changedHolder);
        if (!this.compareObjects(this.changedHolder, holderForComparison)) {
            throw new TestErrorException("Objects do not match after write");
        }
    }

    @Override
    public void verify() {
        this.getSession().getIdentityMapAccessor().initializeIdentityMaps();
        this.holders = this.getSession().readAllObjects(EntityEntity1MMapHolder.class, this.holderExp);
        EntityEntity1MMapHolder holder = (EntityEntity1MMapHolder)this.holders.get(0);
        if (!this.compareObjects(holder, this.changedHolder)) {
            throw new TestErrorException("Objects do not match reinitialize");
        }
        EntityMapKey key = new EntityMapKey();
        key.setId(11);
        if (holder.getEntityToEntityMap().containsKey(key)) {
            throw new TestErrorException("Item that was removed is still present in map.");
        }
        key = new EntityMapKey();
        key.setId(33);
        EEOTMMapValue value = (EEOTMMapValue)holder.getEntityToEntityMap().get(key);
        if (value.getId() != 3) {
            throw new TestErrorException("Item was not correctly added to map");
        }
        if (this.mapping.isPrivateOwned()) {
            ReadObjectQuery query = new ReadObjectQuery(EEOTMMapValue.class);
            ExpressionBuilder values = new ExpressionBuilder();
            Expression criteria = values.get("id").equal(1);
            query.setSelectionCriteria(criteria);
            value = (EEOTMMapValue)this.getSession().executeQuery((DatabaseQuery)query);
            if (value != null) {
                throw new TestErrorException("PrivateOwned DEOTMMapValue was not deleted.");
            }
            query = new ReadObjectQuery(EntityMapKey.class);
            ExpressionBuilder keys = new ExpressionBuilder();
            Expression keycriteria = keys.get("id").equal(11);
            query.setSelectionCriteria(keycriteria);
            key = (EntityMapKey)this.getSession().executeQuery((DatabaseQuery)query);
            if (key != null) {
                throw new TestErrorException("PrivateOwned EntityMapKey was not deleted.");
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mapping.setIsPrivateOwned(this.oldValuePrivateOwnedValue);
        this.keyMapping.setIsPrivateOwned(this.oldKeyPrivateOwnedValue);
    }
}

