/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.dynamic.simple;

import java.util.Calendar;
import org.eclipse.persistence.dynamic.DynamicClassLoader;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicHelper;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.dynamic.DynamicTypeBuilder;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.tests.dynamic.DynamicTestingHelper;
import org.eclipse.persistence.testing.tests.dynamic.simple.SimpleTypeTestSuite;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class SimpleTypeCompositeKeyTestSuite
extends SimpleTypeTestSuite {
    @BeforeClass
    public static void setUp() {
        session = DynamicTestingHelper.createSession();
        dynamicHelper = new DynamicHelper(session);
        DynamicClassLoader dcl = dynamicHelper.getDynamicClassLoader();
        Class javaType = dcl.createDynamicClass("simple.Simple");
        DynamicTypeBuilder typeBuilder = new DynamicTypeBuilder(javaType, null, new String[]{"SIMPLE_TYPE"});
        typeBuilder.setPrimaryKeyFields(new String[]{"SID1", "SID2"});
        typeBuilder.addDirectMapping("id1", Integer.TYPE, "SID1");
        typeBuilder.addDirectMapping("id2", Integer.TYPE, "SID2");
        typeBuilder.addDirectMapping("value1", String.class, "VAL_1");
        typeBuilder.addDirectMapping("value2", Boolean.TYPE, "VAL_2");
        typeBuilder.addDirectMapping("value3", Calendar.class, "VAL_3");
        typeBuilder.addDirectMapping("value4", Character.class, "VAL_4");
        dynamicHelper.addTypes(true, false, new DynamicType[]{typeBuilder.getType()});
    }

    @AfterClass
    public static void tearDown() {
        session.executeNonSelectingSQL("DROP TABLE SIMPLE_TYPE");
        session.logout();
        session = null;
        dynamicHelper = null;
    }

    @Override
    protected void assertDefaultValues(DynamicEntity simpleInstance) {
        Assert.assertNotNull((Object)simpleInstance);
        Assert.assertEquals((String)"id1 not default value", (long)0L, (long)((Integer)simpleInstance.get("id1")).intValue());
        Assert.assertEquals((String)"id2 not default value", (long)0L, (long)((Integer)simpleInstance.get("id2")).intValue());
        Assert.assertFalse((String)"value1 set on new instance", (boolean)simpleInstance.isSet("value1"));
        Assert.assertEquals((String)"value2 not default value on new instance", (Object)false, (Object)simpleInstance.get("value2"));
        Assert.assertFalse((String)"value3 set on new instance", (boolean)simpleInstance.isSet("value3"));
        Assert.assertFalse((String)"value4 set on new instance", (boolean)simpleInstance.isSet("value4"));
    }

    @Override
    public DynamicEntity createSimpleInstance(Session session, int id) {
        DynamicType simpleEntityType = dynamicHelper.getType("Simple");
        Assert.assertNotNull((Object)simpleEntityType);
        DynamicEntity simpleInstance = simpleEntityType.newDynamicEntity();
        simpleInstance.set("id1", (Object)id);
        simpleInstance.set("id2", (Object)id);
        simpleInstance.set("value2", (Object)true);
        ReportQuery countQuery = dynamicHelper.newReportQuery("Simple", new ExpressionBuilder());
        countQuery.addCount();
        countQuery.setShouldReturnSingleValue(true);
        Assert.assertEquals((long)0L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        UnitOfWork uow = session.acquireUnitOfWork();
        uow.registerNewObject((Object)simpleInstance);
        uow.commit();
        Assert.assertEquals((long)1L, (long)((Number)session.executeQuery((DatabaseQuery)countQuery)).intValue());
        DynamicEntity foundEntity = this.find(dynamicHelper, session, 1);
        Assert.assertNotNull((Object)foundEntity);
        Assert.assertEquals((Object)simpleInstance.get("id1"), (Object)foundEntity.get("id1"));
        Assert.assertEquals((Object)simpleInstance.get("id2"), (Object)foundEntity.get("id2"));
        Assert.assertEquals((Object)simpleInstance.get("value1"), (Object)foundEntity.get("value1"));
        Assert.assertEquals((Object)simpleInstance.get("value2"), (Object)foundEntity.get("value2"));
        return simpleInstance;
    }

    @Override
    protected DynamicEntity find(DynamicHelper helper, Session session, Object id) {
        ReadObjectQuery findQuery = helper.newReadObjectQuery("Simple");
        ExpressionBuilder eb = findQuery.getExpressionBuilder();
        findQuery.setSelectionCriteria(eb.get("id1").equal(id).and(eb.get("id2").equal(id)));
        return (DynamicEntity)session.executeQuery((DatabaseQuery)findQuery);
    }
}

