/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.history;

import java.sql.Timestamp;
import java.util.Vector;
import junit.framework.Test;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.testing.framework.TestCase;
import org.eclipse.persistence.testing.framework.TestSuite;
import org.eclipse.persistence.testing.framework.TestWarningException;
import org.eclipse.persistence.testing.framework.TestWrapper;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.tests.employee.EmployeeBasicTestModel;
import org.eclipse.persistence.testing.tests.flashback.FlashbackTestModel;
import org.eclipse.persistence.testing.tests.history.HistoricalEmployeeSystem;
import org.eclipse.persistence.testing.tests.history.InsertWithHistoryPolicyTest;
import org.eclipse.persistence.testing.tests.history.IsolatedSessionHistoricalTest;
import org.eclipse.persistence.testing.tests.history.RollbackObjectsTest;

public class HistoryTestModel
extends FlashbackTestModel {
    int mode;
    public static int BASIC = 0;
    public static int PROJECT_XML = 1;
    public static int PROJECT_CLASS_GENERATED = 2;

    public HistoryTestModel(int mode) {
        this.setDescription("Tests the new flashback query tests, but using a Historical Schema.");
        this.mode = mode;
        if (mode == BASIC) {
            this.setName("HistoryTestModel");
        } else if (mode == PROJECT_XML) {
            this.setName("ProjectXMLHistoryTestModel");
        } else if (mode == PROJECT_CLASS_GENERATED) {
            this.setName("ProjectClassGeneratedHistoryTestModel.");
        }
    }

    @Override
    public void addTests() {
        super.addTests();
        this.addTest((Test)new RollbackObjectsTest(Employee.class, this.getAsOfClause()));
        this.addTest((Test)EmployeeBasicTestModel.getReadObjectTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getReadAllTestSuite());
        this.addTest((Test)EmployeeBasicTestModel.getInsertObjectTestSuite());
        this.buildUpdateObjectTestSuite();
        this.addTest((Test)EmployeeBasicTestModel.getDeleteObjectTestSuite());
        this.addTest((Test)new IsolatedSessionHistoricalTest(this.getAsOfClause()));
        this.addTest((Test)new InsertWithHistoryPolicyTest());
    }

    private void configure() throws Exception {
        HistoricalEmployeeSystem system = new HistoricalEmployeeSystem(this.mode);
        system.run(this.getSession());
        this.buildAsOfClause();
        Thread.sleep(1000L);
        this.depopulate();
    }

    @Override
    public void buildAsOfClause() {
        this.asOfClause = new AsOfClause(new Timestamp(System.currentTimeMillis()));
    }

    @Override
    public void setup() {
        if (HistoryTestModel.getTimestamp() != null) {
            return;
        }
        try {
            this.configure();
        }
        catch (EclipseLinkException te) {
            throw te;
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    protected void buildUpdateObjectTestSuite() {
        TestSuite testSuite = EmployeeBasicTestModel.getUpdateObjectTestSuite();
        if (this.getSession().getPlatform().isMySQL()) {
            TestSuite newTestSuite = new TestSuite();
            Vector tests = testSuite.getTests();
            for (int i = 0; i < tests.size(); ++i) {
                Object test = (TestCase)tests.elementAt(i);
                class WrappedWriteObjectTest
                extends TestWrapper {
                    public WrappedWriteObjectTest(TestCase test) {
                        super(test);
                    }

                    protected void test() throws Throwable {
                        try {
                            super.test();
                        }
                        catch (DatabaseException databaseException) {
                            Throwable internalException = databaseException.getInternalException();
                            if (this.getSession().getPlatform().isMySQL() && internalException.getClass().getName().contains("MySQLIntegrityConstraintViolationException")) {
                                throw new TestWarningException("on MySQL microseconds cannot be stored into a column of any temporal data type, therefore the following exception occurred: ", internalException);
                            }
                            throw databaseException;
                        }
                    }
                }
                test = new WrappedWriteObjectTest((TestCase)test);
                newTestSuite.addTest((Test)test);
            }
            testSuite = newTestSuite;
        }
        this.addTest((Test)testSuite);
    }
}

