/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.RelationalDescriptor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.TransformationMapping;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentAddress;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentPhoneNumber;
import org.eclipse.persistence.testing.tests.unitofwork.ConcurrentProject;
import org.eclipse.persistence.tools.schemaframework.TableDefinition;

public class ConcurrentPerson
implements Serializable {
    public String name;
    public ConcurrentAddress address;
    public BigDecimal id;
    public BigDecimal luckyNumber;
    public static boolean isForBackup = false;
    public ConcurrentProject hobby = null;
    public List<ConcurrentPhoneNumber> phoneNumbers = new ArrayList<ConcurrentPhoneNumber>();
    public static int RUNNING_TEST;
    public static final int NONE = Integer.MIN_VALUE;
    public static int ONE_TO_ONE_INHERITANCE;
    public static int READ_FETCH_JOIN;

    public BigDecimal calculateLuckyNumber(DataRecord row, Session session) {
        Number code = (Number)row.get((Object)"ID");
        return new BigDecimal(code.doubleValue() * 2.435);
    }

    public static RelationalDescriptor descriptor() {
        RelationalDescriptor descriptor = new RelationalDescriptor();
        descriptor.setJavaClass(ConcurrentPerson.class);
        descriptor.setTableName("CONCURRENT_EMP");
        descriptor.setPrimaryKeyFieldName("ID");
        descriptor.setSequenceNumberName("SEQ");
        descriptor.setSequenceNumberFieldName("ID");
        descriptor.addDirectMapping("id", "ID");
        DirectToFieldMapping nameMapping = new DirectToFieldMapping();
        nameMapping.setAttributeName("name");
        nameMapping.setFieldName("NAME");
        nameMapping.setGetMethodName("getName");
        nameMapping.setSetMethodName("setName");
        descriptor.addMapping((DatabaseMapping)nameMapping);
        OneToOneMapping addressMapping = new OneToOneMapping();
        addressMapping.setAttributeName("address");
        addressMapping.setReferenceClass(ConcurrentAddress.class);
        addressMapping.setGetMethodName("getAddress");
        addressMapping.setSetMethodName("setAddress");
        addressMapping.dontUseIndirection();
        addressMapping.addForeignKeyFieldName("CONCURRENT_EMP.ADDR_ID", "CONCURRENT_ADDRESS.ADDRESS_ID");
        descriptor.addMapping((DatabaseMapping)addressMapping);
        TransformationMapping trans = new TransformationMapping();
        trans.setIsReadOnly(true);
        trans.dontUseIndirection();
        trans.setAttributeName("luckyNumber");
        trans.setAttributeTransformation("calculateLuckyNumber");
        descriptor.addMapping((DatabaseMapping)trans);
        OneToOneMapping hobbyMapping = new OneToOneMapping();
        hobbyMapping.setAttributeName("hobby");
        hobbyMapping.setReferenceClass(ConcurrentProject.class);
        hobbyMapping.setGetMethodName("getHobby");
        hobbyMapping.setSetMethodName("setHobby");
        hobbyMapping.dontUseIndirection();
        hobbyMapping.addForeignKeyFieldName("CONCURRENT_EMP.PROJ_ID", "CONCURRENT_PROJECT.ID");
        descriptor.addMapping((DatabaseMapping)hobbyMapping);
        OneToManyMapping phoneNumbersMapping = new OneToManyMapping();
        phoneNumbersMapping.setAttributeName("phoneNumbers");
        phoneNumbersMapping.setReferenceClass(ConcurrentPhoneNumber.class);
        phoneNumbersMapping.dontUseIndirection();
        phoneNumbersMapping.addTargetForeignKeyFieldName("CONCURRENT_PHONE.EMP_ID", "CONCURRENT_EMP.ID");
        descriptor.addMapping((DatabaseMapping)phoneNumbersMapping);
        return descriptor;
    }

    public static ConcurrentPerson example() {
        ConcurrentPerson example = new ConcurrentPerson();
        example.name = "Andrew";
        example.address = new ConcurrentAddress();
        example.address.city = "QuayTown";
        example.address.country = "North Quary";
        example.address.postalCode = "Z1Z 9A9";
        example.address.province = "NewProvince";
        example.address.street = "OldStreet";
        return example;
    }

    public static ConcurrentPerson example1() {
        ConcurrentPerson example = new ConcurrentPerson();
        example.name = "Dave";
        example.address = new ConcurrentAddress();
        example.address.city = "Bay City";
        example.address.country = "North Country";
        example.address.postalCode = "H0H0H0";
        example.address.province = "Manitoba";
        example.address.street = "Start";
        return example;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConcurrentAddress getAddress() {
        if (ConcurrentAddress.RUNNING_TEST == 56) {
            if (!isForBackup) {
                ConcurrentAddress concurrentAddress = this.address;
                synchronized (concurrentAddress) {
                    try {
                        isForBackup = true;
                        this.address.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            isForBackup = false;
        }
        return this.address;
    }

    public void setAddress(ConcurrentAddress address) {
        this.address = address;
    }

    public ConcurrentProject getHobby() {
        return this.hobby;
    }

    public void setHobby(ConcurrentProject hobby) {
        if (RUNNING_TEST == ONE_TO_ONE_INHERITANCE) {
            if (!isForBackup) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                isForBackup = true;
            } else {
                isForBackup = false;
            }
        }
        this.hobby = hobby;
    }

    public List<ConcurrentPhoneNumber> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(List<ConcurrentPhoneNumber> phoneNumbers) {
        if (RUNNING_TEST == READ_FETCH_JOIN) {
            if (!isForBackup) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                isForBackup = true;
            } else {
                isForBackup = false;
            }
        }
        this.phoneNumbers = phoneNumbers;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static TableDefinition tableDefinition() {
        TableDefinition definition = new TableDefinition();
        definition.setName("CONCURRENT_EMP");
        definition.addIdentityField("ID", BigDecimal.class, 15);
        definition.addField("NAME", String.class, 20);
        definition.addField("ADDR_ID", BigDecimal.class, 15);
        definition.addField("PROJ_ID", BigDecimal.class, 15);
        return definition;
    }

    static {
        ONE_TO_ONE_INHERITANCE = 1;
        READ_FETCH_JOIN = 1;
    }
}

