/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.beans;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.tools.beans.ExpressionNode;
import org.eclipse.persistence.tools.beans.ExpressionTreeModel;
import org.eclipse.persistence.tools.beans.MessageDialog;

public class ExpressionPanel
extends JPanel {
    protected Expression expression;
    protected ClassDescriptor descriptor;
    private JButton ivjAndButton = null;
    private JComboBox<String> ivjAttributeCombo = null;
    private JLabel ivjAttributeLabel = null;
    private JButton ivjClearButton = null;
    private JTree ivjExpressionTree = null;
    private JScrollPane ivjExpressionTreeScroll = null;
    private JButton ivjNotBuuton = null;
    private JComboBox<String> ivjOperatorCombo = null;
    private JLabel ivjOperatorLabel = null;
    private JButton ivjOrButton = null;
    private JToolBar ivjToolBar = null;
    private JLabel ivjValueLabel = null;
    private JTextField ivjValueText = null;
    IvjEventHandler ivjEventHandler = new IvjEventHandler();

    public ExpressionPanel() {
        this.initialize();
    }

    public ExpressionPanel(LayoutManager layout) {
        super(layout);
    }

    public ExpressionPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public ExpressionPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public void andExpression() {
        Expression newExpression = this.buildExpressionNode();
        if (newExpression == null) {
            return;
        }
        if (this.getExpression() == null) {
            this.setExpression(newExpression);
        } else {
            this.setExpression(this.getExpression().and(newExpression));
        }
    }

    public Expression buildExpressionNode() {
        ExpressionBuilder builder = this.getExpression() == null ? new ExpressionBuilder() : this.getExpression().getBuilder();
        String attribute = (String)this.getAttributeCombo().getSelectedItem();
        if (attribute == null) {
            return null;
        }
        String operator = (String)this.getOperatorCombo().getSelectedItem();
        String method = ExpressionNode.getMethod(operator);
        String value = this.getValueText().getText();
        Class[] types = new Class[]{Object.class};
        Object[] arguments = new Object[]{value};
        Expression queryKey = builder.get(attribute);
        try {
            return (Expression)queryKey.getClass().getMethod(method, types).invoke((Object)queryKey, arguments);
        }
        catch (Exception exception) {
            try {
                types[0] = String.class;
                return (Expression)queryKey.getClass().getMethod(method, types).invoke((Object)queryKey, arguments);
            }
            catch (Exception e) {
                this.handleException(e);
                return null;
            }
        }
    }

    public void clearExpression() {
        this.setExpression(null);
    }

    private void connEtoC1(ActionEvent arg1) {
        try {
            this.orExpression();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC2(ActionEvent arg1) {
        try {
            this.andExpression();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC3(ActionEvent arg1) {
        try {
            this.notExpression();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private void connEtoC4(ActionEvent arg1) {
        try {
            this.clearExpression();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
    }

    private JButton getAndButton() {
        if (this.ivjAndButton == null) {
            try {
                this.ivjAndButton = new JButton();
                this.ivjAndButton.setName("AndButton");
                this.ivjAndButton.setText("And");
                this.ivjAndButton.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAndButton;
    }

    private JComboBox<String> getAttributeCombo() {
        if (this.ivjAttributeCombo == null) {
            try {
                this.ivjAttributeCombo = new JComboBox();
                this.ivjAttributeCombo.setName("AttributeCombo");
                this.ivjAttributeCombo.setBackground(SystemColor.window);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAttributeCombo;
    }

    private JLabel getAttributeLabel() {
        if (this.ivjAttributeLabel == null) {
            try {
                this.ivjAttributeLabel = new JLabel();
                this.ivjAttributeLabel.setName("AttributeLabel");
                this.ivjAttributeLabel.setText("Attribute:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjAttributeLabel;
    }

    private JButton getClearButton() {
        if (this.ivjClearButton == null) {
            try {
                this.ivjClearButton = new JButton();
                this.ivjClearButton.setName("ClearButton");
                this.ivjClearButton.setText("Clear");
                this.ivjClearButton.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjClearButton;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Expression getExpression() {
        return this.expression;
    }

    private JTree getExpressionTree() {
        if (this.ivjExpressionTree == null) {
            try {
                this.ivjExpressionTree = new JTree();
                this.ivjExpressionTree.setName("ExpressionTree");
                this.ivjExpressionTree.setBounds(0, 0, 76, 36);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExpressionTree;
    }

    private JScrollPane getExpressionTreeScroll() {
        if (this.ivjExpressionTreeScroll == null) {
            try {
                this.ivjExpressionTreeScroll = new JScrollPane();
                this.ivjExpressionTreeScroll.setName("ExpressionTreeScroll");
                this.getExpressionTreeScroll().setViewportView(this.getExpressionTree());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjExpressionTreeScroll;
    }

    private JButton getNotBuuton() {
        if (this.ivjNotBuuton == null) {
            try {
                this.ivjNotBuuton = new JButton();
                this.ivjNotBuuton.setName("NotBuuton");
                this.ivjNotBuuton.setText("Not");
                this.ivjNotBuuton.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjNotBuuton;
    }

    private JComboBox<String> getOperatorCombo() {
        if (this.ivjOperatorCombo == null) {
            try {
                this.ivjOperatorCombo = new JComboBox();
                this.ivjOperatorCombo.setName("OperatorCombo");
                this.ivjOperatorCombo.setBackground(SystemColor.window);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOperatorCombo;
    }

    private JLabel getOperatorLabel() {
        if (this.ivjOperatorLabel == null) {
            try {
                this.ivjOperatorLabel = new JLabel();
                this.ivjOperatorLabel.setName("OperatorLabel");
                this.ivjOperatorLabel.setText("Operator:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOperatorLabel;
    }

    private JButton getOrButton() {
        if (this.ivjOrButton == null) {
            try {
                this.ivjOrButton = new JButton();
                this.ivjOrButton.setName("OrButton");
                this.ivjOrButton.setText("Or");
                this.ivjOrButton.setBackground(SystemColor.control);
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjOrButton;
    }

    private JToolBar getToolBar() {
        if (this.ivjToolBar == null) {
            try {
                this.ivjToolBar = new JToolBar();
                this.ivjToolBar.setName("ToolBar");
                this.ivjToolBar.setBackground(SystemColor.control);
                this.getToolBar().add((Component)this.getAndButton(), this.getAndButton().getName());
                this.getToolBar().add((Component)this.getOrButton(), this.getOrButton().getName());
                this.getToolBar().add((Component)this.getNotBuuton(), this.getNotBuuton().getName());
                this.ivjToolBar.addSeparator();
                this.getToolBar().add((Component)this.getClearButton(), this.getClearButton().getName());
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjToolBar;
    }

    private JLabel getValueLabel() {
        if (this.ivjValueLabel == null) {
            try {
                this.ivjValueLabel = new JLabel();
                this.ivjValueLabel.setName("ValueLabel");
                this.ivjValueLabel.setText("Value:");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjValueLabel;
    }

    private JTextField getValueText() {
        if (this.ivjValueText == null) {
            try {
                this.ivjValueText = new JTextField();
                this.ivjValueText.setName("ValueText");
            }
            catch (Throwable ivjExc) {
                this.handleException(ivjExc);
            }
        }
        return this.ivjValueText;
    }

    private void handleException(Throwable exception) {
        MessageDialog.displayException(exception, this);
    }

    private void initConnections() {
        this.getOrButton().addActionListener(this.ivjEventHandler);
        this.getAndButton().addActionListener(this.ivjEventHandler);
        this.getNotBuuton().addActionListener(this.ivjEventHandler);
        this.getClearButton().addActionListener(this.ivjEventHandler);
    }

    private void initialize() {
        try {
            this.setName("ExpressionPanel");
            this.setLayout(new GridBagLayout());
            this.setBackground(SystemColor.control);
            this.setSize(742, 472);
            GridBagConstraints constraintsAttributeLabel = new GridBagConstraints();
            constraintsAttributeLabel.gridx = 0;
            constraintsAttributeLabel.gridy = 0;
            constraintsAttributeLabel.anchor = 16;
            constraintsAttributeLabel.insets = new Insets(2, 2, 0, 2);
            this.add((Component)this.getAttributeLabel(), constraintsAttributeLabel);
            GridBagConstraints constraintsValueText = new GridBagConstraints();
            constraintsValueText.gridx = 2;
            constraintsValueText.gridy = 1;
            constraintsValueText.fill = 2;
            constraintsValueText.weightx = 0.2;
            constraintsValueText.ipadx = 20;
            constraintsValueText.insets = new Insets(0, 2, 2, 2);
            this.add((Component)this.getValueText(), constraintsValueText);
            GridBagConstraints constraintsAttributeCombo = new GridBagConstraints();
            constraintsAttributeCombo.gridx = 0;
            constraintsAttributeCombo.gridy = 1;
            constraintsAttributeCombo.fill = 2;
            constraintsAttributeCombo.weightx = 0.2;
            constraintsAttributeCombo.insets = new Insets(0, 2, 2, 2);
            this.add(this.getAttributeCombo(), constraintsAttributeCombo);
            GridBagConstraints constraintsOperatorCombo = new GridBagConstraints();
            constraintsOperatorCombo.gridx = 1;
            constraintsOperatorCombo.gridy = 1;
            constraintsOperatorCombo.fill = 2;
            constraintsOperatorCombo.weightx = 0.2;
            constraintsOperatorCombo.insets = new Insets(0, 2, 2, 2);
            this.add(this.getOperatorCombo(), constraintsOperatorCombo);
            GridBagConstraints constraintsOperatorLabel = new GridBagConstraints();
            constraintsOperatorLabel.gridx = 1;
            constraintsOperatorLabel.gridy = 0;
            constraintsOperatorLabel.anchor = 16;
            constraintsOperatorLabel.insets = new Insets(2, 2, 0, 2);
            this.add((Component)this.getOperatorLabel(), constraintsOperatorLabel);
            GridBagConstraints constraintsValueLabel = new GridBagConstraints();
            constraintsValueLabel.gridx = 2;
            constraintsValueLabel.gridy = 0;
            constraintsValueLabel.anchor = 16;
            constraintsValueLabel.insets = new Insets(2, 2, 0, 2);
            this.add((Component)this.getValueLabel(), constraintsValueLabel);
            GridBagConstraints constraintsExpressionTreeScroll = new GridBagConstraints();
            constraintsExpressionTreeScroll.gridx = 0;
            constraintsExpressionTreeScroll.gridy = 3;
            constraintsExpressionTreeScroll.gridwidth = 10;
            constraintsExpressionTreeScroll.fill = 1;
            constraintsExpressionTreeScroll.weightx = 1.0;
            constraintsExpressionTreeScroll.weighty = 0.6;
            constraintsExpressionTreeScroll.insets = new Insets(2, 2, 2, 2);
            this.add((Component)this.getExpressionTreeScroll(), constraintsExpressionTreeScroll);
            GridBagConstraints constraintsToolBar = new GridBagConstraints();
            constraintsToolBar.gridx = 0;
            constraintsToolBar.gridy = 2;
            constraintsToolBar.gridwidth = 3;
            constraintsToolBar.fill = 1;
            this.add((Component)this.getToolBar(), constraintsToolBar);
            this.initConnections();
        }
        catch (Throwable ivjExc) {
            this.handleException(ivjExc);
        }
        this.reset();
    }

    public void notExpression() {
        if (this.getExpression() != null) {
            this.setExpression(this.getExpression().not());
        }
    }

    public void orExpression() {
        Expression newExpression = this.buildExpressionNode();
        if (newExpression == null) {
            return;
        }
        if (this.getExpression() == null) {
            this.setExpression(newExpression);
        } else {
            this.setExpression(this.getExpression().or(newExpression));
        }
    }

    public void reset() {
        this.resetAttributes();
        if (this.getOperatorCombo().getItemCount() == 0) {
            this.resetOperators();
        }
        this.setExpression(null);
    }

    public void resetAttributes() {
        if (this.getAttributeCombo().getItemCount() > 0) {
            this.getAttributeCombo().removeAllItems();
        }
        if (this.getDescriptor() != null) {
            Enumeration mappingsEnum = this.getDescriptor().getMappings().elements();
            while (mappingsEnum.hasMoreElements()) {
                DatabaseMapping mapping = (DatabaseMapping)mappingsEnum.nextElement();
                if (!mapping.isDirectToFieldMapping()) continue;
                this.getAttributeCombo().addItem(mapping.getAttributeName());
            }
        }
    }

    public void resetOperators() {
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(4));
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(5));
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(7));
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(8));
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(9));
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(10));
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(11));
        this.getOperatorCombo().addItem(ExpressionNode.getOperator(12));
        this.getOperatorCombo().addItem(ExpressionNode.KeyWordAll);
        this.getOperatorCombo().addItem(ExpressionNode.KeyWordAny);
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
        this.reset();
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
        ExpressionTreeModel model = new ExpressionTreeModel(new ExpressionNode(expression));
        this.getExpressionTree().setModel(model);
        for (int index = 0; index < this.getExpressionTree().getRowCount(); ++index) {
            this.getExpressionTree().expandRow(index);
        }
        this.getExpressionTree().repaint();
    }

    class IvjEventHandler
    implements ActionListener {
        IvjEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == ExpressionPanel.this.getOrButton()) {
                ExpressionPanel.this.connEtoC1(e);
            }
            if (e.getSource() == ExpressionPanel.this.getAndButton()) {
                ExpressionPanel.this.connEtoC2(e);
            }
            if (e.getSource() == ExpressionPanel.this.getNotBuuton()) {
                ExpressionPanel.this.connEtoC3(e);
            }
            if (e.getSource() == ExpressionPanel.this.getClearButton()) {
                ExpressionPanel.this.connEtoC4(e);
            }
        }
    }
}

