/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.ops;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.KeyRange;
import oracle.kv.impl.api.ops.InternalOperation;
import oracle.kv.impl.api.ops.MultiGetTableOperation;
import oracle.kv.impl.api.table.TargetTables;
import oracle.kv.impl.util.ObjectUtil;
import oracle.kv.impl.util.SerializationUtil;

abstract class MultiGetBatchTableOperation
extends MultiGetTableOperation {
    private final List<byte[]> keys;
    private final int batchSize;
    private final byte[] resumeKey;

    public MultiGetBatchTableOperation(InternalOperation.OpCode opCode, List<byte[]> parentKeys, byte[] resumeKey, TargetTables targetTables, KeyRange subRange, int batchSize) {
        super(opCode, parentKeys.get(0), targetTables, subRange);
        for (byte[] key : parentKeys) {
            ObjectUtil.checkNull("parentKeys element", key);
        }
        this.keys = parentKeys;
        this.resumeKey = resumeKey;
        this.batchSize = batchSize;
    }

    protected MultiGetBatchTableOperation(InternalOperation.OpCode opCode, DataInput in, short serialVersion) throws IOException {
        super(opCode, in, serialVersion);
        int nkeys;
        int n = nkeys = serialVersion >= 14 ? SerializationUtil.readSequenceLength(in) : (int)in.readShort();
        if (nkeys >= 0) {
            this.keys = new ArrayList<byte[]>(nkeys);
            for (int i = 0; i < nkeys; ++i) {
                this.keys.add(SerializationUtil.readNonNullByteArrayOldShortLength(in, serialVersion));
            }
        } else {
            this.keys = null;
        }
        this.resumeKey = SerializationUtil.readByteArrayOldShortLength(in, serialVersion);
        this.batchSize = in.readInt();
    }

    List<byte[]> getParentKeys() {
        return this.keys;
    }

    int getBatchSize() {
        return this.batchSize;
    }

    byte[] getResumeKey() {
        return this.resumeKey;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        boolean useStdUTF8;
        super.writeFastExternal(out, serialVersion);
        boolean bl = useStdUTF8 = serialVersion >= 14;
        if (useStdUTF8) {
            SerializationUtil.writeCollectionLength(out, this.keys);
        } else {
            out.writeShort(this.keys != null ? this.keys.size() : -1);
        }
        if (this.keys != null) {
            for (byte[] key : this.keys) {
                SerializationUtil.writeNonNullByteArrayOldShortLength(out, serialVersion, key);
            }
        }
        SerializationUtil.writeByteArrayOldShortLength(out, serialVersion, this.resumeKey);
        out.writeInt(this.batchSize);
    }
}

