/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.util;

import oracle.kv.impl.util.PollConditionFunc;

public abstract class PollCondition {
    private final int checkPeriodMs;
    private final long timeoutMs;

    public PollCondition(int checkPeriodMs, long timeoutMs) {
        assert ((long)checkPeriodMs <= timeoutMs);
        this.checkPeriodMs = checkPeriodMs;
        this.timeoutMs = timeoutMs;
    }

    protected abstract boolean condition();

    public boolean await() {
        return PollCondition.await(this.checkPeriodMs, this.timeoutMs, () -> this.condition());
    }

    public static boolean await(int checkPeriodMs, long timeoutMs, PollConditionFunc conditionFunc) {
        long ts = System.currentTimeMillis();
        long tm = Math.min(timeoutMs, Long.MAX_VALUE - ts);
        long timeLimit = ts + tm;
        do {
            if (conditionFunc.condition()) {
                return true;
            }
            try {
                Thread.sleep(checkPeriodMs);
            }
            catch (InterruptedException e) {
                return false;
            }
        } while (System.currentTimeMillis() < timeLimit);
        return false;
    }
}

